/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceFile;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceFile;
import com.android.build.gradle.internal.api.artifact.SourceArtifactType;
import com.android.builder.model.SourceProvider;
import com.android.utils.StringHelper;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0002\b\u0017\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0014\u0010\f\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\b\u0010&\u001a\u00020\u000bH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010(\u001a\u00020\u000bH\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0+H\u0016J\b\u0010,\u001a\u00020\u0013H\u0016J\b\u0010-\u001a\u00020\u001cH\u0016J\b\u0010.\u001a\u00020\u0004H\u0016J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0002J\b\u00100\u001a\u00020\u0004H\u0016J\b\u00101\u001a\u00020\u0004H\u0016J\b\u00102\u001a\u00020\u000bH\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u00104\u001a\u00020\u000bH\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u00106\u001a\u00020\u000bH\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u00108\u001a\u00020\u0004H\u0016J\b\u00109\u001a\u00020\u000bH\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001c0+H\u0016J\b\u0010;\u001a\u00020\u0004H\u0016J\u0010\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0014\u0010>\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0014\u0010\u0010\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0014\u0010\u0011\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0014\u0010\u0012\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0014\u0010\u0014\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0014\u0010\u0015\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0014\u0010?\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0010\u0010@\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\u0004H\u0016J\u0014\u0010\u0016\u001a\u00020\u00012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\b\u0010A\u001a\u00020\u0004H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/android/build/gradle/internal/api/DefaultAndroidSourceSet;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "Lcom/android/builder/model/SourceProvider;", "name", "", "project", "Lorg/gradle/api/Project;", "publishPackage", "", "(Ljava/lang/String;Lorg/gradle/api/Project;Z)V", "aidl", "Lcom/android/build/gradle/api/AndroidSourceDirectorySet;", "assets", "displayName", "javaResources", "javaSource", "jni", "jniLibs", "manifest", "Lcom/android/build/gradle/api/AndroidSourceFile;", "renderscript", "res", "shaders", "configureClosure", "Lgroovy/lang/Closure;", "getAidl", "getAidlDirectories", "", "Ljava/io/File;", "getAnnotationProcessorConfigurationName", "getApiConfigurationName", "getAssets", "getAssetsDirectories", "getCDirectories", "getCompileConfigurationName", "getCompileOnlyConfigurationName", "getCppDirectories", "getImplementationConfigurationName", "getJava", "getJavaDirectories", "getJni", "getJniLibs", "getJniLibsDirectories", "", "getManifest", "getManifestFile", "getName", "config", "getPackageConfigurationName", "getProvidedConfigurationName", "getRenderscript", "getRenderscriptDirectories", "getRes", "getResDirectories", "getResources", "getResourcesDirectories", "getRuntimeOnlyConfigurationName", "getShaders", "getShadersDirectories", "getWearAppConfigurationName", "initRoot", "path", "java", "resources", "setRoot", "toString", "gradle"})
public class DefaultAndroidSourceSet
implements AndroidSourceSet,
SourceProvider {
    private final AndroidSourceDirectorySet javaSource;
    private final AndroidSourceDirectorySet javaResources;
    private final AndroidSourceFile manifest;
    private final AndroidSourceDirectorySet assets;
    private final AndroidSourceDirectorySet res;
    private final AndroidSourceDirectorySet aidl;
    private final AndroidSourceDirectorySet renderscript;
    private final AndroidSourceDirectorySet jni;
    private final AndroidSourceDirectorySet jniLibs;
    private final AndroidSourceDirectorySet shaders;
    private final String displayName;
    private final String name;
    private final boolean publishPackage;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String toString() {
        return "source set " + this.displayName;
    }

    private final String getName(String config2) {
        return Intrinsics.areEqual((Object)this.name, (Object)"main") ? config2 : StringHelper.appendCapitalized((String)this.name, (String)config2);
    }

    @Override
    @NotNull
    public String getApiConfigurationName() {
        return this.getName("api");
    }

    @Override
    @NotNull
    public String getCompileOnlyConfigurationName() {
        return this.getName("compileOnly");
    }

    @Override
    @NotNull
    public String getImplementationConfigurationName() {
        return this.getName("implementation");
    }

    @Override
    @NotNull
    public String getRuntimeOnlyConfigurationName() {
        return this.getName("runtimeOnly");
    }

    @Override
    @NotNull
    public String getCompileConfigurationName() {
        return this.getName("compile");
    }

    @Override
    @NotNull
    public String getPackageConfigurationName() {
        if (this.publishPackage) {
            return this.getName("publish");
        }
        return this.getName("apk");
    }

    @Override
    @NotNull
    public String getProvidedConfigurationName() {
        return this.getName("provided");
    }

    @Override
    @NotNull
    public String getWearAppConfigurationName() {
        return this.getName("wearApp");
    }

    @Override
    @NotNull
    public String getAnnotationProcessorConfigurationName() {
        return this.getName("annotationProcessor");
    }

    @Override
    @NotNull
    public AndroidSourceFile getManifest() {
        return this.manifest;
    }

    @NotNull
    public AndroidSourceSet manifest(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getManifest());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getRes() {
        return this.res;
    }

    @NotNull
    public AndroidSourceSet res(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getRes());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getAssets() {
        return this.assets;
    }

    @NotNull
    public AndroidSourceSet assets(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getAssets());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getAidl() {
        return this.aidl;
    }

    @NotNull
    public AndroidSourceSet aidl(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getAidl());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getRenderscript() {
        return this.renderscript;
    }

    @NotNull
    public AndroidSourceSet renderscript(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getRenderscript());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getJni() {
        return this.jni;
    }

    @NotNull
    public AndroidSourceSet jni(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getJni());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getJniLibs() {
        return this.jniLibs;
    }

    @NotNull
    public AndroidSourceSet jniLibs(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getJniLibs());
        return this;
    }

    @NotNull
    public AndroidSourceSet shaders(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getShaders());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getShaders() {
        return this.shaders;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getJava() {
        return this.javaSource;
    }

    @NotNull
    public AndroidSourceSet java(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceDirectorySet getResources() {
        return this.javaResources;
    }

    @NotNull
    public AndroidSourceSet resources(@NotNull Closure<?> configureClosure) {
        Intrinsics.checkParameterIsNotNull(configureClosure, (String)"configureClosure");
        ConfigureUtil.configure(configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    @NotNull
    public AndroidSourceSet setRoot(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.initRoot(path);
    }

    private final AndroidSourceSet initRoot(String path) {
        this.javaSource.setSrcDirs(CollectionsKt.listOf((Object)(path + "/java")));
        this.javaResources.setSrcDirs(CollectionsKt.listOf((Object)(path + "/resources")));
        this.res.setSrcDirs(CollectionsKt.listOf((Object)(path + "/res")));
        this.assets.setSrcDirs(CollectionsKt.listOf((Object)(path + "/assets")));
        this.manifest.srcFile(path + "/AndroidManifest.xml");
        this.aidl.setSrcDirs(CollectionsKt.listOf((Object)(path + "/aidl")));
        this.renderscript.setSrcDirs(CollectionsKt.listOf((Object)(path + "/rs")));
        this.jni.setSrcDirs(CollectionsKt.listOf((Object)(path + "/jni")));
        this.jniLibs.setSrcDirs(CollectionsKt.listOf((Object)(path + "/jniLibs")));
        this.shaders.setSrcDirs(CollectionsKt.listOf((Object)(path + "/shaders")));
        return this;
    }

    @NotNull
    public Set<File> getJavaDirectories() {
        Set<File> set = this.getJava().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"java.srcDirs");
        return set;
    }

    @NotNull
    public Set<File> getResourcesDirectories() {
        Set<File> set = this.getResources().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"resources.srcDirs");
        return set;
    }

    @NotNull
    public File getManifestFile() {
        File file = this.getManifest().getSrcFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getManifest().srcFile");
        return file;
    }

    @NotNull
    public Set<File> getAidlDirectories() {
        Set<File> set = this.getAidl().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getAidl().srcDirs");
        return set;
    }

    @NotNull
    public Set<File> getRenderscriptDirectories() {
        Set<File> set = this.getRenderscript().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getRenderscript().srcDirs");
        return set;
    }

    @NotNull
    public Set<File> getCDirectories() {
        Set<File> set = this.getJni().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getJni().srcDirs");
        return set;
    }

    @NotNull
    public Set<File> getCppDirectories() {
        Set<File> set = this.getJni().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getJni().srcDirs");
        return set;
    }

    @NotNull
    public Set<File> getResDirectories() {
        Set<File> set = this.getRes().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getRes().srcDirs");
        return set;
    }

    @NotNull
    public Set<File> getAssetsDirectories() {
        Set<File> set = this.getAssets().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getAssets().srcDirs");
        return set;
    }

    @NotNull
    public Collection<File> getJniLibsDirectories() {
        Set<File> set = this.getJniLibs().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getJniLibs().srcDirs");
        return set;
    }

    @NotNull
    public Collection<File> getShadersDirectories() {
        Set<File> set = this.getShaders().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"getShaders().srcDirs");
        return set;
    }

    @Inject
    public DefaultAndroidSourceSet(@NotNull String name, @NotNull Project project2, boolean publishPackage) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.name = name;
        this.publishPackage = publishPackage;
        String string = GUtil.toWords((CharSequence)this.name);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GUtil.toWords(this.name)");
        this.displayName = string;
        this.javaSource = new DefaultAndroidSourceDirectorySet(this.displayName + " Java source", project2, SourceArtifactType.JAVA_SOURCES);
        ((DefaultAndroidSourceDirectorySet)this.javaSource).getFilter().include(new String[]{"**/*.java"});
        this.javaResources = new DefaultAndroidSourceDirectorySet(this.displayName + " Java resources", project2, SourceArtifactType.JAVA_RESOURCES);
        ((DefaultAndroidSourceDirectorySet)this.javaResources).getFilter().exclude(new String[]{"**/*.java", "**/*.kt"});
        this.manifest = new DefaultAndroidSourceFile(this.displayName + " manifest", project2);
        this.assets = new DefaultAndroidSourceDirectorySet(this.displayName + " assets", project2, SourceArtifactType.ASSETS);
        this.res = new DefaultAndroidSourceDirectorySet(this.displayName + " resources", project2, SourceArtifactType.ANDROID_RESOURCES);
        this.aidl = new DefaultAndroidSourceDirectorySet(this.displayName + " aidl", project2, SourceArtifactType.AIDL);
        this.renderscript = new DefaultAndroidSourceDirectorySet(this.displayName + " renderscript", project2, SourceArtifactType.RENDERSCRIPT);
        this.jni = new DefaultAndroidSourceDirectorySet(this.displayName + " jni", project2, SourceArtifactType.JNI);
        this.jniLibs = new DefaultAndroidSourceDirectorySet(this.displayName + " jniLibs", project2, SourceArtifactType.JNI_LIBS);
        this.shaders = new DefaultAndroidSourceDirectorySet(this.displayName + " shaders", project2, SourceArtifactType.SHADERS);
        this.initRoot("src/" + this.name);
    }
}

