/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildElementsCopyParams;
import com.android.build.gradle.internal.scope.BuildElementsCopyRunnable;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.CopyOutputs$CreationAction$handleProvider$1;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/tasks/CopyOutputs;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "abiSplits", "Lorg/gradle/api/file/DirectoryProperty;", "getAbiSplits", "()Lorg/gradle/api/file/DirectoryProperty;", "destinationDir", "getDestinationDir", "fullApks", "getFullApks", "resourcesSplits", "getResourcesSplits", "copy", "Ljava/util/concurrent/Callable;", "Lcom/android/build/gradle/internal/scope/BuildElements;", "inputType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "inputs", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class CopyOutputs
extends NonIncrementalTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getDestinationDir();

    @InputFiles
    @NotNull
    public abstract DirectoryProperty getFullApks();

    @InputFiles
    @Optional
    @NotNull
    public abstract DirectoryProperty getAbiSplits();

    @InputFiles
    @Optional
    @NotNull
    public abstract DirectoryProperty getResourcesSplits();

    @Override
    protected void doTaskAction() {
        Object object = this.getDestinationDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"destinationDir.get()");
        FileUtils.cleanOutputDir((File)((Directory)object).getAsFile());
        ArrayList<Callable<BuildElements>> buildElementsCallables = new ArrayList<Callable<BuildElements>>();
        buildElementsCallables.add(this.copy(InternalArtifactType.FULL_APK, this.getFullApks()));
        buildElementsCallables.add(this.copy(InternalArtifactType.ABI_PACKAGED_SPLIT, this.getAbiSplits()));
        buildElementsCallables.add(this.copy(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, this.getResourcesSplits()));
        ImmutableList.Builder buildOutputs = ImmutableList.builder();
        for (Callable callable : buildElementsCallables) {
            try {
                buildOutputs.addAll((Iterable)callable.call());
            }
            catch (Exception e) {
                throw (Throwable)new ExecutionException(e);
            }
        }
        ImmutableList immutableList = buildOutputs.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"buildOutputs.build()");
        BuildElements buildElements = new BuildElements((Collection)immutableList);
        Object object2 = this.getDestinationDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"destinationDir.get()");
        File file = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"destinationDir.get().asFile");
        buildElements.save(file);
    }

    private final Callable<BuildElements> copy(InternalArtifactType inputType, DirectoryProperty inputs) {
        return ExistingBuildElements.Companion.from((ArtifactType)inputType, (Provider<Directory>)((Provider)inputs)).transform(this.getWorkerFacadeWithWorkers(), BuildElementsCopyRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)new Function2<ApkData, File, BuildElementsCopyParams>(this){
            final /* synthetic */ CopyOutputs this$0;

            @NotNull
            public final BuildElementsCopyParams invoke(@NotNull ApkData $noName_0, @NotNull File inputFile) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
                Object object = this.this$0.getDestinationDir().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"destinationDir.get()");
                return new BuildElementsCopyParams(inputFile, new File(((Directory)object).getAsFile(), inputFile.getName()));
            }
            {
                this.this$0 = copyOutputs;
                super(2);
            }
        })).intoCallable(InternalArtifactType.APK);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/tasks/CopyOutputs$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/CopyOutputs;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "destinationDir", "Ljava/io/File;", "(Lcom/android/build/gradle/internal/scope/VariantScope;Ljava/io/File;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CopyOutputs> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<CopyOutputs> type;
        private final File destinationDir;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<CopyOutputs> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends CopyOutputs> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.APK, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)CopyOutputs$CreationAction$handleProvider$1.INSTANCE, this.destinationDir.getAbsolutePath(), "");
        }

        @Override
        public void configure(@NotNull CopyOutputs task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildArtifactsHolder, (String)"variantScope.artifacts");
            BuildArtifactsHolder artifacts2 = buildArtifactsHolder;
            artifacts2.setTaskInputToFinalProduct(InternalArtifactType.FULL_APK, (Property)task.getFullApks());
            artifacts2.setTaskInputToFinalProduct(InternalArtifactType.ABI_PACKAGED_SPLIT, (Property)task.getAbiSplits());
            artifacts2.setTaskInputToFinalProduct(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, (Property)task.getResourcesSplits());
        }

        public CreationAction(@NotNull VariantScope variantScope, @NotNull File destinationDir) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            Intrinsics.checkParameterIsNotNull((Object)destinationDir, (String)"destinationDir");
            super(variantScope);
            this.destinationDir = destinationDir;
            String string = variantScope.getTaskName("copyOutputs");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"copyOutputs\")");
            this.name = string;
            this.type = CopyOutputs.class;
        }
    }
}

