/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.build.gradle.internal.attribution.AttributionListenerInitializer;
import com.android.ide.common.attribution.AndroidGradlePluginAttributionData;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/attribution/AttributionBuildListener;", "Lorg/gradle/api/execution/TaskExecutionListener;", "Lorg/gradle/BuildListener;", "outputDirPath", "", "(Ljava/lang/String;)V", "taskNameToClassNameMap", "", "afterExecute", "", "task", "Lorg/gradle/api/Task;", "taskState", "Lorg/gradle/api/tasks/TaskState;", "beforeExecute", "buildFinished", "buildResult", "Lorg/gradle/BuildResult;", "buildStarted", "gradle", "Lorg/gradle/api/invocation/Gradle;", "getTaskClassName", "className", "projectsEvaluated", "projectsLoaded", "settingsEvaluated", "settings", "Lorg/gradle/api/initialization/Settings;"})
public final class AttributionBuildListener
implements TaskExecutionListener,
BuildListener {
    private final Map<String, String> taskNameToClassNameMap;
    private final String outputDirPath;

    public void buildFinished(@NotNull BuildResult buildResult) {
        Intrinsics.checkParameterIsNotNull((Object)buildResult, (String)"buildResult");
        AndroidGradlePluginAttributionData.Companion.save(new File(this.outputDirPath), new AndroidGradlePluginAttributionData(this.taskNameToClassNameMap));
        AttributionListenerInitializer.INSTANCE.unregister(buildResult.getGradle());
    }

    public void beforeExecute(@NotNull Task task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        String string = task.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.name");
        String string2 = task.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.javaClass.name");
        this.taskNameToClassNameMap.put(string, this.getTaskClassName(string2));
    }

    private final String getTaskClassName(String className) {
        if (StringsKt.endsWith$default((String)className, (String)"_Decorated", (boolean)false, (int)2, null)) {
            String string = className;
            int n = 0;
            int n2 = className.length() - "_Decorated".length();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return className;
    }

    public void afterExecute(@NotNull Task task, @NotNull TaskState taskState) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)taskState, (String)"taskState");
    }

    public void projectsLoaded(@NotNull Gradle gradle) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
    }

    public void buildStarted(@NotNull Gradle gradle) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
    }

    public void projectsEvaluated(@NotNull Gradle gradle) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
    }

    public void settingsEvaluated(@NotNull Settings settings2) {
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
    }

    public AttributionBuildListener(@NotNull String outputDirPath) {
        Intrinsics.checkParameterIsNotNull((Object)outputDirPath, (String)"outputDirPath");
        this.outputDirPath = outputDirPath;
        this.taskNameToClassNameMap = new ConcurrentHashMap();
    }
}

