/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.structureplugin;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.plugins.BasePlugin;
import com.android.build.gradle.internal.tasks.structureplugin.AndroidBuildConfig;
import com.android.build.gradle.internal.tasks.structureplugin.DataCollector;
import com.android.build.gradle.internal.tasks.structureplugin.GatherModuleInfoTask;
import com.android.build.gradle.internal.tasks.structureplugin.GatherModuleInfoTaskKt;
import com.android.build.gradle.internal.tasks.structureplugin.ModuleInfo;
import com.android.build.gradle.internal.tasks.structureplugin.ModuleType;
import com.android.build.gradle.internal.tasks.structureplugin.PoetResourceInfo;
import com.android.builder.model.ApiVersion;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParser;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/structureplugin/AndroidCollector;", "Lcom/android/build/gradle/internal/tasks/structureplugin/DataCollector;", "()V", "collectBuildConfig", "", "dataHolder", "Lcom/android/build/gradle/internal/tasks/structureplugin/ModuleInfo;", "plugin", "Lcom/android/build/gradle/internal/plugins/BasePlugin;", "collectInto", "task", "Lcom/android/build/gradle/internal/tasks/structureplugin/GatherModuleInfoTask;", "collectResources", "gradle"})
final class AndroidCollector
implements DataCollector {
    @Override
    public void collectInto(@NotNull ModuleInfo dataHolder, @NotNull GatherModuleInfoTask task) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)dataHolder, (String)"dataHolder");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            Project project2 = task.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"task.project");
            if (!GatherModuleInfoTaskKt.access$isAndroidProject(project2)) {
                return;
            }
            dataHolder.setType(ModuleType.ANDROID);
            Project project3 = task.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"task.project");
            PluginCollection pluginCollection = project3.getPlugins().withType(BasePlugin.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)pluginCollection, (String)"task.project.plugins.wit\u2026e(BasePlugin::class.java)");
            BasePlugin basePlugin = (BasePlugin)CollectionsKt.firstOrNull((Iterable)((Iterable)pluginCollection));
            if (basePlugin == null) break block1;
            BasePlugin basePlugin2 = basePlugin;
            boolean bl = false;
            boolean bl2 = false;
            BasePlugin it = basePlugin2;
            boolean bl3 = false;
            this.collectBuildConfig(dataHolder, it);
            this.collectResources(dataHolder, it);
        }
    }

    private final void collectBuildConfig(ModuleInfo dataHolder, BasePlugin plugin) {
        int it;
        boolean bl;
        boolean bl2;
        int n;
        BaseExtension baseExtension = plugin.getExtension();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension, (String)"plugin.extension");
        DefaultConfig defaultConfig = baseExtension.getDefaultConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultConfig, (String)"plugin.extension.defaultConfig");
        ApiVersion apiVersion = defaultConfig.getMinSdkVersion();
        if (apiVersion != null) {
            n = apiVersion.getApiLevel();
            bl2 = false;
            bl = false;
            it = n;
            boolean bl3 = false;
            dataHolder.getAndroidBuildConfig().setMinSdkVersion(it);
        }
        BaseExtension baseExtension2 = plugin.getExtension();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension2, (String)"plugin.extension");
        DefaultConfig defaultConfig2 = baseExtension2.getDefaultConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultConfig2, (String)"plugin.extension.defaultConfig");
        ApiVersion apiVersion2 = defaultConfig2.getTargetSdkVersion();
        if (apiVersion2 != null) {
            n = apiVersion2.getApiLevel();
            bl2 = false;
            bl = false;
            it = n;
            boolean bl4 = false;
            dataHolder.getAndroidBuildConfig().setTargetSdkVersion(it);
        }
        AndroidBuildConfig androidBuildConfig = dataHolder.getAndroidBuildConfig();
        BaseExtension baseExtension3 = plugin.getExtension();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension3, (String)"plugin.extension");
        AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)baseExtension3.getCompileSdkVersion());
        if (androidVersion == null) {
            Intrinsics.throwNpe();
        }
        androidBuildConfig.setCompileSdkVersion(androidVersion.getApiLevel());
    }

    private final void collectResources(ModuleInfo dataHolder, BasePlugin plugin) {
        BaseExtension baseExtension = plugin.getExtension();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension, (String)"plugin.extension");
        Object object = (AndroidSourceSet)baseExtension.getSourceSets().findByName("main");
        if (object == null || (object = object.getRes()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"plugin.extension.sourceS\u2026_SET_NAME)?.res ?: return");
        Object resources = object;
        Set<File> set = resources.getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"resources.srcDirs");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            File file = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            SymbolTable symbolTable = ResourceDirectoryParser.parseResourceSourceSetDirectory$default((File)file, (IdProvider)IdProvider.Companion.constant(), null, null, (int)8, null);
            PoetResourceInfo poetResourceInfo = dataHolder.getResources();
            poetResourceInfo.setImageCount(poetResourceInfo.getImageCount() + symbolTable.getSymbolByResourceType(ResourceType.DRAWABLE).size());
            PoetResourceInfo poetResourceInfo2 = dataHolder.getResources();
            poetResourceInfo2.setLayoutCount(poetResourceInfo2.getLayoutCount() + symbolTable.getSymbolByResourceType(ResourceType.LAYOUT).size());
            PoetResourceInfo poetResourceInfo3 = dataHolder.getResources();
            poetResourceInfo3.setStringCount(poetResourceInfo3.getStringCount() + symbolTable.getSymbolByResourceType(ResourceType.STRING).size());
        }
    }
}

