/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.tasks.IncrementalChangesUtils$WhenMappings;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableInputChanges;
import com.android.ide.common.resources.FileStatus;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileType;
import org.gradle.api.provider.Provider;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\u00a8\u0006\u0012"}, d2={"convert", "", "Lcom/android/builder/files/SerializableChange;", "changes", "", "Lorg/gradle/work/FileChange;", "Lcom/android/ide/common/resources/FileStatus;", "changeType", "Lorg/gradle/work/ChangeType;", "toSerializable", "change", "getChangesInSerializableForm", "Lcom/android/builder/files/SerializableInputChanges;", "Lorg/gradle/work/InputChanges;", "input", "Lorg/gradle/api/file/FileCollection;", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "gradle"})
@JvmName(name="IncrementalChangesUtils")
public final class IncrementalChangesUtils {
    @NotNull
    public static final SerializableInputChanges getChangesInSerializableForm(@NotNull InputChanges $this$getChangesInSerializableForm, @NotNull Provider<? extends FileSystemLocation> input) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getChangesInSerializableForm, (String)"$this$getChangesInSerializableForm");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        Object object = input.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"input.get()");
        ImmutableList immutableList = ImmutableList.of((Object)((FileSystemLocation)object).getAsFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(input.get().asFile)");
        List list = (List)immutableList;
        Iterable iterable = $this$getChangesInSerializableForm.getFileChanges(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"getFileChanges(input)");
        return new SerializableInputChanges(list, IncrementalChangesUtils.convert(iterable));
    }

    @NotNull
    public static final SerializableInputChanges getChangesInSerializableForm(@NotNull InputChanges $this$getChangesInSerializableForm, @NotNull FileCollection input) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getChangesInSerializableForm, (String)"$this$getChangesInSerializableForm");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Set set = input.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"input.files");
        List list = (List)GuavaKtxKt.toImmutableList(set);
        Iterable iterable = $this$getChangesInSerializableForm.getFileChanges(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"getFileChanges(input)");
        return new SerializableInputChanges(list, IncrementalChangesUtils.convert(iterable));
    }

    private static final Collection<SerializableChange> convert(Iterable<? extends FileChange> changes) {
        ArrayList<SerializableChange> arrayList = new ArrayList<SerializableChange>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<SerializableChange> collection = arrayList;
        boolean bl3 = false;
        for (FileChange fileChange : changes) {
            if (fileChange.getFileType() != FileType.FILE) continue;
            collection.add(IncrementalChangesUtils.toSerializable(fileChange));
        }
        Collection<SerializableChange> collection2 = Collections.unmodifiableCollection((Collection)arrayList);
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"Collections.unmodifiable\u2026       }\n        }\n    })");
        return collection2;
    }

    private static final FileStatus convert(ChangeType changeType) {
        FileStatus fileStatus;
        switch (IncrementalChangesUtils$WhenMappings.$EnumSwitchMapping$0[changeType.ordinal()]) {
            case 1: {
                fileStatus = FileStatus.NEW;
                break;
            }
            case 2: {
                fileStatus = FileStatus.CHANGED;
                break;
            }
            case 3: {
                fileStatus = FileStatus.REMOVED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileStatus;
    }

    private static final SerializableChange toSerializable(FileChange change) {
        File file = change.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"change.file");
        ChangeType changeType = change.getChangeType();
        Intrinsics.checkExpressionValueIsNotNull((Object)changeType, (String)"change.changeType");
        FileStatus fileStatus = IncrementalChangesUtils.convert(changeType);
        String string = change.getNormalizedPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"change.normalizedPath");
        return new SerializableChange(file, fileStatus, string);
    }
}

