/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.testing.api.TestServer;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;

public abstract class TestServerTask
extends NonIncrementalTask {
    TestServer testServer;

    @Override
    protected void doTaskAction() {
        ImmutableList testedApkFiles;
        Object object = testedApkFiles = this.getTestedApks().isPresent() ? ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.APK.INSTANCE, (Provider<Directory>)this.getTestedApks()).stream().map(BuildOutput::getOutputFile).collect(Collectors.toList()) : ImmutableList.of();
        if (testedApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs");
        }
        File testedApkFile = testedApkFiles.isEmpty() ? null : (File)testedApkFiles.get(0);
        List testApkFiles = ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.APK.INSTANCE, (Provider<Directory>)this.getTestApks()).stream().map(BuildOutput::getOutputFile).collect(Collectors.toList());
        if (testApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs in test APKs");
        }
        this.testServer.uploadApks(this.getVariantName(), (File)testApkFiles.get(0), testedApkFile);
    }

    @InputFiles
    public abstract DirectoryProperty getTestApks();

    @InputFiles
    @Optional
    public abstract DirectoryProperty getTestedApks();

    @Override
    @Input
    public String getVariantName() {
        return super.getVariantName();
    }

    public void setTestServer(TestServer testServer) {
        this.testServer = testServer;
    }

    public static class TestServerTaskCreationAction
    extends VariantTaskCreationAction<TestServerTask> {
        private final TestServer testServer;

        public TestServerTaskCreationAction(VariantScope scope, TestServer testServer) {
            super(scope);
            this.testServer = testServer;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getVariantConfiguration().hasFlavors() ? this.getVariantScope().getTaskName(this.testServer.getName() + "Upload") : this.testServer.getName() + "Upload";
        }

        @Override
        public Class<TestServerTask> getType() {
            return TestServerTask.class;
        }

        @Override
        public void configure(TestServerTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            BaseVariantData testedVariantData = scope.getTestedVariantData();
            String variantName = scope.getVariantConfiguration().getFullName();
            task.setDescription("Uploads APKs for Build '" + variantName + "' to Test Server '" + StringHelper.capitalize((String)this.testServer.getName()) + "'.");
            task.setGroup("verification");
            task.setTestServer(this.testServer);
            if (testedVariantData != null && testedVariantData.getScope().getArtifacts().hasFinalProduct(InternalArtifactType.APK.INSTANCE)) {
                testedVariantData.getScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APK.INSTANCE, task.getTestedApks());
            }
            scope.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APK.INSTANCE, task.getTestApks());
            if (!this.testServer.isConfigured()) {
                task.setEnabled(false);
            }
        }
    }
}

