/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.signing.SigningConfigProvider;
import com.android.build.gradle.internal.signing.SigningConfigProviderParams;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTaskKt;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.files.IncrementalChanges;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.KeyedFileCache;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableInputChanges;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.packaging.PackagingUtils;
import com.android.builder.utils.FileCache;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.resources.FileStatus;
import com.android.sdklib.AndroidVersion;
import com.android.tools.build.apkzlib.utils.IOExceptionWrapper;
import com.android.tools.build.apkzlib.zip.compress.Zip64NotSupportedException;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.Project;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileType;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

public abstract class PackageAndroidArtifact
extends NewIncrementalTask {
    protected ArtifactType<Directory> manifestType;
    private Set<String> abiFilters;
    private boolean debugBuild;
    private boolean jniDebugBuild;
    private SigningConfigProvider signingConfig;
    protected Supplier<AndroidVersion> minSdkVersion;
    protected Collection<String> aaptOptionsNoCompress;
    protected OutputScope outputScope;
    protected String projectBaseName;
    protected String buildTargetAbi;
    protected String buildTargetDensity;
    protected OutputFileProvider outputFileProvider;
    protected FileCache fileCache;
    protected Integer targetApi;
    protected IncrementalPackagerBuilder.ApkFormat apkFormat;
    private static final String ZIP_DIFF_CACHE_DIR = "zip-cache";
    private static final String ZIP_64_COPY_DIR = "zip64-copy";
    protected ArtifactType<Directory> taskInputType;
    protected ApkCreatorType apkCreatorType;

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getManifests();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getResourceFiles();

    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters != null ? abiFilters : ImmutableSet.of();
    }

    @OutputDirectory
    public abstract DirectoryProperty getIncrementalFolder();

    @Input
    public String getManifestTypeName() {
        return this.manifestType.name();
    }

    @Classpath
    @Incremental
    public abstract ConfigurableFileCollection getJavaResourceFiles();

    @Classpath
    @Incremental
    public abstract ConfigurableFileCollection getJniFolders();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getDexFolders();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getFeatureDexFolder();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getAssets();

    @Input
    public abstract Property<String> getCreatedBy();

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    @Optional
    public Integer getTargetApi() {
        return this.targetApi;
    }

    @Input
    public String getApkFormat() {
        return this.apkFormat.name();
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Input
    public boolean getDebugBuild() {
        return this.debugBuild;
    }

    public void setDebugBuild(boolean debugBuild) {
        this.debugBuild = debugBuild;
    }

    @Nested
    public SigningConfigProvider getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(SigningConfigProvider signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.get().getApiLevel();
    }

    @Input
    public List<String> getNativeLibrariesAndDexPackagingModeName() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ((Directory)this.getManifests().get()).getAsFileTree().getFiles().forEach(manifest -> {
            if (manifest.isFile() && manifest.getName().equals("AndroidManifest.xml")) {
                DefaultManifestParser parser = new DefaultManifestParser(manifest, () -> true, true, null);
                String extractNativeLibs = PackagingUtils.getNativeLibrariesLibrariesPackagingMode((ManifestAttributeSupplier)parser).toString();
                listBuilder.add((Object)extractNativeLibs);
                String useEmbeddedDex = PackagingUtils.getUseEmbeddedDex((ManifestAttributeSupplier)parser).toString();
                listBuilder.add((Object)useEmbeddedDex);
            }
        });
        return listBuilder.build();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return this.aaptOptionsNoCompress != null ? this.aaptOptionsNoCompress : Collections.emptyList();
    }

    @Input
    public String getTaskInputTypeName() {
        return this.taskInputType.name();
    }

    @Input
    @Optional
    public String getBuildTargetAbi() {
        return this.buildTargetAbi;
    }

    @Input
    @Optional
    public String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    public Collection<String> getApkNames() {
        return this.outputScope.getApkDatas().stream().filter(apkData -> apkData.getType() != VariantOutput.OutputType.SPLIT).map(ApkData::getOutputFileName).collect(Collectors.toList());
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getApkList();

    private static BuildOutput computeBuildOutputFile(ApkData apkInfo, OutputFileProvider outputFileProvider, File outputDirectory, ArtifactType<Directory> expectedOutputType) {
        File outputFile = outputFileProvider != null ? outputFileProvider.getOutputFile(apkInfo) : new File(outputDirectory, Objects.requireNonNull(apkInfo.getOutputFileName()));
        return new BuildOutput(expectedOutputType, apkInfo, outputFile);
    }

    @Input
    public ApkCreatorType getApkCreatorType() {
        return this.apkCreatorType;
    }

    @Internal
    protected abstract ArtifactType<Directory> getInternalArtifactType();

    @Override
    public void doTaskAction(InputChanges changes) {
        if (!changes.isIncremental()) {
            this.checkFileNameUniqueness();
        }
        HashSet<File> changedResourceFiles = new HashSet<File>();
        for (FileChange fileChange : changes.getFileChanges((FileCollection)this.getResourceFiles())) {
            if (fileChange.getFileType() != FileType.FILE) continue;
            changedResourceFiles.add(fileChange.getFile());
        }
        ExistingBuildElements.from(this.taskInputType, (FileCollection)this.getResourceFiles()).transform(this.getWorkerFacadeWithWorkers(), IncrementalSplitterRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, inputFile) -> new SplitterParams((ApkData)apkInfo, (File)inputFile, changedResourceFiles.contains(inputFile), changes, this, this.apkCreatorType))).into(this.getInternalArtifactType(), ((Directory)this.getOutputDirectory().get()).getAsFile());
    }

    private void checkFileNameUniqueness() {
        BuildElements buildElements = ExistingBuildElements.from(this.taskInputType, (FileCollection)this.getResourceFiles());
        PackageAndroidArtifact.checkFileNameUniqueness(buildElements);
    }

    @VisibleForTesting
    static void checkFileNameUniqueness(BuildElements buildElements) {
        Collection fileOutputs = buildElements.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList());
        java.util.Optional<String> repeatingFileNameOptional = fileOutputs.stream().filter(fileOutput -> Collections.frequency(fileOutputs, fileOutput) > 1).map(File::getName).findFirst();
        if (repeatingFileNameOptional.isPresent()) {
            String repeatingFileName = repeatingFileNameOptional.get();
            List conflictingApks = buildElements.stream().filter(buildOutput -> buildOutput.getOutputFile().getName().equals(repeatingFileName)).map(buildOutput -> {
                ApkData apkInfo = buildOutput.getApkData();
                if (apkInfo.getFilters().isEmpty()) {
                    return apkInfo.getType().toString();
                }
                return Joiner.on((String)"-").join(apkInfo.getFilters());
            }).collect(Collectors.toList());
            throw new RuntimeException(String.format("Several variant outputs are configured to use the same file name \"%1$s\", filters : %2$s", repeatingFileName, Joiner.on((String)":").join(conflictingApks)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static File copyJavaResourcesOnly(File destinationFolder, File zip64File) throws IOException {
        File cacheDir = new File(destinationFolder, ZIP_64_COPY_DIR);
        File copiedZip = new File(cacheDir, zip64File.getName());
        FileUtils.mkdirs((File)copiedZip.getParentFile());
        try (ZipFile inFile = new ZipFile(zip64File);
             ZipOutputStream outFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(copiedZip)));){
            Enumeration<? extends ZipEntry> entries = inFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getName().endsWith(".class") || !ZipEntryUtils.isValidZipEntryName((ZipEntry)zipEntry)) continue;
                outFile.putNextEntry(new ZipEntry(zipEntry.getName()));
                try {
                    ByteStreams.copy((InputStream)new BufferedInputStream(inFile.getInputStream(zipEntry)), (OutputStream)outFile);
                }
                finally {
                    outFile.closeEntry();
                }
            }
        }
        return copiedZip;
    }

    private static void doTask(File incrementalDirForSplit, File outputFile, KeyedFileCache cache, BuildElements manifestOutputs, Map<RelativeFile, FileStatus> changedDex, Map<RelativeFile, FileStatus> changedJavaResources, Map<RelativeFile, FileStatus> changedAssets, Map<RelativeFile, FileStatus> changedAndroidResources, Map<RelativeFile, FileStatus> changedNLibs, SplitterParams params) throws IOException {
        BuildOutput manifestForSplit;
        ImmutableMap.Builder javaResourcesForApk = ImmutableMap.builder();
        javaResourcesForApk.putAll(changedJavaResources);
        String filter = null;
        FilterData abiFilter = params.apkInfo.getFilter(VariantOutput.FilterType.ABI);
        if (abiFilter != null) {
            filter = abiFilter.getIdentifier();
        }
        if ((manifestForSplit = manifestOutputs.element(params.apkInfo)) == null) {
            throw new RuntimeException("Found a .ap_ for split " + params.apkInfo + " but no " + params.manifestType + " associated manifest file");
        }
        FileUtils.mkdirs((File)outputFile.getParentFile());
        DefaultManifestParser manifest = new DefaultManifestParser(manifestForSplit.getOutputFile(), () -> true, true, null);
        try (IncrementalPackager packager = new IncrementalPackagerBuilder(params.apkFormat, params.packagerMode).withOutputFile(outputFile).withSigning(params.signingConfig.resolve(), params.minSdkVersion, params.targetApi).withCreatedBy(params.createdBy).withNativeLibraryPackagingMode(PackagingUtils.getNativeLibrariesLibrariesPackagingMode((ManifestAttributeSupplier)manifest)).withNoCompressPredicate(PackagingUtils.getNoCompressPredicate(params.aaptOptionsNoCompress, (ManifestAttributeSupplier)manifest)).withIntermediateDir(incrementalDirForSplit).withDebuggableBuild(params.isDebuggableBuild).withAcceptedAbis((Set<String>)(filter == null ? params.abiFilters : ImmutableSet.of((Object)filter))).withJniDebuggableBuild(params.isJniDebuggableBuild).withApkCreatorType(params.apkCreatorType).withChangedDexFiles(changedDex).withChangedJavaResources(changedJavaResources).withChangedAssets(changedAssets).withChangedAndroidResources(changedAndroidResources).withChangedNativeLibs(changedNLibs).build();){
            packager.updateFiles();
        }
        Stream.concat(changedDex.keySet().stream(), Stream.concat(changedJavaResources.keySet().stream(), Stream.concat(changedAndroidResources.keySet().stream(), changedNLibs.keySet().stream()))).filter(it -> it.getType() == RelativeFile.Type.JAR).map(RelativeFile::getBase).distinct().forEach(f -> {
            try {
                cache.add(f);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        });
    }

    public static abstract class CreationAction<T extends PackageAndroidArtifact>
    extends VariantTaskCreationAction<T> {
        protected final Project project;
        protected final Provider<Directory> manifests;
        protected final ArtifactType<Directory> inputResourceFilesType;
        protected final OutputScope outputScope;
        private final FileCache fileCache;
        private final ArtifactType<Directory> manifestType;
        private final boolean packageCustomClassDependencies;

        public CreationAction(VariantScope variantScope, ArtifactType<Directory> inputResourceFilesType, Provider<Directory> manifests, ArtifactType<Directory> manifestType, FileCache fileCache, OutputScope outputScope, boolean packageCustomClassDependencies) {
            super(variantScope);
            this.project = variantScope.getGlobalScope().getProject();
            this.inputResourceFilesType = inputResourceFilesType;
            this.manifests = manifests;
            this.outputScope = outputScope;
            this.manifestType = manifestType;
            this.fileCache = fileCache;
            this.packageCustomClassDependencies = packageCustomClassDependencies;
        }

        @Override
        public void configure(T packageAndroidArtifact) {
            super.configure(packageAndroidArtifact);
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = variantScope.getGlobalScope();
            GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
            ((PackageAndroidArtifact)packageAndroidArtifact).taskInputType = this.inputResourceFilesType;
            ((PackageAndroidArtifact)packageAndroidArtifact).minSdkVersion = TaskInputHelper.memoize(variantScope::getMinSdkVersion);
            ((PackageAndroidArtifact)packageAndroidArtifact).getResourceFiles().from(new Object[]{variantScope.getArtifacts().getFinalProductAsFileCollection(this.inputResourceFilesType)});
            ((PackageAndroidArtifact)packageAndroidArtifact).getIncrementalFolder().set(new File(variantScope.getIncrementalDir(packageAndroidArtifact.getName()), "tmp"));
            ((PackageAndroidArtifact)packageAndroidArtifact).outputScope = this.outputScope;
            ((PackageAndroidArtifact)packageAndroidArtifact).fileCache = this.fileCache;
            ((PackageAndroidArtifact)packageAndroidArtifact).aaptOptionsNoCompress = DslAdaptersKt.convert(globalScope.getExtension().getAaptOptions()).getNoCompress();
            ((PackageAndroidArtifact)packageAndroidArtifact).getManifests().set(this.manifests);
            ((PackageAndroidArtifact)packageAndroidArtifact).getDexFolders().from(new Object[]{this.getDexFolders()});
            FileCollection featureDexFolder = this.getFeatureDexFolder();
            if (featureDexFolder != null) {
                ((PackageAndroidArtifact)packageAndroidArtifact).getFeatureDexFolder().from(new Object[]{featureDexFolder});
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getJavaResourceFiles().from(new Object[]{this.getJavaResources()});
            ((PackageAndroidArtifact)packageAndroidArtifact).getAssets().set(variantScope.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_ASSETS.INSTANCE));
            ((PackageAndroidArtifact)packageAndroidArtifact).setJniDebugBuild(((CoreBuildType)variantConfiguration.getBuildType()).isJniDebuggable());
            ((PackageAndroidArtifact)packageAndroidArtifact).setDebugBuild(((CoreBuildType)variantConfiguration.getBuildType()).isDebuggable());
            ProjectOptions projectOptions = variantScope.getGlobalScope().getProjectOptions();
            ((PackageAndroidArtifact)packageAndroidArtifact).projectBaseName = globalScope.getProjectBaseName();
            ((PackageAndroidArtifact)packageAndroidArtifact).manifestType = this.manifestType;
            String string = ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetAbi = globalScope.getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
            if (variantConfiguration.getSupportedAbis() != null) {
                ((PackageAndroidArtifact)packageAndroidArtifact).setAbiFilters(variantConfiguration.getSupportedAbis());
            } else {
                ((PackageAndroidArtifact)packageAndroidArtifact).setAbiFilters(projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) ? this.firstValidInjectedAbi(projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) : null);
            }
            String string2 = ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetDensity = globalScope.getExtension().getSplits().getDensity().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY) : null;
            ((PackageAndroidArtifact)packageAndroidArtifact).apkFormat = projectOptions.get(BooleanOption.DEPLOYMENT_USES_DIRECTORY) ? IncrementalPackagerBuilder.ApkFormat.DIRECTORY : (projectOptions.get(BooleanOption.DEPLOYMENT_PROVIDES_LIST_OF_CHANGES) ? IncrementalPackagerBuilder.ApkFormat.FILE_WITH_LIST_OF_CHANGES : IncrementalPackagerBuilder.ApkFormat.FILE);
            ((PackageAndroidArtifact)packageAndroidArtifact).targetApi = projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API);
            ((PackageAndroidArtifact)packageAndroidArtifact).apkCreatorType = variantScope.getApkCreatorType();
            ((PackageAndroidArtifact)packageAndroidArtifact).getCreatedBy().set((Object)globalScope.getCreatedBy());
            this.finalConfigure(packageAndroidArtifact);
        }

        protected void finalConfigure(T task) {
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = variantScope.getGlobalScope();
            if (variantScope.getVariantData().getMultiOutputPolicy() == MultiOutputPolicy.MULTI_APK) {
                ((PackageAndroidArtifact)task).getJniFolders().from(new Object[]{PerModuleBundleTaskKt.getNativeLibsFiles(variantScope, this.packageCustomClassDependencies)});
            } else {
                ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(globalScope.getExtension().getSplits().getAbiFilters());
                ((PackageAndroidArtifact)task).getJniFolders().from(new Object[]{filters.isEmpty() ? PerModuleBundleTaskKt.getNativeLibsFiles(variantScope, this.packageCustomClassDependencies) : this.project.files(new Object[0])});
            }
            variantScope.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APK_LIST.INSTANCE, ((PackageAndroidArtifact)task).getApkList());
            ((PackageAndroidArtifact)task).setSigningConfig(SigningConfigProvider.create(variantScope));
        }

        public FileCollection getDexFolders() {
            BuildArtifactsHolder artifacts2 = this.getVariantScope().getArtifacts();
            if (artifacts2.hasFinalProduct(InternalArtifactType.BASE_DEX.INSTANCE)) {
                return ((FileCollection)artifacts2.getFinalProductAsFileCollection(InternalArtifactType.BASE_DEX.INSTANCE).get()).plus(this.getDesugarLibDexIfExists());
            }
            return this.project.files(new Object[]{artifacts2.getFinalProducts(InternalArtifactType.DEX.INSTANCE)}).plus(this.getDesugarLibDexIfExists());
        }

        public FileCollection getJavaResources() {
            if (this.getVariantScope().getArtifacts().hasFinalProduct(InternalArtifactType.SHRUNK_JAVA_RES.INSTANCE)) {
                Provider<RegularFile> mergedJavaResProvider = this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.SHRUNK_JAVA_RES.INSTANCE);
                return this.project.getLayout().files(new Object[]{mergedJavaResProvider});
            }
            if (this.getVariantScope().getNeedsMergedJavaResStream()) {
                return this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.RESOURCES);
            }
            Provider<RegularFile> mergedJavaResProvider = this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.MERGED_JAVA_RES.INSTANCE);
            return this.project.getLayout().files(new Object[]{mergedJavaResProvider});
        }

        public FileCollection getFeatureDexFolder() {
            if (!this.getVariantScope().getType().isFeatureSplit()) {
                return null;
            }
            return this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_DEX, (Map<Attribute<String>, String>)ImmutableMap.of(AndroidArtifacts.MODULE_PATH, (Object)this.project.getPath()));
        }

        private Set<String> firstValidInjectedAbi(String abis) {
            if (abis == null) {
                return null;
            }
            Set allowedAbis = Abi.getDefaultValues().stream().map(Abi::getTag).collect(Collectors.toSet());
            java.util.Optional<String> firstValidAbi = Arrays.asList(abis.split(",")).stream().map(abi -> abi.trim()).filter(abi -> allowedAbis.contains(abi)).findFirst();
            return firstValidAbi.isPresent() ? ImmutableSet.of((Object)firstValidAbi.get()) : null;
        }

        private FileCollection getDesugarLibDexIfExists() {
            BuildArtifactsHolder artifacts2 = this.getVariantScope().getArtifacts();
            if (artifacts2.hasFinalProduct(InternalArtifactType.DESUGAR_LIB_DEX.INSTANCE)) {
                return this.project.files(new Object[]{artifacts2.getFinalProduct(InternalArtifactType.DESUGAR_LIB_DEX.INSTANCE)});
            }
            return DesugarLibUtils.getDesugarLibDexFromTransform(this.getVariantScope());
        }
    }

    private static class IncrementalSplitterRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public IncrementalSplitterRunnable(SplitterParams params) {
            super(params);
        }

        @Override
        public void run() {
            SplitterParams params = (SplitterParams)this.getParams();
            try {
                File incrementalDirForSplit = new File(params.incrementalFolder, params.apkInfo.getFullName());
                File cacheDir = new File(incrementalDirForSplit, PackageAndroidArtifact.ZIP_DIFF_CACHE_DIR);
                if (!cacheDir.exists()) {
                    FileUtils.mkdirs((File)cacheDir);
                }
                HashMap<File, String> cacheKeyMap = new HashMap<File, String>();
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "dex", params.dexFiles);
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "javaResources", params.javaResourceFiles);
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "assets", params.assetsFiles);
                cacheKeyMap.put(params.androidResourcesFile, "androidResources");
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "jniLibs", params.jniFiles);
                KeyedFileCache cache = new KeyedFileCache(cacheDir, file -> (String)Objects.requireNonNull(cacheKeyMap.get(file)));
                HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
                Map changedDexFiles = IncrementalChanges.classpathToRelativeFileSet((SerializableInputChanges)params.dexFiles, (KeyedFileCache)cache, cacheUpdates);
                Map<RelativeFile, FileStatus> changedJavaResources = IncrementalSplitterRunnable.getChangedJavaResources(params, cacheKeyMap, cache, cacheUpdates);
                Map changedAssets = IncrementalChanges.classpathToRelativeFileSet((SerializableInputChanges)params.assetsFiles, (KeyedFileCache)cache, cacheUpdates);
                Object changedAndroidResources = params.androidResourcesChanged ? IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)new ZipCentralDirectory(params.androidResourcesFile), (KeyedFileCache)cache, cacheUpdates) : ImmutableMap.of();
                Map changedJniLibs = IncrementalChanges.classpathToRelativeFileSet((SerializableInputChanges)params.jniFiles, (KeyedFileCache)cache, cacheUpdates);
                BuildElements manifestOutputs = ExistingBuildElements.from(params.manifestType, params.manifestDirectory);
                PackageAndroidArtifact.doTask(incrementalDirForSplit, params.getOutput(), cache, manifestOutputs, changedDexFiles, changedJavaResources, changedAssets, (Map)changedAndroidResources, changedJniLibs, params);
                cacheUpdates.forEach(Runnable::run);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (params.packagerMode == IncrementalPackagerBuilder.BuildType.CLEAN) {
                    PackageApplication.recordMetrics(params.projectPath, params.getOutput(), params.androidResourcesFile);
                }
            }
        }

        private static void addCacheKeys(Map<File, String> builder, String prefix, SerializableInputChanges changes) {
            List roots = changes.getRoots();
            for (int i2 = 0; i2 < roots.size(); ++i2) {
                builder.put((File)roots.get(i2), prefix + i2);
            }
        }

        private static Map<RelativeFile, FileStatus> getChangedJavaResources(SplitterParams params, Map<File, String> cacheKeyMap, KeyedFileCache cache, Set<Runnable> cacheUpdates) throws IOException {
            HashMap changedJavaResources = new HashMap();
            for (SerializableChange change : params.javaResourceFiles.getChanges()) {
                if (change.getNormalizedPath().isEmpty()) {
                    try {
                        IncrementalChanges.addZipChanges(changedJavaResources, (File)change.getFile(), (KeyedFileCache)cache, cacheUpdates);
                    }
                    catch (Zip64NotSupportedException e) {
                        File nonZip64 = PackageAndroidArtifact.copyJavaResourcesOnly(params.incrementalFolder, change.getFile());
                        cacheKeyMap.put(nonZip64, cacheKeyMap.get(change.getFile()));
                        IncrementalChanges.addZipChanges(changedJavaResources, (File)nonZip64, (KeyedFileCache)cache, cacheUpdates);
                    }
                    continue;
                }
                IncrementalChanges.addFileChange(changedJavaResources, (SerializableChange)change);
            }
            return Collections.unmodifiableMap(changedJavaResources);
        }
    }

    private static class SplitterParams
    extends BuildElementsTransformParams {
        ApkData apkInfo;
        public final String projectPath;
        File androidResourcesFile;
        protected final boolean androidResourcesChanged;
        protected final File outputFile;
        protected final File incrementalFolder;
        protected final SerializableInputChanges dexFiles;
        protected final SerializableInputChanges assetsFiles;
        protected final SerializableInputChanges jniFiles;
        protected final SerializableInputChanges javaResourceFiles;
        protected final ArtifactType<Directory> manifestType;
        protected final IncrementalPackagerBuilder.ApkFormat apkFormat;
        protected final SigningConfigProviderParams signingConfig;
        protected final Set<String> abiFilters;
        protected final File manifestDirectory;
        protected final Collection<String> aaptOptionsNoCompress;
        protected final String createdBy;
        protected final int minSdkVersion;
        protected final boolean isDebuggableBuild;
        protected final boolean isJniDebuggableBuild;
        protected final Integer targetApi;
        protected final IncrementalPackagerBuilder.BuildType packagerMode;
        protected final ApkCreatorType apkCreatorType;

        SplitterParams(ApkData apkInfo, File androidResourcesFile, boolean androidResourcesChanged, InputChanges changes, PackageAndroidArtifact task, ApkCreatorType apkCreatorType) {
            this.apkInfo = apkInfo;
            this.androidResourcesFile = androidResourcesFile;
            this.androidResourcesChanged = androidResourcesChanged;
            this.projectPath = task.getProject().getPath();
            this.apkCreatorType = apkCreatorType;
            this.outputFile = PackageAndroidArtifact.computeBuildOutputFile(apkInfo, task.outputFileProvider, ((Directory)task.getOutputDirectory().get()).getAsFile(), (ArtifactType<Directory>)task.getInternalArtifactType()).getOutputFile();
            this.incrementalFolder = ((Directory)task.getIncrementalFolder().get()).getAsFile();
            if (task.getFeatureDexFolder().isEmpty()) {
                this.dexFiles = IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)task.getDexFolders());
                this.javaResourceFiles = IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)task.getJavaResourceFiles());
            } else {
                this.dexFiles = IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)task.getFeatureDexFolder());
                this.javaResourceFiles = new SerializableInputChanges((List)ImmutableList.of(), (Collection)ImmutableSet.of());
            }
            this.assetsFiles = IncrementalChangesUtils.getChangesInSerializableForm(changes, (Provider<? extends FileSystemLocation>)task.getAssets());
            this.jniFiles = IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)task.getJniFolders());
            this.manifestType = task.manifestType;
            this.apkFormat = task.apkFormat;
            this.signingConfig = task.signingConfig.convertToParams();
            this.abiFilters = task.abiFilters;
            this.manifestDirectory = ((Directory)task.getManifests().get()).getAsFile();
            this.aaptOptionsNoCompress = task.aaptOptionsNoCompress;
            this.createdBy = (String)task.getCreatedBy().get();
            this.minSdkVersion = task.getMinSdkVersion();
            this.isDebuggableBuild = task.getDebugBuild();
            this.isJniDebuggableBuild = task.getJniDebugBuild();
            this.targetApi = task.getTargetApi();
            this.packagerMode = changes.isIncremental() ? IncrementalPackagerBuilder.BuildType.INCREMENTAL : IncrementalPackagerBuilder.BuildType.CLEAN;
        }

        @Override
        public File getOutput() {
            return this.outputFile;
        }
    }

    static interface OutputFileProvider {
        public File getOutputFile(ApkData var1);
    }
}

