/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParser;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/dependency/LibraryDefinedSymbolTableTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "getPackage", "", "manifest", "Ljava/nio/file/Path;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "gradle"})
public abstract class LibraryDefinedSymbolTableTransform
implements TransformAction<GenericTransformParameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs transformOutputs) {
        File explodedAar;
        Intrinsics.checkParameterIsNotNull((Object)transformOutputs, (String)"transformOutputs");
        Object object = this.getInputArtifact().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputArtifact.get()");
        File file = explodedAar = ((FileSystemLocation)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"explodedAar");
        File manifest = FilesKt.resolve((File)file, (String)"AndroidManifest.xml");
        File resDir = FilesKt.resolve((File)explodedAar, (String)"res");
        Path path = manifest.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"manifest.toPath()");
        String pkg = this.getPackage(path);
        File outputFile = transformOutputs.file((Object)(pkg + "-R-def.txt"));
        SymbolTable symbols = resDir.isDirectory() ? ResourceDirectoryParser.parseResourceSourceSetDirectory$default((File)resDir, (IdProvider)IdProvider.Companion.constant(), null, null, (int)8, null).rename(pkg) : SymbolTable.Companion.builder().tablePackage(pkg).build();
        SymbolIo.writeRDef((SymbolTable)symbols, (Path)outputFile.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getPackage(Path manifest) {
        String string;
        Closeable closeable = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl2 = false;
            ManifestData manifestData = AndroidManifestParser.parse((InputStream)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)manifestData, (String)"AndroidManifestParser.parse(it)");
            String string2 = manifestData.getPackage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"AndroidManifestParser.parse(it).`package`");
            String string3 = string2;
            string = string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BufferedInputStream(File\u2026e(it).`package`\n        }");
        return string;
    }
}

