/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.JavaCompileUtils;
import com.android.build.gradle.tasks.SerializableArtifact;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class JavaPreCompileTask
extends NonIncrementalTask {
    private RegularFileProperty processorListFile;
    private String annotationProcessorConfigurationName;
    private ArtifactCollection annotationProcessorConfiguration;
    private ArtifactCollection compileClasspaths;
    private AnnotationProcessorOptions annotationProcessorOptions;
    private boolean isTestComponent;

    @Inject
    public JavaPreCompileTask(WorkerExecutor workerExecutor, ObjectFactory objectFactory) {
        this.processorListFile = objectFactory.fileProperty();
    }

    @VisibleForTesting
    void init(String annotationProcessorConfigurationName, ArtifactCollection annotationProcessorConfiguration, ArtifactCollection compileClasspaths, AnnotationProcessorOptions annotationProcessorOptions, boolean isTestComponent) {
        this.annotationProcessorConfigurationName = annotationProcessorConfigurationName;
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.compileClasspaths = compileClasspaths;
        this.annotationProcessorOptions = annotationProcessorOptions;
        this.isTestComponent = isTestComponent;
    }

    @OutputFile
    public RegularFileProperty getProcessorListFile() {
        return this.processorListFile;
    }

    @Classpath
    public FileCollection getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration.getArtifactFiles();
    }

    @Classpath
    public FileCollection getCompileClasspaths() {
        return this.compileClasspaths.getArtifactFiles();
    }

    @Override
    protected void doTaskAction() {
        try (WorkerExecutorFacade workerExecutor = this.getWorkerFacadeWithWorkers();){
            workerExecutor.submit(PreCompileRunnable.class, (Serializable)new PreCompileParams(((RegularFile)this.processorListFile.get()).getAsFile(), this.annotationProcessorConfigurationName, JavaPreCompileTask.toSerializable(this.annotationProcessorConfiguration), JavaPreCompileTask.toSerializable(this.compileClasspaths), this.isTestComponent, this.annotationProcessorOptions.getClassNames(), this.annotationProcessorOptions.getIncludeCompileClasspath()));
        }
    }

    private static Collection<SerializableArtifact> toSerializable(ArtifactCollection artifactCollection) {
        return (Collection)artifactCollection.getArtifacts().stream().map(SerializableArtifact::new).collect(ImmutableList.toImmutableList());
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JavaPreCompileTask> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("javaPreCompile");
        }

        @Override
        public Class<JavaPreCompileTask> getType() {
            return JavaPreCompileTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends JavaPreCompileTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.ANNOTATION_PROCESSOR_LIST.INSTANCE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, JavaPreCompileTask::getProcessorListFile, "annotationProcessors.json");
        }

        @Override
        public void configure(JavaPreCompileTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.init(scope.getVariantData().getType().isTestComponent() ? scope.getVariantData().getType().getPrefix() + "AnnotationProcessor" : "annotationProcessor", scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROCESSED_JAR), scope.getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES, null), scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions(), scope.getVariantData().getType().isTestComponent());
        }
    }

    public static class PreCompileRunnable
    implements Runnable {
        private final PreCompileParams params;

        @Inject
        public PreCompileRunnable(PreCompileParams params) {
            this.params = params;
        }

        @Override
        public void run() {
            if (this.params.apOptionIncludeCompileClasspath == null) {
                Set processorClasspath = this.params.annotationProcessorConfiguration.stream().map(SerializableArtifact::getFile).collect(Collectors.toSet());
                Collection<SerializableArtifact> violatingProcessors = JavaCompileUtils.detectAnnotationProcessors(this.params.compileClasspaths).keySet();
                if (!(violatingProcessors = (Collection)violatingProcessors.stream().filter(artifact -> !processorClasspath.contains(artifact.getFile())).collect(Collectors.toList())).isEmpty()) {
                    Collection violatingProcessorNames = violatingProcessors.stream().map(SerializableArtifact::getDisplayName).collect(Collectors.toList());
                    String message = "Annotation processors must be explicitly declared now.  The following dependencies on the compile classpath are found to contain annotation processor.  Please add them to the " + this.params.annotationProcessorConfigurationName + " configuration.\n  - " + Joiner.on((String)"\n  - ").join((Iterable)violatingProcessorNames) + "\nAlternatively, set android.defaultConfig.javaCompileOptions.annotationProcessorOptions.includeCompileClasspath = true to continue with previous behavior.  Note that this option is deprecated and will be removed in the future.\nSee https://developer.android.com/r/tools/annotation-processor-error-message.html for more details.";
                    if (this.params.isTestComponent) {
                        Logging.getLogger(JavaPreCompileTask.class).warn(message);
                    } else {
                        throw new RuntimeException(message);
                    }
                }
            }
            Map<String, Boolean> annotationProcessors = JavaCompileUtils.detectAnnotationProcessors(this.params.apOptionIncludeCompileClasspath, this.params.apOptionClassNames, this.params.annotationProcessorConfiguration, this.params.compileClasspaths);
            JavaCompileUtils.writeAnnotationProcessorsToJsonFile(annotationProcessors, this.params.processorListFile);
        }
    }

    static class PreCompileParams
    implements Serializable {
        private final File processorListFile;
        private final String annotationProcessorConfigurationName;
        private final Collection<SerializableArtifact> annotationProcessorConfiguration;
        private final Collection<SerializableArtifact> compileClasspaths;
        private final boolean isTestComponent;
        private final List<String> apOptionClassNames;
        final Boolean apOptionIncludeCompileClasspath;

        public PreCompileParams(File processorListFile, String annotationProcessorConfigurationName, Collection<SerializableArtifact> annotationProcessorConfiguration, Collection<SerializableArtifact> compileClasspaths, boolean isTestComponent, List<String> apOptionClassNames, Boolean apOptionIncludeCompileClasspath) {
            this.processorListFile = processorListFile;
            this.annotationProcessorConfigurationName = annotationProcessorConfigurationName;
            this.annotationProcessorConfiguration = annotationProcessorConfiguration;
            this.compileClasspaths = compileClasspaths;
            this.isTestComponent = isTestComponent;
            this.apOptionClassNames = apOptionClassNames;
            this.apOptionIncludeCompileClasspath = apOptionIncludeCompileClasspath;
        }
    }
}

