/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.internal.BaseConfigAdapter;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.ProguardFileType;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.OldPostProcessingOptions;
import com.android.build.gradle.internal.core.PostProcessingBlockOptions;
import com.android.build.gradle.internal.core.PostProcessingOptions;
import com.android.build.gradle.internal.dependency.AndroidTestResourceArtifactCollection;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dependency.FilteredArtifactCollection;
import com.android.build.gradle.internal.dependency.FilteringSpec;
import com.android.build.gradle.internal.dependency.ProvidedClasspath;
import com.android.build.gradle.internal.dependency.SubtractingArtifactCollection;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.ArtifactPublishingUtil;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantBuildArtifactsHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.OptionalCompilationStep;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;

public class VariantScopeImpl
implements VariantScope {
    private static final String PUBLISH_ERROR_MSG = "Publishing to %1$s with no %1$s configuration object. VariantType: %2$s";
    private final PublishingSpecs.VariantSpec variantPublishingSpec;
    private final GlobalScope globalScope;
    private final BaseVariantData variantData;
    private final TransformManager transformManager;
    private final Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    private BuildArtifactsHolder artifacts;
    private final MutableTaskContainer taskContainer = new MutableTaskContainer();
    private final Supplier<ConfigurableFileCollection> desugarTryWithResourcesRuntimeJar;
    private final PostProcessingOptions postProcessingOptions;

    public VariantScopeImpl(GlobalScope globalScope, TransformManager transformManager, BaseVariantData variantData) {
        this.globalScope = globalScope;
        this.transformManager = transformManager;
        this.variantData = variantData;
        this.variantPublishingSpec = PublishingSpecs.getVariantSpec(this.getType());
        if (globalScope.isActive(OptionalCompilationStep.INSTANT_DEV)) {
            throw new RuntimeException("InstantRun mode is not supported");
        }
        this.artifacts = new VariantBuildArtifactsHolder(this.getProject(), this.getFullVariantName(), globalScope.getBuildDir(), globalScope.getDslScope());
        this.desugarTryWithResourcesRuntimeJar = Suppliers.memoize(() -> this.getProject().files(new Object[]{FileUtils.join((File)globalScope.getIntermediatesDir(), (String[])new String[]{"processing-tools", "runtime-deps", this.getVariantConfiguration().getDirName(), "desugar_try_with_resources.jar"})}));
        this.postProcessingOptions = this.createPostProcessingOptions();
    }

    private PostProcessingOptions createPostProcessingOptions() {
        BuildType dslBuildType;
        CoreBuildType buildType = (CoreBuildType)this.variantData.getVariantConfiguration().getBuildType();
        if (buildType instanceof BuildType && (dslBuildType = (BuildType)buildType).getPostProcessingConfiguration() == BuildType.PostProcessingConfiguration.POSTPROCESSING_BLOCK) {
            return new PostProcessingBlockOptions(dslBuildType.getPostprocessing(), this.getType().isTestComponent());
        }
        return new OldPostProcessingOptions(buildType, this.globalScope.getProject());
    }

    protected Project getProject() {
        return this.globalScope.getProject();
    }

    @Override
    public PublishingSpecs.VariantSpec getPublishingSpec() {
        return this.variantPublishingSpec;
    }

    @Override
    public MutableTaskContainer getTaskContainer() {
        return this.taskContainer;
    }

    @Override
    public void publishIntermediateArtifact(Provider<FileCollection> artifact, AndroidArtifacts.ArtifactType artifactType, Collection<AndroidArtifacts.PublishedConfigType> configTypes) {
        Provider file = artifact.map(fileCollection2 -> fileCollection2.getSingleFile());
        Preconditions.checkState((!configTypes.isEmpty() ? 1 : 0) != 0);
        VariantDependencies variantDependency = this.getVariantDependencies();
        for (AndroidArtifacts.PublishedConfigType configType : AndroidArtifacts.PublishedConfigType.values()) {
            if (!configTypes.contains((Object)configType)) continue;
            Configuration config2 = variantDependency.getElements(configType);
            Preconditions.checkNotNull((Object)config2, (Object)String.format(PUBLISH_ERROR_MSG, new Object[]{configType, this.getType()}));
            if (configType.isPublicationConfig()) {
                String classifier = null;
                if (configType.isClassifierRequired()) {
                    classifier = this.getFullVariantName();
                }
                ArtifactPublishingUtil.publishArtifactToDefaultVariant(config2, file, artifactType, classifier);
                continue;
            }
            ArtifactPublishingUtil.publishArtifactToConfiguration(config2, file, artifact, artifactType);
        }
    }

    @Override
    public void publishIntermediateArtifact(Provider<? extends FileSystemLocation> artifact, @Nonnull Provider<String> lastProducerTaskName2, AndroidArtifacts.ArtifactType artifactType, Collection<AndroidArtifacts.PublishedConfigType> configTypes) {
        Preconditions.checkState((!configTypes.isEmpty() ? 1 : 0) != 0);
        VariantDependencies variantDependency = this.getVariantDependencies();
        for (AndroidArtifacts.PublishedConfigType configType : AndroidArtifacts.PublishedConfigType.values()) {
            if (!configTypes.contains((Object)configType)) continue;
            Configuration config2 = variantDependency.getElements(configType);
            Preconditions.checkNotNull((Object)config2, (Object)String.format(PUBLISH_ERROR_MSG, new Object[]{configType, this.getType()}));
            if (configType.isPublicationConfig()) {
                String classifier = null;
                if (configType.isClassifierRequired()) {
                    classifier = this.getFullVariantName();
                }
                ArtifactPublishingUtil.publishArtifactToDefaultVariant(config2, artifact, artifactType, classifier);
                continue;
            }
            ArtifactPublishingUtil.publishArtifactToConfiguration(config2, artifact, lastProducerTaskName2, artifactType);
        }
    }

    @Override
    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @Override
    public BaseVariantData getVariantData() {
        return this.variantData;
    }

    @Override
    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantData.getVariantConfiguration();
    }

    @Override
    public String getFullVariantName() {
        return this.getVariantConfiguration().getFullName();
    }

    @Override
    public boolean useResourceShrinker() {
        if (this.getType().isForTesting() || !this.postProcessingOptions.resourcesShrinkingEnabled()) {
            return false;
        }
        if (this.getType().isFeatureSplit() || this.globalScope.hasDynamicFeatures()) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Resource shrinker cannot be used for multi-apk applications");
            return false;
        }
        if (this.getType().isAar()) {
            if (!this.getProject().getPlugins().hasPlugin("com.android.feature")) {
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Resource shrinker cannot be used for libraries.");
            }
            return false;
        }
        if (this.getCodeShrinker() == null) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Removing unused resources requires unused code shrinking to be turned on. See http://d.android.com/r/tools/shrink-resources.html for more information.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isPrecompileDependenciesResourcesEnabled() {
        return this.globalScope.getProjectOptions().get(BooleanOption.PRECOMPILE_DEPENDENCIES_RESOURCES) && !this.useResourceShrinker();
    }

    @Override
    public boolean isCrunchPngs() {
        Boolean buildTypeOverride = ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isCrunchPngs();
        if (buildTypeOverride != null) {
            return buildTypeOverride;
        }
        Boolean globalOverride = this.globalScope.getExtension().getAaptOptions().getCruncherEnabledOverride();
        if (globalOverride != null) {
            return globalOverride;
        }
        return ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isCrunchPngsDefault();
    }

    @Override
    public boolean consumesFeatureJars() {
        return this.getType().isBaseModule() && ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isMinifyEnabled() && this.globalScope.hasDynamicFeatures();
    }

    @Override
    public boolean getNeedsJavaResStreams() {
        return this.getType().isAar() && !this.getGlobalScope().getExtension().getTransforms().isEmpty();
    }

    @Override
    public boolean getNeedsMergedJavaResStream() {
        return this.getType().isAar() || !this.getGlobalScope().getExtension().getTransforms().isEmpty() || this.getCodeShrinker() != null;
    }

    @Override
    public boolean getNeedsMainDexListForBundle() {
        return this.getType().isBaseModule() && this.globalScope.hasDynamicFeatures() && this.getVariantConfiguration().getDexingType().getNeedsMainDexList();
    }

    @Override
    public CodeShrinker getCodeShrinker() {
        boolean isTestComponent = this.getType().isTestComponent();
        if (isTestComponent && this.getTestedVariantData().getType().isAar()) {
            return null;
        }
        CodeShrinker codeShrinker = this.postProcessingOptions.getCodeShrinker();
        if (codeShrinker != null) {
            Boolean enableR8 = this.globalScope.getProjectOptions().get(OptionalBooleanOption.ENABLE_R8);
            if (enableR8 == null) {
                return codeShrinker;
            }
            if (enableR8.booleanValue()) {
                return CodeShrinker.R8;
            }
            return CodeShrinker.PROGUARD;
        }
        return codeShrinker;
    }

    @Override
    public List<File> getProguardFiles() {
        List<File> result = this.getExplicitProguardFiles();
        if (result.isEmpty()) {
            return this.postProcessingOptions.getDefaultProguardFiles();
        }
        return result;
    }

    @Override
    public List<File> getExplicitProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.EXPLICIT);
    }

    @Override
    public List<File> getTestProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.TEST);
    }

    @Override
    public List<File> getConsumerProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.CONSUMER);
    }

    @Override
    public List<File> getConsumerProguardFilesForFeatures() {
        boolean hasFeaturePlugin = this.getProject().getPlugins().hasPlugin(FeaturePlugin.class);
        boolean includeProguardFiles = hasFeaturePlugin || this.getType().isDynamicFeature();
        List<File> consumerProguardFiles2 = this.getConsumerProguardFiles();
        if (includeProguardFiles) {
            consumerProguardFiles2.addAll(this.getExplicitProguardFiles());
        }
        return ImmutableList.copyOf(consumerProguardFiles2);
    }

    private List<File> gatherProguardFiles(ProguardFileType type) {
        GradleVariantConfiguration variantConfiguration = this.getVariantConfiguration();
        ArrayList<File> result = new ArrayList<File>(BaseConfigAdapter.getProguardFiles(variantConfiguration.getDefaultConfig(), type));
        result.addAll(this.postProcessingOptions.getProguardFiles(type));
        for (CoreProductFlavor flavor : variantConfiguration.getProductFlavors()) {
            result.addAll(BaseConfigAdapter.getProguardFiles((BaseConfig)flavor, type));
        }
        return result;
    }

    @Override
    public PostprocessingFeatures getPostprocessingFeatures() {
        return this.postProcessingOptions.getPostprocessingFeatures();
    }

    @Override
    public boolean isTestOnly() {
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        Boolean isTestOnlyOverride = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (isTestOnlyOverride != null) {
            return isTestOnlyOverride;
        }
        return !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) || !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY)) || projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API) != null || this.isPreviewTargetPlatform() || this.getMinSdkVersion().getCodename() != null || this.getVariantConfiguration().getTargetSdkVersion().getCodename() != null;
    }

    private boolean isPreviewTargetPlatform() {
        AndroidVersion version = AndroidTargetHash.getVersionFromHash((String)this.globalScope.getExtension().getCompileSdkVersion());
        return version != null && version.isPreview();
    }

    @Override
    public VariantType getType() {
        return this.variantData.getType();
    }

    @Override
    public DexingType getDexingType() {
        return this.variantData.getVariantConfiguration().getDexingType();
    }

    @Override
    public boolean getNeedsMainDexList() {
        return this.getDexingType().getNeedsMainDexList();
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        return this.getVariantConfiguration().getMinSdkVersion();
    }

    @Override
    public String getDirName() {
        return this.getVariantConfiguration().getDirName();
    }

    @Override
    public Collection<String> getDirectorySegments() {
        return this.getVariantConfiguration().getDirectorySegments();
    }

    @Override
    public TransformManager getTransformManager() {
        return this.transformManager;
    }

    @Override
    public String getTaskName(String prefix) {
        return this.getTaskName(prefix, "");
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return this.variantData.getTaskName(prefix, suffix);
    }

    @Override
    public File getNdkDebuggableLibraryFolders(Abi abi) {
        return this.ndkDebuggableLibraryFolders.get((Object)abi);
    }

    @Override
    public void addNdkDebuggableLibraryFolders(Abi abi, File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @Override
    public BaseVariantData getTestedVariantData() {
        return this.variantData instanceof TestVariantData ? (BaseVariantData)((Object)((TestVariantData)this.variantData).getTestedVariantData()) : null;
    }

    @Override
    public File getSplitApkOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/split-apk/" + this.getDirName());
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType) {
        return this.getJavaClasspath(configType, classesType, null);
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        FileCollection mainCollection = this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        mainCollection = mainCollection.plus(this.variantData.getGeneratedBytecode(generatedBytecodeKey));
        mainCollection = this.getProject().files(new Object[]{this.getCompiledRClasses(configType), mainCollection});
        return mainCollection;
    }

    @Override
    public FileCollection getCompiledRClasses(AndroidArtifacts.ConsumedConfigType configType) {
        ConfigurableFileCollection mainCollection = this.getProject().files(new Object[0]);
        BaseVariantData tested = this.getTestedVariantData();
        if (this.globalScope.getExtension().getAaptOptions().getNamespaced()) {
            Provider<RegularFile> namespacedRClassJar = this.artifacts.getFinalProduct(InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR.INSTANCE);
            ConfigurableFileTree fileTree = this.getProject().fileTree(namespacedRClassJar).builtBy(new Object[]{namespacedRClassJar});
            mainCollection = mainCollection.plus((FileCollection)fileTree);
            mainCollection = mainCollection.plus(this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR));
            mainCollection = mainCollection.plus(this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SHARED_CLASSES));
            if (this.globalScope.getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES)) {
                mainCollection = mainCollection.plus((FileCollection)this.artifacts.getFinalProductAsFileCollection(InternalArtifactType.NAMESPACED_CLASSES_JAR.INSTANCE).get());
                mainCollection = mainCollection.plus((FileCollection)this.getProject().files(new Object[]{this.artifacts.getFinalProduct(InternalArtifactType.COMPILE_ONLY_NAMESPACED_DEPENDENCIES_R_JAR.INSTANCE)}));
            }
            if (tested != null) {
                mainCollection = this.getProject().files(new Object[]{mainCollection, tested.getScope().getArtifacts().getFinalProduct(InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR.INSTANCE).get()});
            }
        } else if (tested == null) {
            boolean useCompileRClassInApp;
            boolean bl = useCompileRClassInApp = this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_APP_COMPILE_TIME_R_CLASS) && !this.getType().isForTesting();
            if (this.getType().isAar() || useCompileRClassInApp) {
                Provider<RegularFile> rJar = this.artifacts.getFinalProduct(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
                mainCollection = this.getProject().files(new Object[]{rJar});
            } else {
                Preconditions.checkState((boolean)this.getType().isApk(), (Object)("Expected APK type but found: " + this.getType()));
                Provider<FileCollection> rJar = this.artifacts.getFinalProductAsFileCollection(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
                mainCollection = this.getProject().files(new Object[]{rJar});
            }
        } else if (!this.globalScope.getProjectOptions().get(BooleanOption.GENERATE_R_JAVA)) {
            Provider<RegularFile> rJar = this.getType() == VariantTypeImpl.ANDROID_TEST ? this.artifacts.getFinalProduct(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE) : this.getRJarForUnitTests();
            mainCollection = this.getProject().files(new Object[]{rJar});
        }
        return mainCollection;
    }

    @Override
    public ArtifactCollection getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        ArtifactCollection mainCollection = this.getArtifactCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        return ArtifactCollectionWithExtraArtifact.makeExtraCollection(mainCollection, this.variantData.getGeneratedBytecode(generatedBytecodeKey), this.getProject().getPath());
    }

    @Override
    public BuildArtifactsHolder getArtifacts() {
        return this.artifacts;
    }

    @Override
    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        return this.getArtifactFileCollection(configType, scope, artifactType, null);
    }

    @Override
    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        FileCollection fileCollection2;
        if (configType.needsTestedComponents()) {
            return this.getArtifactCollection(configType, scope, artifactType, attributeMap).getArtifactFiles();
        }
        ArtifactCollection artifacts2 = this.computeArtifactCollection(configType, scope, artifactType, attributeMap);
        if (configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.getType().isFeatureSplit() && artifactType != AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES) {
            FileCollection excludedDirectories = this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES, attributeMap).getArtifactFiles();
            fileCollection2 = new FilteringSpec(artifacts2, excludedDirectories).getFilteredFileCollection(this.getProject());
        } else {
            fileCollection2 = artifacts2.getArtifactFiles();
        }
        return fileCollection2;
    }

    @Override
    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        return this.getArtifactCollection(configType, scope, artifactType, null);
    }

    @Override
    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        ImmutableList<AndroidArtifacts.PublishedConfigType> publishedConfigs;
        PublishingSpecs.VariantSpec testedSpec;
        PublishingSpecs.OutputSpec taskOutputSpec;
        ArtifactCollection artifacts2 = this.computeArtifactCollection(configType, scope, artifactType, attributeMap);
        if (configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.getType().isFeatureSplit() && artifactType != AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES) {
            FileCollection excludedDirectories = this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES, null).getArtifactFiles();
            artifacts2 = new FilteredArtifactCollection(this.getProject(), new FilteringSpec(artifacts2, excludedDirectories));
        }
        if (!configType.needsTestedComponents() || !this.getType().isTestComponent()) {
            return artifacts2;
        }
        if (!(this.variantData instanceof TestVariantData)) {
            return artifacts2;
        }
        TestedVariantData tested = ((TestVariantData)this.variantData).getTestedVariantData();
        VariantScope testedScope = tested.getScope();
        if ((scope == AndroidArtifacts.ArtifactScope.PROJECT || scope == AndroidArtifacts.ArtifactScope.ALL) && (taskOutputSpec = (testedSpec = testedScope.getPublishingSpec().getTestingSpec(this.getType())).getSpec(artifactType, configType.getPublishedTo())) != null && (publishedConfigs = taskOutputSpec.getPublishedConfigTypes()).contains((Object)configType.getPublishedTo())) {
            ArtifactType<? extends FileSystemLocation> taskOutputType = taskOutputSpec.getOutputType();
            BuildArtifactsHolder testedArtifacts = testedScope.getArtifacts();
            artifacts2 = ArtifactCollectionWithExtraArtifact.makeExtraCollectionForTest(artifacts2, (FileCollection)testedArtifacts.getFinalProductAsFileCollection(taskOutputType).get(), this.getProject().getPath(), testedScope.getFullVariantName());
        }
        if (tested instanceof ApplicationVariantData && configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.getType().isApk()) {
            if (artifactType == AndroidArtifacts.ArtifactType.ANDROID_RES || artifactType == AndroidArtifacts.ArtifactType.COMPILED_DEPENDENCIES_RESOURCES) {
                artifacts2 = new AndroidTestResourceArtifactCollection(artifacts2, this.getVariantDependencies().getIncomingRuntimeDependencies(), this.getVariantDependencies().getRuntimeClasspath().getIncoming());
            } else {
                ArtifactCollection testedArtifactCollection = testedScope.getArtifactCollection(configType, scope, artifactType, attributeMap);
                artifacts2 = new SubtractingArtifactCollection(artifacts2, testedArtifactCollection);
            }
        }
        return artifacts2;
    }

    private Configuration getConfiguration(AndroidArtifacts.ConsumedConfigType configType) {
        switch (configType) {
            case COMPILE_CLASSPATH: {
                return this.getVariantDependencies().getCompileClasspath();
            }
            case RUNTIME_CLASSPATH: {
                return this.getVariantDependencies().getRuntimeClasspath();
            }
            case ANNOTATION_PROCESSOR: {
                return this.getVariantDependencies().getAnnotationProcessorConfiguration();
            }
            case REVERSE_METADATA_VALUES: {
                return (Configuration)Preconditions.checkNotNull((Object)this.getVariantDependencies().getReverseMetadataValuesConfiguration());
            }
        }
        throw new RuntimeException("unknown ConfigType value " + (Object)((Object)configType));
    }

    private ArtifactCollection computeArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        Configuration configuration2 = this.getConfiguration(configType);
        Action attributes2 = container -> {
            container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)artifactType.getType());
            if (attributeMap != null) {
                for (Attribute attribute : attributeMap.keySet()) {
                    container.attribute(attribute, attributeMap.get(attribute));
                }
            }
        };
        Spec<ComponentIdentifier> filter = VariantScopeImpl.getComponentFilter(scope);
        boolean lenientMode = Boolean.TRUE.equals(this.globalScope.getProjectOptions().get(BooleanOption.IDE_BUILD_MODEL_ONLY));
        return configuration2.getIncoming().artifactView(config2 -> {
            config2.attributes(attributes2);
            if (filter != null) {
                config2.componentFilter(filter);
            }
            config2.lenient(lenientMode);
        }).getArtifacts();
    }

    private static Spec<ComponentIdentifier> getComponentFilter(AndroidArtifacts.ArtifactScope scope) {
        switch (scope) {
            case ALL: {
                return null;
            }
            case EXTERNAL: {
                return id -> !(id instanceof ProjectComponentIdentifier);
            }
            case PROJECT: {
                return id -> id instanceof ProjectComponentIdentifier;
            }
            case REPOSITORY_MODULE: {
                return id -> id instanceof ModuleComponentIdentifier;
            }
            case FILE: {
                return id -> !(id instanceof ProjectComponentIdentifier) && !(id instanceof ModuleComponentIdentifier);
            }
        }
        throw new RuntimeException("unknown ArtifactScope value");
    }

    @Override
    public FileCollection getLocalPackagedJars() {
        return this.getLocalFileDependencies(file -> file.getName().toLowerCase(Locale.US).endsWith(".jar"));
    }

    @Override
    public FileCollection getLocalFileDependencies(Predicate<File> filePredicate) {
        Configuration configuration2 = this.getVariantDependencies().getRuntimeClasspath();
        Callable<Collection> dependencies = () -> (ImmutableList)configuration2.getAllDependencies().stream().filter(it -> it instanceof SelfResolvingDependency).filter(it -> !(it instanceof ProjectDependency)).map(it -> (SelfResolvingDependency)it).collect(ImmutableList.toImmutableList());
        return this.getProject().files(new Object[]{() -> ((Collection)dependencies.call()).stream().flatMap(it -> it.resolve().stream()).filter(filePredicate).collect(Collectors.toList())}).builtBy(new Object[]{dependencies});
    }

    @Override
    public FileCollection getProvidedOnlyClasspath() {
        ArtifactCollection compile2 = this.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        ArtifactCollection runtime = this.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        return ProvidedClasspath.getProvidedClasspath(compile2, runtime);
    }

    @Override
    public Provider<RegularFile> getRJarForUnitTests() {
        VariantScope testedScope = ((BaseVariantData)Preconditions.checkNotNull((Object)this.getTestedVariantData(), (Object)("Variant type does not have a tested variant: " + this.getType()))).getScope();
        Preconditions.checkState((this.getType() == VariantTypeImpl.UNIT_TEST ? 1 : 0) != 0, (Object)("Expected unit test type but found: " + this.getType()));
        if (testedScope.getType().isAar()) {
            return this.getArtifacts().getFinalProduct(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
        }
        Preconditions.checkState((boolean)testedScope.getType().isApk(), (Object)("Expected APK type but found: " + testedScope.getType()));
        return testedScope.getArtifacts().getFinalProduct(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
    }

    private File intermediate(String directoryName) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{directoryName, this.getDirName()});
    }

    private File intermediate(String directoryName, String fileName) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{directoryName, this.getDirName(), fileName});
    }

    @Override
    public File getDefaultMergeResourcesOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res", "merged", this.getDirName()});
    }

    @Override
    public File getCompiledResourcesOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res", "compiled", this.getDirName()});
    }

    @Override
    public File getResourceBlameLogDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"blame", "res", this.getDirectorySegments()}));
    }

    @Override
    public File getBuildConfigSourceOutputDir() {
        return new File(this.globalScope.getBuildDir() + "/" + "generated" + "/source/buildConfig/" + this.getDirName());
    }

    private File getGeneratedResourcesDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"res", name, this.getDirectorySegments()}));
    }

    @Override
    public File getGeneratedResOutputDir() {
        return this.getGeneratedResourcesDir("resValues");
    }

    @Override
    public File getGeneratedPngsOutputDir() {
        return this.getGeneratedResourcesDir("pngs");
    }

    @Override
    public File getRenderscriptResOutputDir() {
        return this.getGeneratedResourcesDir("rs");
    }

    @Override
    public File getRenderscriptObjOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"rs", this.getDirectorySegments(), "obj"}));
    }

    @Override
    public File getIncrementalDir(String name) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"incremental", name});
    }

    @Override
    public File getCoverageReportDir() {
        return new File(this.globalScope.getReportsDir(), "coverage/" + this.getDirName());
    }

    @Override
    public File getClassOutputForDataBinding() {
        return new File(this.globalScope.getGeneratedDir(), "source/dataBinding/trigger/" + this.getDirName());
    }

    @Override
    public File getGeneratedClassListOutputFileForDataBinding() {
        return new File(this.dataBindingIntermediate("class-list"), "_generated.txt");
    }

    private File dataBindingIntermediate(String name) {
        return this.intermediate("data-binding", name);
    }

    @Override
    public File getFullApkPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "full", this.getDirName()}));
    }

    @Override
    public File getIntermediateDir(ArtifactType<Directory> taskOutputType) {
        return this.intermediate(taskOutputType.name().toLowerCase(Locale.US));
    }

    @Override
    public File getMicroApkManifestFile() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"manifests", "microapk", this.getDirName(), "AndroidManifest.xml"});
    }

    @Override
    public File getMicroApkResDirectory() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"res", "microapk", this.getDirName()});
    }

    @Override
    public File getManifestOutputDirectory() {
        VariantType variantType = this.getType();
        if (variantType.isTestComponent()) {
            if (variantType.isApk()) {
                return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifest", this.getDirName()});
            }
        } else {
            return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "full", this.getDirName()});
        }
        throw new RuntimeException("getManifestOutputDirectory called for an unexpected variant.");
    }

    @Override
    public File getApkLocation() {
        String override = this.globalScope.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
        File baseDirectory = override != null && !this.getType().isHybrid() ? this.getProject().file((Object)override) : this.getDefaultApkLocation();
        return new File(baseDirectory, this.getDirName());
    }

    private File getDefaultApkLocation() {
        return FileUtils.join((File)this.globalScope.getBuildDir(), (String[])new String[]{"outputs", "apk"});
    }

    @Override
    public File getAarLocation() {
        return FileUtils.join((File)this.globalScope.getOutputsDir(), (String[])new String[]{"aar"});
    }

    @Override
    public OutputScope getOutputScope() {
        return this.variantData.getOutputScope();
    }

    @Override
    public VariantDependencies getVariantDependencies() {
        return this.variantData.getVariantDependency();
    }

    @Override
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        if (!this.globalScope.getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            return VariantScope.Java8LangSupport.UNUSED;
        }
        if (this.getProject().getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            return VariantScope.Java8LangSupport.RETROLAMBDA;
        }
        CodeShrinker shrinker = this.getCodeShrinker();
        if (shrinker == CodeShrinker.R8) {
            if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_R8_DESUGARING)) {
                return VariantScope.Java8LangSupport.R8;
            }
        } else if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8_DESUGARING) && this.isValidJava8Flag(BooleanOption.ENABLE_D8_DESUGARING, BooleanOption.ENABLE_D8)) {
            return VariantScope.Java8LangSupport.D8;
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DESUGAR)) {
            return VariantScope.Java8LangSupport.DESUGAR;
        }
        BooleanOption missingFlag = shrinker == CodeShrinker.R8 ? BooleanOption.ENABLE_R8_DESUGARING : BooleanOption.ENABLE_D8_DESUGARING;
        this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, String.format("Please add '%s=true' to your gradle.properties file to enable Java 8 language support.", missingFlag.name()), this.getVariantConfiguration().getFullName());
        return VariantScope.Java8LangSupport.INVALID;
    }

    private boolean isValidJava8Flag(BooleanOption flag, BooleanOption ... dependsOn2) {
        ArrayList invalid = null;
        for (BooleanOption requiredFlag : dependsOn2) {
            if (this.globalScope.getProjectOptions().get(requiredFlag)) continue;
            if (invalid == null) {
                invalid = Lists.newArrayList();
            }
            invalid.add("'" + requiredFlag.getPropertyName() + "= false'");
        }
        if (invalid == null) {
            return true;
        }
        String template = "Java 8 language support, as requested by '%s= true' in your gradle.properties file, is not supported when %s.";
        String msg = String.format(template, flag.getPropertyName(), String.join((CharSequence)",", invalid));
        this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, msg, this.getVariantConfiguration().getFullName());
        return false;
    }

    @Override
    public ConfigurableFileCollection getTryWithResourceRuntimeSupportJar() {
        return this.desugarTryWithResourcesRuntimeJar.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getFullVariantName()).toString();
    }

    @Override
    public DexerTool getDexer() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexerTool.D8;
        }
        return DexerTool.DX;
    }

    @Override
    public DexMergerTool getDexMerger() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexMergerTool.D8;
        }
        return DexMergerTool.DX;
    }

    @Override
    public FileCollection getBootClasspath() {
        return this.globalScope.getBootClasspath();
    }

    @Override
    public InternalArtifactType<Directory> getManifestArtifactType() {
        return this.globalScope.getProjectOptions().get(BooleanOption.IDE_DEPLOY_AS_INSTANT_APP) ? InternalArtifactType.INSTANT_APP_MANIFEST.INSTANCE : InternalArtifactType.MERGED_MANIFESTS.INSTANCE;
    }

    @Override
    public File getSymbolTableFile() {
        return new File(this.globalScope.getIntermediatesDir(), "symbols/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public JarCreatorType getJarCreatorType() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.USE_NEW_JAR_CREATOR)) {
            return JarCreatorType.JAR_FLINGER;
        }
        return JarCreatorType.JAR_MERGER;
    }

    @Override
    public ApkCreatorType getApkCreatorType() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.USE_NEW_APK_CREATOR)) {
            return ApkCreatorType.APK_FLINGER;
        }
        return ApkCreatorType.APK_Z_FILE_CREATOR;
    }
}

