/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"DESUGAR_LIB_CONFIG", "", "DESUGAR_LIB_CONFIGURATION_NAME", "DESUGAR_LIB_CONFIG_CONFIGURATION_NAME", "DESUGAR_LIB_CONFIG_FILE", "DESUGAR_LIB_DEX", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getDesugarLibConfig", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "getDesugarLibConfigFromTransform", "getDesugarLibDexFromTransform", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "getDesugarLibJarFromMaven", "getDesugaringLibConfiguration", "name", "initDesugarLibConfigurations", "", "registerDesugarLibConfigTransform", "gradle"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    private static final String DESUGAR_LIB_CONFIGURATION_NAME = "_internal_desugar_jdk_libs";
    private static final String DESUGAR_LIB_CONFIG_CONFIGURATION_NAME = "_internal_desugar_jdk_libs_configuration";
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    public static final String DESUGAR_LIB_DEX = "_internal-desugar-jdk-libs-dex";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-jdk-libs-config";

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration configuration2 = DesugarLibUtils.getDesugaringLibConfiguration(project2, DESUGAR_LIB_CONFIGURATION_NAME);
        return DesugarLibUtils.getArtifactCollection(configuration2);
    }

    @NotNull
    public static final FileCollection getDesugarLibDexFromTransform(@NotNull VariantScope variantScope) {
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        if (!variantScope.isCoreLibraryDesugaringEnabled()) {
            GlobalScope globalScope = variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            ConfigurableFileCollection configurableFileCollection = globalScope.getProject().files(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"variantScope.globalScope.project.files()");
            return (FileCollection)configurableFileCollection;
        }
        GlobalScope globalScope = variantScope.getGlobalScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
        Project project2 = globalScope.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
        Project project3 = project2;
        Configuration configuration2 = DesugarLibUtils.getDesugaringLibConfiguration(project3, DESUGAR_LIB_CONFIGURATION_NAME);
        return DesugarLibUtils.getDesugarLibDexFromTransform(configuration2);
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration configuration2 = DesugarLibUtils.getDesugaringLibConfiguration(project2, DESUGAR_LIB_CONFIG_CONFIGURATION_NAME);
        DesugarLibUtils.registerDesugarLibConfigTransform(project2);
        Provider provider = DesugarLibUtils.getDesugarLibConfigFromTransform(configuration2).getElements().map((Transformer)getDesugarLibConfig.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"getDesugarLibConfigFromT\u2026        }\n        }\n    }");
        return provider;
    }

    private static final Configuration getDesugaringLibConfiguration(Project project2, String name) {
        boolean bl = Intrinsics.areEqual((Object)name, (Object)DESUGAR_LIB_CONFIGURATION_NAME) || Intrinsics.areEqual((Object)name, (Object)DESUGAR_LIB_CONFIG_CONFIGURATION_NAME);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Configuration configuration2 = (Configuration)project2.getConfigurations().findByName(name);
        if (configuration2 == null) {
            bl = false;
            bl2 = false;
            boolean bl6 = false;
            DesugarLibUtils.initDesugarLibConfigurations(project2);
            Configuration configuration3 = project2.getConfigurations().getByName(name);
            configuration2 = configuration3;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"run {\n        initDesuga\u2026ons.getByName(name)\n    }");
        }
        return configuration2;
    }

    private static final void initDesugarLibConfigurations(Project project2) {
        Configuration library2 = (Configuration)project2.getConfigurations().create(DESUGAR_LIB_CONFIGURATION_NAME, (Action)initDesugarLibConfigurations.library.1.INSTANCE);
        DependencyHandler dependencyHandler = project2.getDependencies();
        Configuration configuration2 = library2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"library");
        dependencyHandler.add(configuration2.getName(), (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools"), TuplesKt.to((Object)"name", (Object)"desugar_jdk_libs"), TuplesKt.to((Object)"version", (Object)"1.0.1")}));
        Configuration configuration3 = (Configuration)project2.getConfigurations().create(DESUGAR_LIB_CONFIG_CONFIGURATION_NAME, (Action)initDesugarLibConfigurations.configuration.1.INSTANCE);
        DependencyHandler dependencyHandler2 = project2.getDependencies();
        Configuration configuration4 = configuration3;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration4, (String)"configuration");
        dependencyHandler2.add(configuration4.getName(), (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools"), TuplesKt.to((Object)"name", (Object)"desugar_jdk_libs_configuration"), TuplesKt.to((Object)"version", (Object)"0.5.0")}));
    }

    private static final FileCollection getDesugarLibDexFromTransform(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getDesugarLibDexFromTransform.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getDesugarLibConfigFromTransform.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigTransform(Project project2) {
        project2.getDependencies().registerTransform(DesugarLibConfigExtractor.class, (Action)registerDesugarLibConfigTransform.1.INSTANCE);
    }
}

