/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a:\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a8\u0006\u0012"}, d2={"computeArtifactList", "Lorg/gradle/api/artifacts/ArtifactCollection;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "consumedConfigType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ConsumedConfigType;", "scope", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactScope;", "type", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "getAllArtifacts", "", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "dependencyFailureHandler", "Lcom/android/build/gradle/internal/ide/DependencyFailureHandler;", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "gradle"})
@JvmName(name="ArtifactUtils")
public final class ArtifactUtils {
    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull VariantScope variantScope, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @Nullable DependencyFailureHandler dependencyFailureHandler, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
        ArtifactCollection allArtifactList = ArtifactUtils.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
        ArtifactCollection manifestList = ArtifactUtils.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
        ArtifactCollection nonNamespacedManifestList = ArtifactUtils.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.NON_NAMESPACED_MANIFEST);
        ArtifactCollection explodedAarList = ArtifactUtils.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.EXPLODED_AAR);
        ArtifactCollection aarList = ArtifactUtils.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.AAR);
        if (dependencyFailureHandler != null) {
            StringBuilder stringBuilder = new StringBuilder();
            GlobalScope globalScope = variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            Project project2 = globalScope.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
            String string = stringBuilder.append(project2.getPath()).append("@").append(variantScope.getFullVariantName()).append("/").append(consumedConfigType.getName()).toString();
            Collection collection = allArtifactList.getFailures();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"allArtifactList.failures");
            dependencyFailureHandler.addErrors(string, collection);
        }
        HashSet<ComponentIdentifier> wrapperModules = new HashSet<ComponentIdentifier>();
        Set explodedAarArtifacts = explodedAarList.getArtifacts();
        HashMap explodedAarResults = Maps.newHashMapWithExpectedSize((int)explodedAarArtifacts.size());
        Iterator iterator = explodedAarArtifacts.iterator();
        while (iterator.hasNext()) {
            ResolvedArtifactResult result;
            ResolvedArtifactResult resolvedArtifactResult = result = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"result");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"result.id");
            ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
            if (componentIdentifier instanceof ProjectComponentIdentifier) {
                wrapperModules.add(componentIdentifier);
            }
            HashMap hashMap = explodedAarResults;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"explodedAarResults");
            ((Map)hashMap).put(componentIdentifier, result);
        }
        Set aarArtifacts = aarList.getArtifacts();
        HashMap aarResults = Maps.newHashMapWithExpectedSize((int)aarArtifacts.size());
        for (ResolvedArtifactResult result : aarArtifacts) {
            HashMap hashMap = aarResults;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"aarResults");
            Map map = hashMap;
            ResolvedArtifactResult resolvedArtifactResult = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"result");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"result.id");
            map.put(componentArtifactIdentifier.getComponentIdentifier(), result);
        }
        HashSet manifestArtifacts = new HashSet();
        manifestArtifacts.addAll(manifestList.getArtifacts());
        manifestArtifacts.addAll(nonNamespacedManifestList.getArtifacts());
        HashSet manifestIds = Sets.newHashSetWithExpectedSize((int)manifestArtifacts.size());
        Iterator iterator2 = manifestArtifacts.iterator();
        while (iterator2.hasNext()) {
            ResolvedArtifactResult result;
            ResolvedArtifactResult resolvedArtifactResult = result = (ResolvedArtifactResult)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"result");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"result.id");
            manifestIds.add(componentArtifactIdentifier.getComponentIdentifier());
        }
        Set allArtifacts = allArtifactList.getArtifacts();
        LinkedHashSet artifacts2 = Sets.newLinkedHashSetWithExpectedSize((int)allArtifacts.size());
        Iterator iterator3 = allArtifacts.iterator();
        while (iterator3.hasNext()) {
            ResolvedArtifactResult artifact;
            ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
            boolean isWrappedModule = wrapperModules.contains(componentIdentifier);
            ResolvedArtifact.DependencyType dependencyType = ResolvedArtifact.DependencyType.JAVA;
            ResolvedArtifactResult mainArtifact = artifact;
            ResolvedArtifactResult extractedAar = null;
            if (manifestIds.contains(componentIdentifier)) {
                dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                ResolvedArtifactResult explodedAar = (ResolvedArtifactResult)explodedAarResults.get(componentIdentifier);
                if (explodedAar != null) {
                    extractedAar = explodedAar;
                    ResolvedArtifactResult resolvedArtifactResult2 = (ResolvedArtifactResult)aarResults.get(componentIdentifier);
                    if (resolvedArtifactResult2 == null) {
                        resolvedArtifactResult2 = mainArtifact;
                    }
                    mainArtifact = resolvedArtifactResult2;
                }
            }
            ResolvedArtifactResult resolvedArtifactResult3 = mainArtifact;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult3, (String)"mainArtifact");
            artifacts2.add(new ResolvedArtifact(resolvedArtifactResult3, extractedAar, dependencyType, isWrappedModule, buildMapping));
        }
        LinkedHashSet linkedHashSet = artifacts2;
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet, (String)"artifacts");
        return linkedHashSet;
    }

    @NotNull
    public static final ArtifactCollection computeArtifactList(@NotNull VariantScope variantScope, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @NotNull AndroidArtifacts.ArtifactScope scope, @NotNull AndroidArtifacts.ArtifactType type) {
        ArtifactCollectionWithExtraArtifact artifactCollectionWithExtraArtifact;
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scope), (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        ArtifactCollection artifactCollection = variantScope.getArtifactCollection(consumedConfigType, scope, type);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"variantScope.getArtifact\u2026dConfigType, scope, type)");
        ArtifactCollection artifacts2 = artifactCollection;
        ArtifactCollection artifactCollection2 = artifacts2;
        if (!(artifactCollection2 instanceof ArtifactCollectionWithExtraArtifact)) {
            artifactCollection2 = null;
        }
        if ((artifactCollectionWithExtraArtifact = (ArtifactCollectionWithExtraArtifact)artifactCollection2) == null || (artifactCollectionWithExtraArtifact = artifactCollectionWithExtraArtifact.getParentArtifacts()) == null) {
            artifactCollectionWithExtraArtifact = artifacts2;
        }
        return artifactCollectionWithExtraArtifact;
    }
}

