/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.InstrumentationTestAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.model.TestOptions;
import com.android.builder.testing.OnDeviceOrchestratorTestRunner;
import com.android.builder.testing.ShardedTestRunner;
import com.android.builder.testing.SimpleTestRunner;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.ConsoleRenderer;
import org.xml.sax.SAXException;

public abstract class DeviceProviderInstrumentTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private static final Predicate<File> IS_APK = file -> "apk".equals(Files.getFileExtension((String)file.getName()));
    private DeviceProvider deviceProvider;
    private final DirectoryProperty coverageDir;
    private File reportsDir;
    private FileCollection buddyApks;
    private FileCollection testTargetManifests;
    private ProcessExecutor processExecutor;
    private String flavorName;
    private Provider<File> splitSelectExecProvider;
    private AbstractTestDataImpl testData;
    private TestRunnerFactory testRunnerFactory;
    private boolean ignoreFailures;
    private boolean testFailed;
    private boolean codeCoverageEnabled;
    private TestOptions.Execution testExecution;
    private Configuration dependencies;
    private Collection<String> installOptions;

    @Internal
    public ExecutorServiceAdapter getExecutorServiceAdapter() {
        return Workers.INSTANCE.withThreads(this.getProjectName(), this.getPath());
    }

    @Inject
    public DeviceProviderInstrumentTestTask(ObjectFactory objectFactory) {
        this.coverageDir = objectFactory.directoryProperty();
    }

    @Override
    protected void doTaskAction() throws DeviceException, IOException, ParserConfigurationException, SAXException, ExecutionException {
        boolean success;
        File additionalTestOutputDir;
        DeviceProviderInstrumentTestTask.checkForNonApks(this.buddyApks.getFiles(), message -> {
            throw new InvalidUserDataException(message);
        });
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        if (((Boolean)this.getAdditionalTestOutputEnabled().get()).booleanValue()) {
            additionalTestOutputDir = ((Directory)this.getAdditionalTestOutputDir().get()).getAsFile();
            FileUtils.cleanOutputDir((File)additionalTestOutputDir);
        } else {
            additionalTestOutputDir = null;
        }
        File coverageOutDir = ((Directory)this.getCoverageDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)coverageOutDir);
        if (!this.testTargetManifests.isEmpty()) {
            this.testData.loadFromMetadataFile(ExistingBuildElements.getMetadataFile(this.testTargetManifests.getSingleFile()));
        }
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            File emptyCoverageFile = new File(coverageOutDir, "coverage.ec");
            emptyCoverageFile.createNewFile();
            success = true;
        } else {
            GradleProcessExecutor gradleProcessExecutor = new GradleProcessExecutor(this.getProject());
            success = (Boolean)this.deviceProvider.use(() -> {
                TestRunner testRunner = this.testRunnerFactory.build((File)this.getSplitSelectExec().get(), gradleProcessExecutor);
                ImmutableList extraArgs = this.installOptions == null || this.installOptions.isEmpty() ? ImmutableList.of() : this.installOptions;
                try {
                    return testRunner.runTests(this.getProject().getName(), this.getFlavorName(), (TestData)this.testData, this.buddyApks.getFiles(), this.deviceProvider.getDevices(), this.deviceProvider.getTimeoutInMs(), (Collection)extraArgs, resultsOutDir, ((Boolean)this.getAdditionalTestOutputEnabled().get()).booleanValue(), additionalTestOutputDir, coverageOutDir, (ILogger)new LoggerWrapper(this.getLogger()));
                }
                catch (Exception e) {
                    InstrumentationTestAnalytics.recordCrashedTestRun(this.dependencies, this.testExecution, this.codeCoverageEnabled);
                    throw e;
                }
            });
        }
        File reportOutDir = this.getReportsDir();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report2 = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        CompositeTestResults results = report2.generateReport();
        InstrumentationTestAnalytics.recordOkTestRun(this.dependencies, this.testExecution, this.codeCoverageEnabled, results.getTestCount());
        if (!success) {
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message2);
                return;
            }
            throw new GradleException(message2);
        }
        this.testFailed = false;
    }

    public static void checkForNonApks(Collection<File> buddyApksFiles, Consumer<String> errorHandler) {
        List nonApks = buddyApksFiles.stream().filter(IS_APK.negate()).collect(Collectors.toList());
        if (!nonApks.isEmpty()) {
            Collections.sort(nonApks);
            String message = String.format("Not all files in %s configuration are APKs: %s", "androidTestUtil", Joiner.on((char)' ').join(nonApks));
            errorHandler.accept(message);
        }
    }

    private boolean testsFound() {
        return !this.getProject().files(new Object[]{this.testData.getTestDirectories()}).getAsFileTree().isEmpty();
    }

    @OutputDirectory
    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    @Override
    @OutputDirectory
    public abstract DirectoryProperty getResultsDir();

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @OutputDirectory
    public DirectoryProperty getCoverageDir() {
        return this.coverageDir;
    }

    @Deprecated
    public void setCoverageDir(File coverageDir) {
        this.getLogger().info("DeviceProviderInstrumentTestTask.setCoverageDir is deprecated and has no effect.");
    }

    @Internal
    public String getFlavorName() {
        return this.flavorName;
    }

    public void setFlavorName(String flavorName) {
        this.flavorName = flavorName;
    }

    @Input
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @Input
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    @Internal
    public DeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    @Internal
    public AbstractTestDataImpl getTestData() {
        return this.testData;
    }

    public void setTestData(AbstractTestDataImpl testData) {
        this.testData = testData;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public Provider<File> getSplitSelectExec() {
        return this.splitSelectExecProvider;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    @Internal
    public boolean getTestFailed() {
        return this.testFailed;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getTestTargetManifests() {
        return this.testTargetManifests;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getBuddyApks() {
        return this.buddyApks;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Provider<Directory> getTestApkDir() {
        return this.testData.getTestApkDir();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getTestedApksDir() {
        return this.testData.getTestedApksDir();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getTestedApksFromBundle() {
        return this.testData.getTestedApksFromBundle();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<DeviceProviderInstrumentTestTask> {
        private final DeviceProvider deviceProvider;
        private final Type type;
        private final AbstractTestDataImpl testData;
        private final FileCollection testTargetManifests;

        public CreationAction(VariantScope scope, DeviceProvider deviceProvider, Type type, AbstractTestDataImpl testData, FileCollection testTargetManifests) {
            super(scope);
            this.deviceProvider = deviceProvider;
            this.type = type;
            this.testData = testData;
            this.testTargetManifests = testTargetManifests;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName(this.deviceProvider.getName());
        }

        @Override
        public Class<DeviceProviderInstrumentTestTask> getType() {
            return DeviceProviderInstrumentTestTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends DeviceProviderInstrumentTestTask> taskProvider) {
            super.handleProvider(taskProvider);
            boolean isAdditionalAndroidTestOutputEnabled = this.getVariantScope().getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                if (isAdditionalAndroidTestOutputEnabled) {
                    this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.CONNECTED_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir, this.deviceProvider.getName());
                }
                this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.CODE_COVERAGE.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getCoverageDir, this.deviceProvider.getName());
            } else {
                if (isAdditionalAndroidTestOutputEnabled) {
                    this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.DEVICE_PROVIDER_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir, this.deviceProvider.getName());
                }
                this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.DEVICE_PROVIDER_CODE_COVERAGE.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getCoverageDir, this.deviceProvider.getName());
            }
            VariantScope scope = this.getVariantScope();
            if (scope.getVariantData() instanceof TestVariantData) {
                if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                    scope.getTaskContainer().setConnectedTestTask(taskProvider);
                    scope.getTaskContainer().setConnectedTask(taskProvider);
                } else {
                    scope.getTaskContainer().getProviderTestTaskList().add(taskProvider);
                }
            }
        }

        @Override
        public void configure(DeviceProviderInstrumentTestTask task) {
            String variantName;
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            Project project2 = scope.getGlobalScope().getProject();
            ProjectOptions projectOptions = scope.getGlobalScope().getProjectOptions();
            BaseVariantData testedVariantData = scope.getTestedVariantData();
            String string = variantName = testedVariantData != null ? testedVariantData.getName() : scope.getVariantData().getName();
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                task.setDescription("Installs and runs the tests for " + variantName + " on connected devices.");
            } else {
                task.setDescription(StringHelper.appendCapitalized((String)("Installs and runs the tests for " + variantName + " using provider: "), (String)this.deviceProvider.getName()));
            }
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.setGroup("verification");
            task.setTestData(this.testData);
            task.setFlavorName(this.testData.getFlavorName());
            task.setDeviceProvider(this.deviceProvider);
            task.testTargetManifests = this.testTargetManifests;
            task.setInstallOptions(scope.getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            boolean shardBetweenDevices = projectOptions.get(BooleanOption.ENABLE_TEST_SHARDING);
            TestOptions.Execution executionEnum = scope.getGlobalScope().getExtension().getTestOptions().getExecutionEnum();
            switch (executionEnum) {
                case ANDROID_TEST_ORCHESTRATOR: 
                case ANDROIDX_TEST_ORCHESTRATOR: {
                    Preconditions.checkArgument((!shardBetweenDevices ? 1 : 0) != 0, (Object)"Sharding is not supported with Android Test Orchestrator.");
                    task.testRunnerFactory = (splitSelect, processExecutor) -> new OnDeviceOrchestratorTestRunner(splitSelect, processExecutor, executionEnum, task.getExecutorServiceAdapter());
                    break;
                }
                case HOST: {
                    if (shardBetweenDevices) {
                        Integer numShards = projectOptions.get(IntegerOption.ANDROID_TEST_SHARD_COUNT);
                        task.testRunnerFactory = (splitSelect, processExecutor) -> new ShardedTestRunner(splitSelect, processExecutor, numShards, task.getExecutorServiceAdapter());
                        break;
                    }
                    task.testRunnerFactory = (splitSelect, processExecutor) -> new SimpleTestRunner(splitSelect, processExecutor, task.getExecutorServiceAdapter());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown value " + executionEnum));
                }
            }
            task.codeCoverageEnabled = scope.getVariantConfiguration().isTestCoverageEnabled();
            task.dependencies = scope.getVariantDependencies().getRuntimeClasspath();
            task.testExecution = executionEnum;
            String flavorFolder = this.testData.getFlavorName();
            if (!flavorFolder.isEmpty()) {
                flavorFolder = "flavors/" + flavorFolder;
            }
            String providerFolder = this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER ? "connected" : "device/" + this.deviceProvider.getName();
            String subFolder = "/" + providerFolder + "/" + flavorFolder;
            task.splitSelectExecProvider = scope.getGlobalScope().getSdkComponents().getSplitSelectExecutableProvider();
            String rootLocation = scope.getGlobalScope().getExtension().getTestOptions().getResultsDir();
            if (rootLocation == null) {
                rootLocation = scope.getGlobalScope().getBuildDir() + "/" + "outputs" + "/" + "androidTest-results";
            }
            task.getResultsDir().set(new File(rootLocation + subFolder));
            rootLocation = scope.getGlobalScope().getExtension().getTestOptions().getReportDir();
            if (rootLocation == null) {
                rootLocation = scope.getGlobalScope().getBuildDir() + "/" + "reports" + "/" + "androidTests";
            }
            task.reportsDir = project2.file((Object)(rootLocation + subFolder));
            task.buddyApks = (FileCollection)MoreObjects.firstNonNull((Object)project2.getConfigurations().findByName("androidTestUtil"), (Object)project2.files(new Object[0]));
            task.setEnabled(this.deviceProvider.isConfigured());
            task.getOutputs().upToDateWhen(it -> false);
        }

        public static enum Type {
            INTERNAL_CONNECTED_DEVICE_PROVIDER,
            CUSTOM_DEVICE_PROVIDER;

        }
    }

    private static interface TestRunnerFactory {
        public TestRunner build(File var1, ProcessExecutor var2);
    }
}

