/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;

public class TestVariantData
extends ApkVariantData {
    private final TestedVariantData testedVariantData;

    public TestVariantData(GlobalScope globalScope, TaskManager taskManager, GradleVariantConfiguration config2, TestedVariantData testedVariantData, Recorder recorder) {
        super(globalScope, taskManager, config2, recorder);
        this.testedVariantData = testedVariantData;
        this.getOutputFactory().addMainApk();
    }

    public TestedVariantData getTestedVariantData() {
        return this.testedVariantData;
    }

    @Override
    public String getDescription() {
        VariantType variantType = this.getType();
        String prefix = variantType.isApk() ? "android (on device) tests" : "unit tests";
        GradleVariantConfiguration config2 = this.getVariantConfiguration();
        if (config2.hasFlavors()) {
            StringBuilder sb = new StringBuilder(50);
            sb.append(prefix);
            sb.append(" for the ");
            StringHelper.appendCapitalized((StringBuilder)sb, (String)config2.getFlavorName());
            StringHelper.appendCapitalized((StringBuilder)sb, (String)((CoreBuildType)config2.getBuildType()).getName());
            sb.append(" build");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append(prefix);
        sb.append(" for the ");
        StringHelper.appendCapitalized((StringBuilder)sb, (String)((CoreBuildType)config2.getBuildType()).getName());
        sb.append(" build");
        return sb.toString();
    }
}

