/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dependency.VersionedCodeShrinker$Companion$WhenMappings;
import com.android.builder.dexing.R8Tool;
import com.android.builder.model.CodeShrinker;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.ProGuard;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/dependency/VersionedCodeShrinker;", "Ljava/io/Serializable;", "shrinker", "Lcom/android/builder/model/CodeShrinker;", "version", "", "(Lcom/android/builder/model/CodeShrinker;Ljava/lang/String;)V", "getShrinker", "()Lcom/android/builder/model/CodeShrinker;", "getVersion", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "gradle"})
public final class VersionedCodeShrinker
implements Serializable {
    @NotNull
    private final CodeShrinker shrinker;
    @NotNull
    private final String version;
    private static final Regex versionPattern;
    public static final Companion Companion;

    @NotNull
    public final CodeShrinker getShrinker() {
        return this.shrinker;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public VersionedCodeShrinker(@NotNull CodeShrinker shrinker, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)shrinker, (String)"shrinker");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.shrinker = shrinker;
        this.version = version;
    }

    static {
        Companion = new Companion(null);
        String string = "[^\\s.]+(?:\\.[^\\s.]+)+";
        boolean bl = false;
        versionPattern = new Regex(string);
    }

    @NotNull
    public final CodeShrinker component1() {
        return this.shrinker;
    }

    @NotNull
    public final String component2() {
        return this.version;
    }

    @NotNull
    public final VersionedCodeShrinker copy(@NotNull CodeShrinker shrinker, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)shrinker, (String)"shrinker");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return new VersionedCodeShrinker(shrinker, version);
    }

    public static /* synthetic */ VersionedCodeShrinker copy$default(VersionedCodeShrinker versionedCodeShrinker, CodeShrinker codeShrinker, String string, int n, Object object) {
        if ((n & 1) != 0) {
            codeShrinker = versionedCodeShrinker.shrinker;
        }
        if ((n & 2) != 0) {
            string = versionedCodeShrinker.version;
        }
        return versionedCodeShrinker.copy(codeShrinker, string);
    }

    @NotNull
    public String toString() {
        return "VersionedCodeShrinker(shrinker=" + this.shrinker + ", version=" + this.version + ")";
    }

    public int hashCode() {
        CodeShrinker codeShrinker = this.shrinker;
        String string = this.version;
        return (codeShrinker != null ? codeShrinker.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof VersionedCodeShrinker)) break block3;
                VersionedCodeShrinker versionedCodeShrinker = (VersionedCodeShrinker)object;
                if (!Intrinsics.areEqual((Object)this.shrinker, (Object)versionedCodeShrinker.shrinker) || !Intrinsics.areEqual((Object)this.version, (Object)versionedCodeShrinker.version)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final VersionedCodeShrinker of(@NotNull CodeShrinker codeShrinker) {
        return Companion.of(codeShrinker);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/dependency/VersionedCodeShrinker$Companion;", "", "()V", "versionPattern", "Lkotlin/text/Regex;", "getProguardVersionString", "", "of", "Lcom/android/build/gradle/internal/dependency/VersionedCodeShrinker;", "codeShrinker", "Lcom/android/builder/model/CodeShrinker;", "parseProguardVersion", "version", "parseProguardVersion$gradle", "gradle"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final VersionedCodeShrinker of(@NotNull CodeShrinker codeShrinker) {
            VersionedCodeShrinker versionedCodeShrinker;
            Intrinsics.checkParameterIsNotNull((Object)codeShrinker, (String)"codeShrinker");
            switch (VersionedCodeShrinker$Companion$WhenMappings.$EnumSwitchMapping$0[codeShrinker.ordinal()]) {
                case 1: {
                    versionedCodeShrinker = new VersionedCodeShrinker(CodeShrinker.PROGUARD, this.parseProguardVersion$gradle(this.getProguardVersionString()));
                    break;
                }
                case 2: {
                    versionedCodeShrinker = new VersionedCodeShrinker(CodeShrinker.R8, R8Tool.getR8Version());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return versionedCodeShrinker;
        }

        private final String getProguardVersionString() {
            try {
                Object object = ProGuard.class.getField("VERSION").get(null);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                return (String)object;
            }
            catch (Exception e) {
                LoggerWrapper.getLogger(VersionedCodeShrinker.class).warning("Unable to find ProGuard.VERSION field, assuming empty string.", new Object[0]);
                return "";
            }
        }

        @VisibleForTesting
        @NotNull
        public final String parseProguardVersion$gradle(@NotNull String version) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            MatchResult matcher = Regex.find$default((Regex)versionPattern, (CharSequence)version, (int)0, (int)2, null);
            if (matcher != null) {
                LoggerWrapper.getLogger(VersionedCodeShrinker.class).verbose("Parsed ProGuard version: " + (String)matcher.getGroupValues().get(0), new Object[0]);
                string = (String)matcher.getGroupValues().get(0);
            } else {
                LoggerWrapper.getLogger(VersionedCodeShrinker.class).warning("Cannot parse ProGuard version, assuming 0.0.0", new Object[0]);
                string = "0.0.0";
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

