/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.OptionInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.Option;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.EvalIssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J4\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u001d\u001a\u00020\f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0018\u0010 \u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010 \u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/errors/DeprecationReporterImpl;", "Lcom/android/build/gradle/internal/errors/DeprecationReporter;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "projectPath", "", "(Lcom/android/builder/errors/EvalIssueReporter;Lcom/android/build/gradle/options/ProjectOptions;Ljava/lang/String;)V", "suppressedOptionWarnings", "", "reportDeprecatedApi", "", "newApiElement", "oldApiElement", "url", "deprecationTarget", "Lcom/android/build/gradle/internal/errors/DeprecationReporter$DeprecationTarget;", "reportDeprecatedConfiguration", "newDslElement", "oldConfiguration", "reportDeprecatedOption", "option", "reportDeprecatedUsage", "oldDslElement", "reportDeprecatedValue", "dslElement", "oldValue", "newValue", "reportExperimentalOption", "Lcom/android/build/gradle/options/Option;", "value", "reportObsoleteUsage", "reportRenamedConfiguration", "newConfiguration", "Companion", "gradle"})
public final class DeprecationReporterImpl
implements DeprecationReporter {
    private final Set<String> suppressedOptionWarnings;
    private final EvalIssueReporter issueReporter;
    private final ProjectOptions projectOptions;
    private final String projectPath;
    private static final Set<String> obsoleteApis;
    private static final Set<OptionInfo> options;
    public static final Companion Companion;

    @Override
    public void reportDeprecatedUsage(@NotNull String newDslElement, @NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.DEPRECATED_DSL, (String)("DSL element '" + oldDslElement + "' is obsolete and has been replaced with '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '.'), (String)(oldDslElement + "::" + newDslElement + "::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportDeprecatedUsage(@NotNull String newDslElement, @NotNull String oldDslElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.DEPRECATED_DSL, (String)("DSL element '" + oldDslElement + "' is obsolete and has been replaced with '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + ".\n" + "For more information, see " + url + '.'), (String)(oldDslElement + "::" + newDslElement + "::" + deprecationTarget.name()), null, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportDeprecatedApi(@NotNull String newApiElement, @NotNull String oldApiElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newApiElement, (String)"newApiElement");
        Intrinsics.checkParameterIsNotNull((Object)oldApiElement, (String)"oldApiElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        if (!Companion.checkAndSet(oldApiElement)) {
            boolean debugApi = this.projectOptions.get(BooleanOption.DEBUG_OBSOLETE_API);
            String messageStart = "API '" + oldApiElement + "' is obsolete and has been replaced with '" + newApiElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + ".\n" + "For more information, see " + url + '.';
            String messageEnd = "";
            if (debugApi) {
                String string;
                Object[] $this$filterTo$iv$iv;
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                Object[] traces = thread.getStackTrace();
                Intrinsics.checkExpressionValueIsNotNull((Object)traces, (String)"traces");
                Object $this$filter$iv = traces;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo2 = false;
                void var15_17 = $this$filterTo$iv$iv;
                int n = ((void)var15_17).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv$iv;
                    void it = element$iv$iv = var15_17[j];
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    String string2 = v1.getClassName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.className");
                    if (!StringsKt.startsWith$default((String)string2, (String)"org.jetbrains.kotlin.gradle.plugin.", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List kotlin = (List)destination$iv$iv;
                $this$filter$iv = kotlin;
                StringBuilder stringBuilder = new StringBuilder();
                $i$f$filter = false;
                boolean bl = !$this$filter$iv.isEmpty();
                StringBuilder stringBuilder2 = stringBuilder;
                if (bl) {
                    string = "REASON: The Kotlin plugin is currently calling this deprecated API. Watch https://youtrack.jetbrains.com/issue/KT-25428 and, if possible, use a newer version of the Kotlin plugin that has fixed this issue.";
                } else {
                    String gradleFile2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])traces), (Function1)reportDeprecatedApi.gradleFile.1.INSTANCE), (Function1)reportDeprecatedApi.gradleFile.2.INSTANCE));
                    if (gradleFile2 != null) {
                        string = "REASON: Called from: " + gradleFile2;
                    } else {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        $this$filterTo$iv$iv = traces;
                        stringBuilder = stringBuilder2;
                        boolean $i$f$map = false;
                        void $i$f$filterTo2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        void var17_20 = $this$mapTo$iv$iv;
                        int n2 = ((void)var17_20).length;
                        for (int j = 0; j < n2; ++j) {
                            void it;
                            void item$iv$iv;
                            void var21_32 = item$iv$iv = var17_20[j];
                            Collection collection = destination$iv$iv2;
                            boolean bl2 = false;
                            StringBuilder stringBuilder3 = new StringBuilder();
                            void v6 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                            String string3 = stringBuilder3.append(v6.getClassName()).append('.').append(it.getMethodName()).append('(').append(it.getFileName()).append(':').append(it.getLineNumber()).append(")\n").toString();
                            collection.add(string3);
                        }
                        List list = (List)destination$iv$iv2;
                        stringBuilder2 = stringBuilder;
                        List formattedTraces = list;
                        string = "REASON: It is currently called from the following trace:\n" + CollectionsKt.joinToString$default((Iterable)formattedTraces, (CharSequence)"", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
                    }
                }
                messageEnd = stringBuilder2.append(string).append("\nWARNING: Debugging obsolete API calls can take time during configuration. It's recommended to not keep it on at all times.").toString();
            } else {
                messageEnd = "To determine what is calling " + oldApiElement + ", use -P" + BooleanOption.DEBUG_OBSOLETE_API.getPropertyName() + "=true on the command line to display more information.";
            }
            EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.DEPRECATED_DSL, (String)(messageStart + '\n' + messageEnd), null, null, (int)12, null);
        }
    }

    @Override
    public void reportObsoleteUsage(@NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.DEPRECATED_DSL, (String)("DSL element '" + oldDslElement + "' is obsolete and will be removed " + deprecationTarget.getRemovalTime() + '.'), (String)(oldDslElement + "::::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportObsoleteUsage(@NotNull String oldDslElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.DEPRECATED_DSL, (String)("DSL element '" + oldDslElement + "' is obsolete and will be removed " + deprecationTarget.getRemovalTime() + ".\n" + "For more information, see " + url + '.'), (String)(oldDslElement + "::::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportRenamedConfiguration(@NotNull String newConfiguration, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget, @Nullable String url) {
        Intrinsics.checkParameterIsNotNull((Object)newConfiguration, (String)"newConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        String msg = "Configuration '" + oldConfiguration + "' is obsolete and has been replaced with '" + newConfiguration + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '.';
        EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.USING_DEPRECATED_CONFIGURATION, (String)(url != null ? msg + " For more information see: " + url : msg), (String)(oldConfiguration + "::" + newConfiguration + "::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportDeprecatedConfiguration(@NotNull String newDslElement, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.USING_DEPRECATED_CONFIGURATION, (String)("Configuration '" + oldConfiguration + "' is obsolete and has been replaced with DSL element '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '.'), (String)(oldConfiguration + "::" + newDslElement + "::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportDeprecatedValue(@NotNull String dslElement, @NotNull String oldValue, @Nullable String newValue, @Nullable String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)dslElement, (String)"dslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.USING_DEPRECATED_DSL_VALUE, (String)("DSL element '" + dslElement + "' has a value '" + oldValue + "' which is obsolete " + (newValue != null ? "and has been replaced with '" + newValue + "'.\n" : "and has not been replaced.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + ".\n")), (String)url, null, (int)8, null);
    }

    @Override
    public void reportDeprecatedOption(@NotNull String option, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        if (this.suppressedOptionWarnings.contains(option)) {
            return;
        }
        if (!Companion.checkAndSet(option, null)) {
            EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, (String)("The option '" + option + "' is deprecated and should not be used anymore.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '.'), null, null, (int)12, null);
        }
    }

    @Override
    public void reportExperimentalOption(@NotNull Option<?> option, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.suppressedOptionWarnings.contains(option.getPropertyName())) {
            return;
        }
        if (!Companion.checkAndSet(option, value)) {
            EvalIssueReporter.reportWarning$default((EvalIssueReporter)this.issueReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, (String)("The option setting '" + option.getPropertyName() + '=' + value + "' is experimental and unsupported.\n" + (option.getDefaultValue() != null ? "The current default is '" + String.valueOf(option.getDefaultValue()) + "'.\n" : "") + option.getAdditionalInfo()), (String)option.getPropertyName(), null, (int)8, null);
        }
    }

    public DeprecationReporterImpl(@NotNull EvalIssueReporter issueReporter, @NotNull ProjectOptions projectOptions, @NotNull String projectPath) {
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        this.issueReporter = issueReporter;
        this.projectOptions = projectOptions;
        this.projectPath = projectPath;
        DeprecationReporterImpl deprecationReporterImpl = this;
        Object object = this.projectOptions.get(StringOption.SUPPRESS_UNSUPPORTED_OPTION_WARNINGS);
        if (object == null || (object = StringsKt.splitToSequence$default((CharSequence)((CharSequence)object), (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null)) == null || (object = SequencesKt.toSet((Sequence)object)) == null) {
            DeprecationReporterImpl deprecationReporterImpl2 = deprecationReporterImpl;
            boolean bl = false;
            Set set = SetsKt.emptySet();
            deprecationReporterImpl = deprecationReporterImpl2;
            object = set;
        }
        deprecationReporterImpl.suppressedOptionWarnings = object;
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        obsoleteApis = new LinkedHashSet();
        bl = false;
        options = new LinkedHashSet();
    }

    @Override
    public void reportDeprecatedOptions(@NotNull Set<? extends Option<?>> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        DeprecationReporter.DefaultImpls.reportDeprecatedOptions(this, options);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/errors/DeprecationReporterImpl$Companion;", "", "()V", "obsoleteApis", "", "", "options", "Lcom/android/build/gradle/internal/errors/OptionInfo;", "checkAndSet", "", "option", "value", "api", "clean", "", "gradle"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean checkAndSet(@NotNull String api) {
            Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
            Set set = obsoleteApis;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3;
                boolean bl4 = false;
                if (obsoleteApis.contains(api)) {
                    bl3 = true;
                } else {
                    obsoleteApis.add(api);
                    bl3 = false;
                }
                boolean bl5 = bl3;
                return bl5;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean checkAndSet(@NotNull Object option, @Nullable String value) {
            Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
            Set set = options;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3;
                boolean bl4 = false;
                OptionInfo info2 = new OptionInfo(option, value);
                if (options.contains(info2)) {
                    bl3 = true;
                } else {
                    options.add(info2);
                    bl3 = false;
                }
                boolean bl5 = bl3;
                return bl5;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clean() {
            Set set = obsoleteApis;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3 = false;
                obsoleteApis.clear();
                Unit unit = Unit.INSTANCE;
            }
            set = options;
            bl = false;
            boolean bl4 = false;
            synchronized (set) {
                boolean bl5 = false;
                options.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

