/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.CompileOptions;
import com.android.builder.model.JavaCompileOptions;
import java.io.Serializable;
import java.util.Objects;

final class DefaultJavaCompileOptions
implements JavaCompileOptions,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String sourceCompatibility;
    private final String targetCompatibility;
    private final String encoding;
    private final boolean coreLibraryDesugaringEnabled;

    DefaultJavaCompileOptions(CompileOptions options) {
        this.sourceCompatibility = options.getSourceCompatibility().toString();
        this.targetCompatibility = options.getTargetCompatibility().toString();
        this.encoding = options.getEncoding();
        this.coreLibraryDesugaringEnabled = options.getCoreLibraryDesugaringEnabled() == Boolean.TRUE;
    }

    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public boolean isCoreLibraryDesugaringEnabled() {
        return this.coreLibraryDesugaringEnabled;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJavaCompileOptions that = (DefaultJavaCompileOptions)o;
        return Objects.equals(this.sourceCompatibility, that.sourceCompatibility) && Objects.equals(this.targetCompatibility, that.targetCompatibility) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.coreLibraryDesugaringEnabled, that.coreLibraryDesugaringEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.sourceCompatibility, this.targetCompatibility, this.encoding, this.coreLibraryDesugaringEnabled);
    }
}

