/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;

abstract class LibraryImpl
implements Library,
Serializable {
    private final String buildId;
    private final String project;
    private final String name;
    private final MavenCoordinates requestedCoordinates;
    private final MavenCoordinates resolvedCoordinates;
    private final boolean isSkipped;
    private final boolean isProvided;

    LibraryImpl(String buildId, String project2, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isSkipped, boolean isProvided) {
        this.name = resolvedCoordinates.toString();
        this.buildId = buildId;
        this.project = project2;
        this.requestedCoordinates = requestedCoordinates;
        this.resolvedCoordinates = resolvedCoordinates;
        this.isSkipped = isSkipped;
        this.isProvided = isProvided;
    }

    protected LibraryImpl(Library clonedLibrary, boolean isSkipped) {
        this.name = clonedLibrary.getName();
        this.buildId = clonedLibrary.getBuildId();
        this.project = clonedLibrary.getProject();
        this.requestedCoordinates = clonedLibrary.getRequestedCoordinates();
        this.resolvedCoordinates = clonedLibrary.getResolvedCoordinates();
        this.isSkipped = isSkipped;
        this.isProvided = clonedLibrary.isProvided();
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public MavenCoordinates getRequestedCoordinates() {
        return this.requestedCoordinates;
    }

    public MavenCoordinates getResolvedCoordinates() {
        return this.resolvedCoordinates;
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public boolean isProvided() {
        return this.isProvided;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library2 = (LibraryImpl)o;
        return this.isSkipped == library2.isSkipped && this.isProvided == library2.isProvided && Objects.equal((Object)this.buildId, (Object)library2.buildId) && Objects.equal((Object)this.project, (Object)library2.project) && Objects.equal((Object)this.name, (Object)library2.name) && Objects.equal((Object)this.requestedCoordinates, (Object)library2.requestedCoordinates) && Objects.equal((Object)this.resolvedCoordinates, (Object)library2.resolvedCoordinates);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.buildId, this.project, this.name, this.requestedCoordinates, this.resolvedCoordinates, this.isSkipped, this.isProvided});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("buildId", (Object)this.buildId).add("project", (Object)this.project).add("requestedCoordinates", (Object)this.requestedCoordinates).add("resolvedCoordinates", (Object)this.resolvedCoordinates).add("isSkipped", this.isSkipped).add("isProvided", this.isProvided).toString();
    }
}

