/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.xml.sax.SAXException;

public class TestDataImpl
extends AbstractTestDataImpl {
    private final TestVariantData testVariantData;
    private final VariantDslInfo testVariantDslInfo;

    public TestDataImpl(TestVariantData testVariantData, Provider<Directory> testApkDir, FileCollection testedApksDir) {
        super(testVariantData.getVariantDslInfo(), testVariantData.getVariantSources(), testApkDir, testedApksDir);
        this.testVariantData = testVariantData;
        this.testVariantDslInfo = testVariantData.getVariantDslInfo();
        if (testVariantData.getOutputScope().getSplitsByType(VariantOutput.OutputType.FULL_SPLIT).size() > 1) {
            throw new RuntimeException("Multi-output in test variant not yet supported");
        }
    }

    @Override
    public void loadFromMetadataFile(File metadataFile) throws ParserConfigurationException, SAXException, IOException {
    }

    @Override
    public String getApplicationId() {
        return this.testVariantData.getVariantDslInfo().getApplicationId();
    }

    @Override
    public String getTestedApplicationId() {
        return this.testVariantDslInfo.getTestedApplicationId();
    }

    @Override
    public boolean isLibrary() {
        TestedVariantData testedVariantData = this.testVariantData.getTestedVariantData();
        BaseVariantData testedVariantData2 = (BaseVariantData)((Object)testedVariantData);
        return testedVariantData2.getVariantDslInfo().getVariantType().isAar();
    }

    public ImmutableList<File> getTestedApks(DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        BaseVariantData testedVariantData = (BaseVariantData)((Object)this.testVariantData.getTestedVariantData());
        ImmutableList.Builder apks = ImmutableList.builder();
        ImmutableList splitOutputs = ImmutableList.copyOf((Iterable)ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.APK.INSTANCE, testedVariantData.getScope().getArtifacts().getFinalProduct(InternalArtifactType.APK.INSTANCE)));
        apks.addAll((Iterable)SplitOutputMatcher.computeBestOutput((DeviceConfigProvider)deviceConfigProvider, (Collection)splitOutputs, testedVariantData.getVariantDslInfo().getSupportedAbis()));
        return apks.build();
    }
}

