/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.variant.VariantConfiguration;
import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.api.variant.impl.LibraryVariantPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Task;

public class LibraryVariantData
extends BaseVariantData
implements TestedVariantData {
    private final Map<VariantType, TestVariantData> testVariants = Maps.newHashMap();

    public LibraryVariantData(GlobalScope globalScope, TaskManager taskManager, VariantDslInfoImpl variantDslInfo, VariantSources variantSources, Recorder recorder) {
        super(globalScope, taskManager, variantDslInfo, variantSources, recorder);
        this.getPublicVariantPropertiesApi().addVariantOutput(this.getOutputFactory().addMainOutput(globalScope.getProjectBaseName() + "-" + this.getVariantDslInfo().getBaseName() + "." + "aar"));
    }

    @Override
    public String getDescription() {
        VariantDslInfo variantDslInfo = this.getVariantDslInfo();
        if (variantDslInfo.hasFlavors()) {
            StringBuilder sb = new StringBuilder(50);
            StringHelper.appendCapitalized((StringBuilder)sb, (String)variantDslInfo.getBuildType());
            sb.append(" build for flavor ");
            StringHelper.appendCapitalized((StringBuilder)sb, (String)variantDslInfo.getFlavorName());
            return sb.toString();
        }
        return StringHelper.capitalizeAndAppend((String)variantDslInfo.getBuildType(), (String)" build");
    }

    @Override
    public TestVariantData getTestVariantData(VariantType type) {
        return this.testVariants.get(type);
    }

    @Override
    public void setTestVariantData(TestVariantData testVariantData, VariantType type) {
        this.testVariants.put(type, testVariantData);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... generatedSourceFolders) {
        super.registerJavaGeneratingTask(task, generatedSourceFolders);
        if (this.scope.getTaskContainer().getGenerateAnnotationsTask() != null) {
            for (File f : generatedSourceFolders) {
                ((ExtractAnnotations)this.scope.getTaskContainer().getGenerateAnnotationsTask().get()).source(f);
            }
        }
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> generatedSourceFolders) {
        super.registerJavaGeneratingTask(task, generatedSourceFolders);
        if (this.scope.getTaskContainer().getGenerateAnnotationsTask() != null) {
            for (File f : generatedSourceFolders) {
                ((ExtractAnnotations)this.scope.getTaskContainer().getGenerateAnnotationsTask().get()).source(f);
            }
        }
    }

    @Override
    VariantImpl<?> instantiatePublicVariantObject(VariantConfiguration publicVariantConfiguration) {
        return new LibraryVariantImpl(publicVariantConfiguration);
    }

    @Override
    VariantPropertiesImpl instantiatePublicVariantPropertiesObject(VariantConfiguration publicVariantConfiguration) {
        return (VariantPropertiesImpl)this.scope.getGlobalScope().getProject().getObjects().newInstance(LibraryVariantPropertiesImpl.class, new Object[]{this.scope.getGlobalScope().getDslScope(), this.scope, this.scope.getArtifacts().getOperations(), publicVariantConfiguration});
    }
}

