/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.variant.VariantConfiguration;
import com.android.build.api.variant.impl.VariantConfigurationImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.variant.FlavorCombination;
import com.android.build.gradle.internal.variant.VariantCombinator;
import com.android.build.gradle.internal.variant.VariantCombinatorKt;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.builder.core.VariantType;
import com.android.builder.errors.EvalIssueReporter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\tJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/variant/VariantCombinator;", "", "variantModel", "Lcom/android/build/gradle/internal/variant/VariantModel;", "errorReporter", "Lcom/android/build/gradle/internal/errors/SyncIssueHandler;", "variantType", "Lcom/android/builder/core/VariantType;", "flavorDimensionList", "", "", "(Lcom/android/build/gradle/internal/variant/VariantModel;Lcom/android/build/gradle/internal/errors/SyncIssueHandler;Lcom/android/builder/core/VariantType;Ljava/util/List;)V", "combineFlavorsAndBuildTypes", "Lcom/android/build/api/variant/VariantConfiguration;", "flavorCombos", "Lcom/android/build/gradle/internal/variant/FlavorCombination;", "computeFlavorlessVariants", "computeVariants", "computeVariantsWithFlavors", "validateFlavorDimensions", "gradle"})
public final class VariantCombinator {
    private final VariantModel variantModel;
    private final SyncIssueHandler errorReporter;
    private final VariantType variantType;
    private final List<String> flavorDimensionList;

    @NotNull
    public final List<VariantConfiguration> computeVariants() {
        if (this.variantModel.getProductFlavors().isEmpty()) {
            return this.computeFlavorlessVariants();
        }
        return this.computeVariantsWithFlavors();
    }

    private final List<VariantConfiguration> computeFlavorlessVariants() {
        List list;
        if (this.variantModel.getBuildTypes().isEmpty()) {
            ImmutableList immutableList = ImmutableList.of((Object)new VariantConfigurationImpl("main", null, null, false, 14, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(Variant\u2026pl(variantName = \"main\"))");
            list = (List)immutableList;
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String buildType : this.variantModel.getBuildTypes().keySet()) {
                Object object = this.variantModel.getBuildTypes().get(buildType);
                boolean isDebuggable = object != null && (object = ((BuildTypeData)object).getBuildType()) != null ? object.isDebuggable() : false;
                builder.add((Object)new VariantConfigurationImpl(buildType, buildType, null, isDebuggable, 4, null));
            }
            ImmutableList immutableList = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
            list = (List)immutableList;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VariantConfiguration> computeVariantsWithFlavors() {
        ImmutableList.Builder builder;
        void $this$groupByTo$iv$iv;
        List<String> flavorDimensionList = this.validateFlavorDimensions();
        Sequence $this$groupBy$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.variantModel.getProductFlavors().values()), (Function1)computeVariantsWithFlavors.flavorMap.1.INSTANCE);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            String key$iv$iv;
            ProductFlavor it2 = (ProductFlavor)element$iv$iv;
            boolean $i$a$-groupBy-VariantCombinator$computeVariantsWithFlavors$flavorMap$42 = false;
            ProductFlavor productFlavor = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"it");
            if (productFlavor.getDimension() == null) {
                Intrinsics.throwNpe();
            }
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            ProductFlavor $i$a$-groupBy-VariantCombinator$computeVariantsWithFlavors$flavorMap$42 = (ProductFlavor)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = v2.getName();
            list.add(string);
        }
        Map flavorMap2 = destination$iv$iv;
        ImmutableList.Builder builder2 = builder = ImmutableList.builder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        VariantCombinatorKt.createProductFlavorCombinations$default(flavorDimensionList, flavorMap2, builder2, this.errorReporter, null, 0, 48, null);
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return this.combineFlavorsAndBuildTypes((List)immutableList);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VariantConfiguration> combineFlavorsAndBuildTypes(List<FlavorCombination> flavorCombos) {
        if (this.variantModel.getBuildTypes().isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = flavorCombos;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FlavorCombination flavorCombination = (FlavorCombination)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List<String> flavorNames = it.getFlavorNames();
                VariantConfigurationImpl variantConfigurationImpl = new VariantConfigurationImpl(VariantCombinatorKt.access$computeVariantName(flavorNames, null, this.variantType), null, flavorNames, false, 10, null);
                collection.add(variantConfigurationImpl);
            }
            return (List)destination$iv$iv;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String buildType : this.variantModel.getBuildTypes().keySet()) {
            Collection<VariantConfigurationImpl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable destination$iv$iv = flavorCombos;
            ImmutableList.Builder builder2 = builder;
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FlavorCombination flavorCombination = (FlavorCombination)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                List<String> flavors = it.getFlavorNames();
                Object object = this.variantModel.getBuildTypes().get(buildType);
                boolean isDebuggable = object != null && (object = ((BuildTypeData)object).getBuildType()) != null ? object.isDebuggable() : false;
                VariantConfigurationImpl variantConfigurationImpl = new VariantConfigurationImpl(VariantCombinatorKt.access$computeVariantName(flavors, buildType, this.variantType), buildType, flavors, isDebuggable);
                collection.add(variantConfigurationImpl);
            }
            collection = (List)destination$iv$iv2;
            builder2.addAll((Iterable)collection);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    private final List<String> validateFlavorDimensions() {
        if (this.flavorDimensionList.isEmpty()) {
            EvalIssueReporter.reportError$default((EvalIssueReporter)this.errorReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION, (String)"All flavors must now belong to a named flavor dimension. Learn more at https://d.android.com/r/tools/flavorDimensions-missing-error-message.html", null, null, (int)12, null);
            boolean bl = false;
            Set dimensions = new LinkedHashSet();
            String fakeDimension = "agp-missing-dimension-for-sync-only";
            for (ProductFlavorData<ProductFlavor> flavor : this.variantModel.getProductFlavors().values()) {
                ProductFlavor productFlavor;
                Intrinsics.checkExpressionValueIsNotNull((Object)flavor.getProductFlavor(), (String)"flavor.productFlavor");
                String dim = productFlavor.getDimension();
                if (dim == null) {
                    productFlavor.setDimension(fakeDimension);
                    continue;
                }
                dimensions.add(dim);
            }
            if (dimensions.isEmpty()) {
                dimensions.add(fakeDimension);
            }
            return CollectionsKt.toList((Iterable)dimensions);
        }
        if (this.flavorDimensionList.size() == 1) {
            String dimensionName = this.flavorDimensionList.get(0);
            for (ProductFlavorData<ProductFlavor> flavorData : this.variantModel.getProductFlavors().values()) {
                ProductFlavor flavor;
                Intrinsics.checkExpressionValueIsNotNull((Object)flavorData.getProductFlavor(), (String)"flavorData.productFlavor");
                if (flavor.getDimension() != null) continue;
                flavor.setDimension(dimensionName);
            }
        }
        return this.flavorDimensionList;
    }

    public VariantCombinator(@NotNull VariantModel variantModel, @NotNull SyncIssueHandler errorReporter, @NotNull VariantType variantType, @NotNull List<String> flavorDimensionList) {
        Intrinsics.checkParameterIsNotNull((Object)variantModel, (String)"variantModel");
        Intrinsics.checkParameterIsNotNull((Object)((Object)errorReporter), (String)"errorReporter");
        Intrinsics.checkParameterIsNotNull((Object)variantType, (String)"variantType");
        Intrinsics.checkParameterIsNotNull(flavorDimensionList, (String)"flavorDimensionList");
        this.variantModel = variantModel;
        this.errorReporter = errorReporter;
        this.variantType = variantType;
        this.flavorDimensionList = flavorDimensionList;
    }
}

