/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.compiling.BuildConfigGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00101\u001a\u000202H\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u0004\u0018\u00010\u00058GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00108G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u00020'8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0007R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0007\u00a8\u00064"}, d2={"Lcom/android/build/gradle/tasks/GenerateBuildConfig;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "appPackageName", "Lorg/gradle/api/provider/Property;", "", "getAppPackageName", "()Lorg/gradle/api/provider/Property;", "buildConfigPackageName", "getBuildConfigPackageName", "buildTypeName", "getBuildTypeName", "()Ljava/lang/String;", "setBuildTypeName", "(Ljava/lang/String;)V", "debuggable", "", "getDebuggable", "flavorName", "getFlavorName", "flavorNamesWithDimensionNames", "Lorg/gradle/api/provider/ListProperty;", "getFlavorNamesWithDimensionNames", "()Lorg/gradle/api/provider/ListProperty;", "<set-?>", "isLibrary", "()Z", "itemValues", "", "getItemValues", "()Ljava/util/List;", "items", "", "getItems", "mergedManifests", "Lorg/gradle/api/file/DirectoryProperty;", "getMergedManifests", "()Lorg/gradle/api/file/DirectoryProperty;", "sourceOutputDir", "Ljava/io/File;", "getSourceOutputDir", "()Ljava/io/File;", "setSourceOutputDir", "(Ljava/io/File;)V", "versionCode", "", "getVersionCode", "versionName", "getVersionName", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class GenerateBuildConfig
extends NonIncrementalTask {
    @NotNull
    public File sourceOutputDir;
    @Nullable
    private String buildTypeName;
    private boolean isLibrary;

    @OutputDirectory
    @NotNull
    public final File getSourceOutputDir() {
        File file = this.sourceOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOutputDir");
        }
        return file;
    }

    public final void setSourceOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.sourceOutputDir = file;
    }

    @Input
    @Optional
    @Nullable
    public final String getBuildTypeName() {
        return this.buildTypeName;
    }

    public final void setBuildTypeName(@Nullable String string) {
        this.buildTypeName = string;
    }

    @Input
    public final boolean isLibrary() {
        return this.isLibrary;
    }

    @Input
    @NotNull
    public abstract Property<String> getBuildConfigPackageName();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAppPackageName();

    @Input
    @NotNull
    public abstract Property<Boolean> getDebuggable();

    @Input
    @NotNull
    public abstract Property<String> getFlavorName();

    @Input
    @NotNull
    public abstract ListProperty<String> getFlavorNamesWithDimensionNames();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVersionName();

    @Input
    @NotNull
    public abstract Property<Integer> getVersionCode();

    @Input
    @NotNull
    public final List<String> getItemValues() {
        List resolvedItems = (List)this.getItems().get();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object item : resolvedItems) {
            if (item instanceof String) {
                list.add(item);
                continue;
            }
            if (!(item instanceof ClassField)) continue;
            list.add(((ClassField)item).getType());
            list.add(((ClassField)item).getName());
            list.add(((ClassField)item).getValue());
        }
        ArrayList arrayList = list;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"list");
        return arrayList;
    }

    @Internal
    @NotNull
    public abstract ListProperty<Object> getItems();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getMergedManifests();

    @Override
    protected void doTaskAction() {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        File file = this.sourceOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOutputDir");
        }
        File destinationDir = file;
        FileUtils.cleanOutputDir((File)destinationDir);
        File file2 = this.sourceOutputDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOutputDir");
        }
        BuildConfigGenerator generator = new BuildConfigGenerator(file2, (String)this.getBuildConfigPackageName().get());
        Object object2 = this.getDebuggable().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"debuggable.get()");
        generator.addField("boolean", "DEBUG", (Boolean)object2 != false ? "Boolean.parseBoolean(\"true\")" : "false");
        if (this.isLibrary) {
            generator.addField("String", "LIBRARY_PACKAGE_NAME", '\"' + (String)this.getBuildConfigPackageName().get() + '\"');
        } else {
            generator.addField("String", "APPLICATION_ID", '\"' + (String)this.getAppPackageName().get() + '\"');
        }
        String string = this.buildTypeName;
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            generator.addField("String", "BUILD_TYPE", '\"' + (String)it + '\"');
        }
        object = this.getFlavorName().get();
        bl2 = false;
        bl = false;
        it = (String)object;
        boolean bl4 = false;
        Object object3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
        CharSequence charSequence = (CharSequence)object3;
        boolean bl5 = false;
        if (charSequence.length() > 0) {
            generator.addField("String", "FLAVOR", '\"' + (String)it + '\"');
        }
        Object object4 = this.getVersionCode().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"versionCode.get()");
        generator.addField("int", "VERSION_CODE", Integer.toString(((Number)object4).intValue())).addField("String", "VERSION_NAME", '\"' + (String)this.getVersionName().getOrElse((Object)"") + '\"').addItems((Collection)this.getItems().get());
        List flavors = (List)this.getFlavorNamesWithDimensionNames().get();
        int count = flavors.size();
        if (count > 1) {
            for (int i2 = 0; i2 < count; i2 += 2) {
                generator.addField("String", "FLAVOR_" + (String)flavors.get(i2 + 1), '\"' + (String)flavors.get(i2) + '\"');
            }
        }
        generator.generate();
    }

    public static final /* synthetic */ boolean access$isLibrary$p(GenerateBuildConfig $this) {
        return $this.isLibrary;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/GenerateBuildConfig$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/GenerateBuildConfig;", "variantProperties", "Lcom/android/build/api/variant/impl/VariantPropertiesImpl;", "(Lcom/android/build/api/variant/impl/VariantPropertiesImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateBuildConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<GenerateBuildConfig> type;
        private final VariantPropertiesImpl variantProperties;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<GenerateBuildConfig> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends GenerateBuildConfig> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateBuildConfigTask(taskProvider);
        }

        @Override
        public void configure(@NotNull GenerateBuildConfig task) {
            Provider provider;
            Provider provider2;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BaseVariantData baseVariantData = this.getVariantScope().getVariantData();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
            BaseVariantData variantData = baseVariantData;
            VariantDslInfo variantDslInfo = variantData.getVariantDslInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)variantDslInfo, (String)"variantData.variantDslInfo");
            VariantDslInfo variantDslInfo2 = variantDslInfo;
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            Project project2 = globalScope.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
            Project project3 = project2;
            task.getBuildConfigPackageName().set(project3.provider((Callable)new Callable<String>(variantDslInfo2){
                final /* synthetic */ VariantDslInfo $variantDslInfo;

                @NotNull
                public final String call() {
                    return this.$variantDslInfo.getOriginalApplicationId();
                }
                {
                    this.$variantDslInfo = variantDslInfo;
                }
            }));
            task.getBuildConfigPackageName().disallowChanges();
            if (!variantDslInfo2.getVariantType().isAar()) {
                task.getAppPackageName().set((Provider)this.variantProperties.getApplicationId());
            }
            task.getAppPackageName().disallowChanges();
            Property<Integer> mainSplit = variantData.getPublicVariantPropertiesApi().getOutputs().getMainSplit();
            Property<Integer> property = task.getVersionCode();
            Property<Integer> property2 = mainSplit;
            if (property2 != null && (property2 = property2.getVersionCode()) != null) {
                provider2 = (Provider)property2;
            } else {
                Provider provider3 = task.getProject().provider((Callable)new Callable<Integer>(variantDslInfo2){
                    final /* synthetic */ VariantDslInfo $variantDslInfo;

                    public final int call() {
                        return this.$variantDslInfo.getVersionCode();
                    }
                    {
                        this.$variantDslInfo = variantDslInfo;
                    }
                });
                provider2 = provider3;
                Intrinsics.checkExpressionValueIsNotNull((Object)provider3, (String)"task.project.provider { \u2026iantDslInfo.versionCode }");
            }
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
            Property<String> property3 = task.getVersionName();
            Object object = mainSplit;
            if (object != null && (object = object.getVersionName()) != null) {
                provider = (Provider)object;
            } else {
                Provider provider4 = task.getProject().provider((Callable)new Callable<String>(variantDslInfo2){
                    final /* synthetic */ VariantDslInfo $variantDslInfo;

                    @Nullable
                    public final String call() {
                        return this.$variantDslInfo.getVersionName();
                    }
                    {
                        this.$variantDslInfo = variantDslInfo;
                    }
                });
                provider = provider4;
                Intrinsics.checkExpressionValueIsNotNull((Object)provider4, (String)"task.project.provider { \u2026iantDslInfo.versionName }");
            }
            HasConfigurableValuesKt.setDisallowChanges(property3, provider);
            HasConfigurableValuesKt.setDisallowChanges(task.getDebuggable(), variantData.getPublicVariantApi().isDebuggable());
            task.setBuildTypeName(variantDslInfo2.getBuildType());
            task.getFlavorName().set(project3.provider((Callable)new Callable<String>(variantDslInfo2){
                final /* synthetic */ VariantDslInfo $variantDslInfo;

                @NotNull
                public final String call() {
                    return this.$variantDslInfo.getFlavorName();
                }
                {
                    this.$variantDslInfo = variantDslInfo;
                }
            }));
            task.getFlavorName().disallowChanges();
            task.getFlavorNamesWithDimensionNames().set(project3.provider((Callable)new Callable<List<? extends String>>(variantDslInfo2){
                final /* synthetic */ VariantDslInfo $variantDslInfo;

                @NotNull
                public final List<String> call() {
                    return this.$variantDslInfo.getFlavorNamesWithDimensionNames();
                }
                {
                    this.$variantDslInfo = variantDslInfo;
                }
            }));
            task.getFlavorNamesWithDimensionNames().disallowChanges();
            task.getItems().set(project3.provider((Callable)new Callable<List<? extends Object>>(variantDslInfo2){
                final /* synthetic */ VariantDslInfo $variantDslInfo;

                @NotNull
                public final List<Object> call() {
                    return this.$variantDslInfo.getBuildConfigItems();
                }
                {
                    this.$variantDslInfo = variantDslInfo;
                }
            }));
            task.getItems().disallowChanges();
            File file = this.getVariantScope().getBuildConfigSourceOutputDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variantScope.buildConfigSourceOutputDir");
            task.setSourceOutputDir(file);
            if (this.getVariantScope().getVariantDslInfo().getVariantType().isTestComponent()) {
                this.getVariantScope().getArtifacts().setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.MERGED_MANIFESTS.INSTANCE, (Property)task.getMergedManifests());
            }
            task.isLibrary = variantDslInfo2.getVariantType().isAar();
        }

        public CreationAction(@NotNull VariantPropertiesImpl variantProperties) {
            Intrinsics.checkParameterIsNotNull((Object)variantProperties, (String)"variantProperties");
            super(variantProperties.getVariantScope());
            this.variantProperties = variantProperties;
            String string = this.getVariantScope().getTaskName("generate", "BuildConfig");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026generate\", \"BuildConfig\")");
            this.name = string;
            this.type = GenerateBuildConfig.class;
        }
    }
}

