/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.variant.LibraryVariantProperties;
import com.android.build.api.variant.VariantConfiguration;
import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.api.variant.impl.LibraryVariantPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;
import org.gradle.api.NamedDomainObjectContainer;

public class LibraryVariantFactory
extends BaseVariantFactory {
    public LibraryVariantFactory(GlobalScope globalScope) {
        super(globalScope);
    }

    @Override
    public VariantImpl<LibraryVariantProperties> createVariantObject(VariantConfiguration variantConfiguration, VariantDslInfo variantDslInfo) {
        return (VariantImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(LibraryVariantImpl.class, new Object[]{variantConfiguration, variantDslInfo});
    }

    @Override
    public VariantPropertiesImpl createVariantPropertiesObject(VariantConfiguration variantConfiguration, VariantScope variantScope) {
        return (VariantPropertiesImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(LibraryVariantPropertiesImpl.class, new Object[]{this.globalScope.getDslScope(), variantScope, variantScope.getArtifacts().getOperations(), variantConfiguration});
    }

    @Override
    public BaseVariantData createVariantData(VariantScope variantScope, VariantDslInfoImpl variantDslInfo, VariantImpl publicVariantApi, VariantPropertiesImpl publicVariantPropertiesApi, VariantSources variantSources, TaskManager taskManager) {
        return new LibraryVariantData(this.globalScope, taskManager, variantScope, variantDslInfo, publicVariantApi, publicVariantPropertiesApi, variantSources);
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return com.android.build.gradle.internal.api.LibraryVariantImpl.class;
    }

    @Override
    public VariantType getVariantType() {
        return VariantTypeImpl.LIBRARY;
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantInputModel model2) {
        String applicationIdSuffix;
        super.validateModel(model2);
        IssueReporter issueReporter = this.globalScope.getDslScope().getIssueReporter();
        if (model2.getDefaultConfig().getProductFlavor().getApplicationId() != null) {
            String applicationId = model2.getDefaultConfig().getProductFlavor().getApplicationId();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationId. applicationId is set to '" + applicationId + "' in default config.", applicationId);
        }
        if (model2.getDefaultConfig().getProductFlavor().getApplicationIdSuffix() != null) {
            String applicationIdSuffix2 = model2.getDefaultConfig().getProductFlavor().getApplicationIdSuffix();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix2 + "' in default config.", applicationIdSuffix2);
        }
        for (BuildTypeData buildTypeData : model2.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = buildTypeData.getBuildType().getApplicationIdSuffix();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in build type '" + buildTypeData.getBuildType().getName() + "'.", applicationIdSuffix);
        }
        for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
            if (productFlavorData.getProductFlavor().getApplicationId() != null) {
                String applicationId = productFlavorData.getProductFlavor().getApplicationId();
                issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationId. applicationId is set to '" + applicationId + "' in flavor '" + productFlavorData.getProductFlavor().getName() + "'.", applicationId);
            }
            if (productFlavorData.getProductFlavor().getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = productFlavorData.getProductFlavor().getApplicationIdSuffix();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in flavor '" + productFlavorData.getProductFlavor().getName() + "'.", applicationIdSuffix);
        }
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

