/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;

public class CompileOptions
implements com.android.build.api.dsl.CompileOptions {
    private static final String VERSION_PREFIX = "VERSION_";
    private JavaVersion sourceCompatibility;
    private JavaVersion targetCompatibility;
    private String encoding = Charsets.UTF_8.name();
    private Boolean incremental = null;
    private Boolean coreLibraryDesugaringEnabled = null;
    @VisibleForTesting
    JavaVersion defaultJavaVersion = JavaVersion.VERSION_1_6;

    @Inject
    public CompileOptions() {
    }

    public void setSourceCompatibility(Object sourceCompatibility) {
        this.sourceCompatibility = CompileOptions.convert(sourceCompatibility);
    }

    public void setSourceCompatibility(JavaVersion sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
    }

    public JavaVersion getSourceCompatibility() {
        return this.sourceCompatibility != null ? this.sourceCompatibility : this.defaultJavaVersion;
    }

    public void setTargetCompatibility(Object targetCompatibility) {
        this.targetCompatibility = CompileOptions.convert(targetCompatibility);
    }

    public void setTargetCompatibility(JavaVersion targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    public JavaVersion getTargetCompatibility() {
        return this.targetCompatibility != null ? this.targetCompatibility : this.defaultJavaVersion;
    }

    public void setEncoding(String encoding) {
        this.encoding = (String)Preconditions.checkNotNull((Object)encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDefaultJavaVersion(JavaVersion defaultJavaVersion) {
        this.defaultJavaVersion = (JavaVersion)Preconditions.checkNotNull((Object)defaultJavaVersion);
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public Boolean getCoreLibraryDesugaringEnabled() {
        return this.coreLibraryDesugaringEnabled;
    }

    public void setCoreLibraryDesugaringEnabled(boolean coreLibraryDesugaringEnabled) {
        this.coreLibraryDesugaringEnabled = coreLibraryDesugaringEnabled;
    }

    private static JavaVersion convert(Object version) {
        String versionString;
        if (version instanceof String && (versionString = (String)version).toUpperCase(Locale.ENGLISH).startsWith(VERSION_PREFIX)) {
            version = versionString.substring(VERSION_PREFIX.length()).replace('_', '.');
        }
        return JavaVersion.toVersion((Object)version);
    }
}

