/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KeymaestroHybridEncrypter {
    private static final byte VERSION = 0;
    private static final int KEY_ID_LENGTH = 4;
    private static final int FIELD_LENGTH = 32;
    private static final int POINT_LENGTH = 64;
    private static final String AES = "AES";
    private static final String AES_GCM = "AES/GCM/NoPadding";
    private static final int DEM_KEY_LENGTH = 16;
    private static final int NONCE_LENGTH = 12;
    private static final int TAG_LENGTH = 16;
    static final int CONSTRUCTOR_KEY_LENGTH = 68;
    static final ECFieldFp FIELD;
    static final EllipticCurve CURVE;
    static final ECParameterSpec CURVE_SPEC;
    private static final SecureRandom random;
    private final byte[] keyId = new byte[4];
    private final byte[] kemToken;
    private final byte[] aesKey;

    public KeymaestroHybridEncrypter(byte[] publicKey) throws GeneralSecurityException {
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey is null");
        }
        if (publicKey.length != 68) {
            throw new IllegalArgumentException("publicKey should be 68 bytes");
        }
        System.arraycopy(publicKey, 0, this.keyId, 0, 4);
        ECPoint peerPublicKey = KeymaestroHybridEncrypter.deserializePoint(publicKey, 4, 64);
        KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
        gen.initialize(CURVE_SPEC);
        KeyPair keypair = gen.genKeyPair();
        ECPrivateKey jcePrivateKey = (ECPrivateKey)keypair.getPrivate();
        ECPoint jcePublicKey = ((ECPublicKey)keypair.getPublic()).getW();
        this.kemToken = KeymaestroHybridEncrypter.serializePoint(jcePublicKey);
        byte[] ecdhResult = KeymaestroHybridEncrypter.ecdh(jcePrivateKey, peerPublicKey);
        this.aesKey = KeymaestroHybridEncrypter.hkdf(KeymaestroHybridEncrypter.cat(this.kemToken, ecdhResult), null, "GOOGLE_KEYMASTER".getBytes(StandardCharsets.UTF_8), 16);
    }

    public byte[] encrypt(byte[] plaintext) throws GeneralSecurityException {
        byte[] nonce = new byte[12];
        random.nextBytes(nonce);
        ByteArrayOutputStream ciphertext = new ByteArrayOutputStream(81 + plaintext.length + 16);
        ciphertext.write(0);
        ciphertext.write(this.keyId, 0, this.keyId.length);
        ciphertext.write(this.kemToken, 0, this.kemToken.length);
        ciphertext.write(nonce, 0, nonce.length);
        byte[] demResult = KeymaestroHybridEncrypter.demEncrypt(this.aesKey, nonce, plaintext);
        ciphertext.write(demResult, 0, demResult.length);
        return ciphertext.toByteArray();
    }

    private static byte[] cat(byte[] left, byte[] right) {
        byte[] result = new byte[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    private static byte[] demEncrypt(byte[] aesKey, byte[] nonce, byte[] plaintext) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_GCM);
        cipher.init(1, (Key)new SecretKeySpec(aesKey, AES), new GCMParameterSpec(128, nonce));
        byte[] ciphertext = new byte[plaintext.length + 16];
        int resultLength = cipher.doFinal(plaintext, 0, plaintext.length, ciphertext);
        if (resultLength != ciphertext.length) {
            throw new GeneralSecurityException("Length mismatch");
        }
        return ciphertext;
    }

    static byte[] ecdh(ECPrivateKey privateKey, ECPoint publicPoint) throws GeneralSecurityException {
        ECPublicKeySpec publicSpec = new ECPublicKeySpec(publicPoint, CURVE_SPEC);
        KeyFactory kf = KeyFactory.getInstance("EC");
        PublicKey publicKey = kf.generatePublic(publicSpec);
        KeyAgreement ka = KeyAgreement.getInstance("ECDH");
        ka.init(privateKey);
        ka.doPhase(publicKey, true);
        return ka.generateSecret();
    }

    static byte[] hkdf(byte[] ikm, byte[] salt, byte[] info2, int extractBytes) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("HMACSHA256");
        if (salt == null) {
            salt = new byte[mac.getMacLength()];
        }
        mac.init(new SecretKeySpec(salt, mac.getAlgorithm()));
        byte[] prk = mac.doFinal(ikm);
        mac.init(new SecretKeySpec(prk, mac.getAlgorithm()));
        int digestLength = mac.getMacLength();
        int blocks = extractBytes / digestLength;
        if (blocks * digestLength != extractBytes) {
            ++blocks;
        }
        if (blocks > 255) {
            throw new IllegalArgumentException("extracting too many bytes at once");
        }
        byte[] result = new byte[extractBytes];
        byte[] digest = new byte[]{};
        for (int i2 = 0; i2 < blocks; ++i2) {
            mac.update(digest);
            mac.update(info2);
            mac.update((byte)(i2 + 1));
            digest = mac.doFinal();
            if (i2 < blocks - 1) {
                System.arraycopy(digest, 0, result, i2 * digestLength, digestLength);
                continue;
            }
            System.arraycopy(digest, 0, result, i2 * digestLength, extractBytes - (blocks - 1) * digestLength);
        }
        return result;
    }

    static void fitBigInteger(BigInteger bigInt, byte[] output2, int offset, int length) {
        byte[] array = bigInt.toByteArray();
        if (array.length > length + 1) {
            throw new IllegalArgumentException("Array is too small to hold this BigInteger");
        }
        if (array.length > length) {
            System.arraycopy(array, array.length - length, output2, offset, length);
        } else {
            System.arraycopy(array, 0, output2, offset + length - array.length, array.length);
        }
    }

    static ECPrivateKey deserializePrivateKey(byte[] privateKey) throws GeneralSecurityException {
        KeyFactory kf = KeyFactory.getInstance("EC");
        BigInteger exponent = new BigInteger(1, privateKey);
        ECPrivateKeySpec spec2 = new ECPrivateKeySpec(exponent, CURVE_SPEC);
        return (ECPrivateKey)kf.generatePrivate(spec2);
    }

    private static byte[] serializePoint(ECPoint point) throws GeneralSecurityException {
        byte[] result = new byte[64];
        KeymaestroHybridEncrypter.fitBigInteger(point.getAffineX(), result, 0, 32);
        KeymaestroHybridEncrypter.fitBigInteger(point.getAffineY(), result, 32, 32);
        return result;
    }

    static ECPoint deserializePoint(byte[] serializedPoint) throws GeneralSecurityException {
        return KeymaestroHybridEncrypter.deserializePoint(serializedPoint, 0, serializedPoint.length);
    }

    private static ECPoint deserializePoint(byte[] serializedPoint, int offset, int length) throws GeneralSecurityException {
        BigInteger y;
        if (length != 64) {
            throw new IllegalArgumentException("serialized point length is too short");
        }
        BigInteger x = new BigInteger(1, Arrays.copyOfRange(serializedPoint, offset, offset + 32));
        ECPoint point = new ECPoint(x, y = new BigInteger(1, Arrays.copyOfRange(serializedPoint, offset + 32, offset + 64)));
        if (!KeymaestroHybridEncrypter.isPointOnCurve(point)) {
            throw new GeneralSecurityException("point is not on the curve");
        }
        return point;
    }

    private static boolean isPointOnCurve(ECPoint point) throws GeneralSecurityException {
        BigInteger p = FIELD.getP();
        BigInteger x = point.getAffineX();
        BigInteger y = point.getAffineY();
        if (x == null || y == null) {
            throw new GeneralSecurityException("point is at infinity");
        }
        if (x.signum() == -1 || x.compareTo(p) != -1) {
            throw new GeneralSecurityException("x is out of range");
        }
        if (y.signum() == -1 || y.compareTo(p) != -1) {
            throw new GeneralSecurityException("y is out of range");
        }
        BigInteger lhs = y.multiply(y).mod(p);
        BigInteger rhs = x.multiply(x).add(CURVE.getA()).multiply(x).add(CURVE.getB()).mod(p);
        return lhs.equals(rhs);
    }

    static {
        BigInteger p = new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853951");
        BigInteger n = new BigInteger("115792089210356248762697446949407573529996955224135760342422259061068512044369");
        BigInteger a = p.subtract(new BigInteger("3"));
        BigInteger b = new BigInteger("5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", 16);
        BigInteger gx = new BigInteger("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", 16);
        BigInteger gy = new BigInteger("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5", 16);
        int h = 1;
        ECPoint g = new ECPoint(gx, gy);
        FIELD = new ECFieldFp(p);
        CURVE = new EllipticCurve(FIELD, a, b);
        CURVE_SPEC = new ECParameterSpec(CURVE, g, n, h);
        random = new SecureRandom();
    }
}

