/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.ide.AndroidArtifactOutputImpl;
import com.android.build.gradle.internal.ide.BaseArtifactImpl;
import com.android.build.gradle.internal.ide.BuildOutputSupplier;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.ClassField;
import com.android.builder.model.CodeShrinker;
import com.android.builder.model.Dependencies;
import com.android.builder.model.InstantRun;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.TestOptions;
import com.android.builder.model.level2.DependencyGraphs;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.file.RegularFile;

final class AndroidArtifactImpl
extends BaseArtifactImpl
implements AndroidArtifact,
Serializable {
    private static final long serialVersionUID = 3L;
    private final boolean isSigned;
    private final String baseName;
    private final String applicationId;
    private final String sourceGenTaskName;
    private final List<File> generatedResourceFolders;
    private final List<File> additionalRuntimeApks;
    private final Map<String, ClassField> buildConfigFields;
    private final Map<String, ClassField> resValues;
    private final InstantRun instantRun;
    private final BuildOutputSupplier<Collection<EarlySyncBuildOutput>> splitOutputsSupplier;
    private final BuildOutputSupplier<Collection<EarlySyncBuildOutput>> manifestSupplier;
    private final Collection<AndroidArtifactOutput> buildOutputs;
    private final String signingConfigName;
    private final Set<String> abiFilters;
    private final TestOptions testOptions;
    private final String instrumentedTestTaskName;
    private final String bundleTaskName;
    private final String bundleTaskOutputListingFile;
    private final String apkFromBundleTaskName;
    private final String apkFromBundleTaskOutputListingFile;
    private final CodeShrinker codeShrinker;

    AndroidArtifactImpl(String name2, String baseName2, String assembleTaskName, RegularFile postAssembleTaskModelFile, boolean isSigned, String signingConfigName, String applicationId, String sourceGenTaskName, String compileTaskName, List<File> generatedSourceFolders, List<File> generatedResourceFolders, File classesFolder, Set<File> additionalClassFolders, File javaResourcesFolder, Dependencies compileDependencies2, DependencyGraphs dependencyGraphs, List<File> additionalRuntimeApks, SourceProvider variantSourceProvider, SourceProvider multiFlavorSourceProviders, Set<String> abiFilters, Map<String, ClassField> buildConfigFields, Map<String, ClassField> resValues, InstantRun instantRun, BuildOutputSupplier<Collection<EarlySyncBuildOutput>> splitOutputsSupplier, BuildOutputSupplier<Collection<EarlySyncBuildOutput>> manifestSupplier, TestOptions testOptions, String instrumentedTestTaskName, String bundleTaskName, RegularFile bundleTaskOutputListingFile, String apkFromBundleTaskName, RegularFile apkFromBundleTaskOutputListingFile, CodeShrinker codeShrinker) {
        super(name2, assembleTaskName, postAssembleTaskModelFile, compileTaskName, classesFolder, additionalClassFolders, javaResourcesFolder, compileDependencies2, dependencyGraphs, variantSourceProvider, multiFlavorSourceProviders, generatedSourceFolders);
        this.baseName = baseName2;
        this.isSigned = isSigned;
        this.signingConfigName = signingConfigName;
        this.applicationId = applicationId;
        this.sourceGenTaskName = sourceGenTaskName;
        this.generatedResourceFolders = generatedResourceFolders;
        this.additionalRuntimeApks = additionalRuntimeApks;
        this.abiFilters = abiFilters;
        this.buildConfigFields = buildConfigFields;
        this.resValues = resValues;
        this.instantRun = instantRun;
        this.splitOutputsSupplier = splitOutputsSupplier;
        this.manifestSupplier = manifestSupplier;
        this.testOptions = testOptions;
        this.instrumentedTestTaskName = instrumentedTestTaskName;
        this.bundleTaskName = bundleTaskName;
        this.bundleTaskOutputListingFile = bundleTaskOutputListingFile != null ? bundleTaskOutputListingFile.getAsFile().getAbsolutePath() : null;
        this.apkFromBundleTaskName = apkFromBundleTaskName;
        this.apkFromBundleTaskOutputListingFile = apkFromBundleTaskOutputListingFile != null ? apkFromBundleTaskOutputListingFile.getAsFile().getAbsolutePath() : null;
        this.codeShrinker = codeShrinker;
        this.buildOutputs = this.computeBuildOutputs();
    }

    private EarlySyncBuildOutput getOutputFor(Collection<EarlySyncBuildOutput> outputs, VariantOutput.OutputType outputType, Collection<FilterData> filtersData) {
        for (EarlySyncBuildOutput output2 : outputs) {
            if (output2.getApkType() != outputType || !output2.getFiltersData().equals(filtersData)) continue;
            return output2;
        }
        return null;
    }

    public Collection<AndroidArtifactOutput> getOutputs() {
        return this.buildOutputs;
    }

    private Collection<AndroidArtifactOutput> computeBuildOutputs() {
        Collection manifests = (Collection)this.manifestSupplier.get();
        Collection outputs = (Collection)this.splitOutputsSupplier.get();
        if (outputs.isEmpty()) {
            return manifests.isEmpty() ? this.guessOutputsBasedOnNothing() : this.guessOutputsBaseOnManifests();
        }
        return outputs.stream().map(splitOutput -> new AndroidArtifactOutputImpl((EarlySyncBuildOutput)splitOutput, this.getOutputFor(manifests, splitOutput.getApkType(), splitOutput.getFiltersData()))).collect(Collectors.toList());
    }

    private Collection<AndroidArtifactOutput> guessOutputsBasedOnNothing() {
        ApkData mainApkInfo = ApkData.of(VariantOutput.OutputType.MAIN, (Collection<FilterData>)ImmutableList.of(), -1);
        return ImmutableList.of((Object)new AndroidArtifactOutputImpl(new EarlySyncBuildOutput(InternalArtifactType.APK.INSTANCE, mainApkInfo.getType(), mainApkInfo.getFilters(), -1, this.splitOutputsSupplier.guessOutputFile(this.baseName + ".apk")), new EarlySyncBuildOutput(InternalArtifactType.APK.INSTANCE, mainApkInfo.getType(), mainApkInfo.getFilters(), -1, this.manifestSupplier.guessOutputFile("AndroidManifest.xml"))));
    }

    private Collection<AndroidArtifactOutput> guessOutputsBaseOnManifests() {
        return ((Collection)this.manifestSupplier.get()).stream().map(manifestOutput -> new AndroidArtifactOutputImpl(new EarlySyncBuildOutput(InternalArtifactType.APK.INSTANCE, manifestOutput.getApkType(), manifestOutput.getFiltersData(), manifestOutput.getVersionCode(), this.splitOutputsSupplier.guessOutputFile(this.baseName + Joiner.on((String)"-").join((Iterable)manifestOutput.getFilters().stream().map(FilterData::getIdentifier).collect(Collectors.toList())) + ".apk")), (EarlySyncBuildOutput)manifestOutput)).collect(Collectors.toList());
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getSigningConfigName() {
        return this.signingConfigName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getSourceGenTaskName() {
        return this.sourceGenTaskName;
    }

    public Set<String> getIdeSetupTaskNames() {
        return Sets.newHashSet((Object[])new String[]{this.getSourceGenTaskName()});
    }

    public List<File> getGeneratedResourceFolders() {
        return this.generatedResourceFolders;
    }

    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public Collection<NativeLibrary> getNativeLibraries() {
        return ImmutableList.of();
    }

    public Map<String, ClassField> getBuildConfigFields() {
        return this.buildConfigFields;
    }

    public Map<String, ClassField> getResValues() {
        return this.resValues;
    }

    public InstantRun getInstantRun() {
        return this.instantRun;
    }

    public List<File> getAdditionalRuntimeApks() {
        return this.additionalRuntimeApks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidArtifactImpl that = (AndroidArtifactImpl)o;
        return this.isSigned == that.isSigned && Objects.equals(this.signingConfigName, that.signingConfigName) && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.sourceGenTaskName, that.sourceGenTaskName) && Objects.equals(this.generatedResourceFolders, that.generatedResourceFolders) && Objects.equals(this.abiFilters, that.abiFilters) && Objects.equals(this.buildConfigFields, that.buildConfigFields) && Objects.equals(this.resValues, that.resValues) && Objects.equals(this.manifestSupplier, that.manifestSupplier) && Objects.equals(this.splitOutputsSupplier, that.splitOutputsSupplier) && Objects.equals(this.instantRun, that.instantRun) && Objects.equals(this.additionalRuntimeApks, that.additionalRuntimeApks) && Objects.equals(this.baseName, that.baseName) && Objects.equals(this.testOptions, that.testOptions) && Objects.equals(this.instrumentedTestTaskName, that.instrumentedTestTaskName) && Objects.equals(this.bundleTaskName, that.bundleTaskName) && Objects.equals(this.bundleTaskOutputListingFile, that.bundleTaskOutputListingFile) && Objects.equals(this.apkFromBundleTaskOutputListingFile, that.apkFromBundleTaskOutputListingFile) && Objects.equals(this.codeShrinker, that.codeShrinker) && Objects.equals(this.apkFromBundleTaskName, that.apkFromBundleTaskName) && Objects.equals(this.buildOutputs, that.buildOutputs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.splitOutputsSupplier, this.manifestSupplier, this.isSigned, this.signingConfigName, this.applicationId, this.sourceGenTaskName, this.generatedResourceFolders, this.abiFilters, this.buildConfigFields, this.resValues, this.instantRun, this.additionalRuntimeApks, this.baseName, this.testOptions, this.instrumentedTestTaskName, this.bundleTaskName, this.bundleTaskOutputListingFile, this.codeShrinker, this.apkFromBundleTaskName, this.apkFromBundleTaskOutputListingFile, this.buildOutputs);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("manifestProxy", this.manifestSupplier).add("splitOutputsSupplier", this.splitOutputsSupplier).add("isSigned", this.isSigned).add("signingConfigName", (Object)this.signingConfigName).add("applicationId", (Object)this.applicationId).add("sourceGenTaskName", (Object)this.sourceGenTaskName).add("generatedResourceFolders", this.generatedResourceFolders).add("abiFilters", this.abiFilters).add("buildConfigFields", this.buildConfigFields).add("resValues", this.resValues).add("instantRun", (Object)this.instantRun).add("testOptions", (Object)this.testOptions).add("instrumentedTestTaskName", (Object)this.instrumentedTestTaskName).add("bundleTaskName", (Object)this.bundleTaskName).add("bundleTasOutputListingFile", (Object)this.bundleTaskName).add("codeShrinker", (Object)this.codeShrinker).add("apkFromBundleTaskOutputListingFile", (Object)this.apkFromBundleTaskOutputListingFile).add("apkFromBundleTaskName", (Object)this.apkFromBundleTaskName).add("buildOutputs", this.buildOutputs).toString();
    }

    public TestOptions getTestOptions() {
        return this.testOptions;
    }

    public String getInstrumentedTestTaskName() {
        return this.instrumentedTestTaskName;
    }

    public String getBundleTaskName() {
        return this.bundleTaskName;
    }

    public String getBundleTaskOutputListingFile() {
        return this.bundleTaskOutputListingFile;
    }

    public String getApkFromBundleTaskName() {
        return this.apkFromBundleTaskName;
    }

    public String getApkFromBundleTaskOutputListingFile() {
        return this.apkFromBundleTaskOutputListingFile;
    }

    public CodeShrinker getCodeShrinker() {
        return this.codeShrinker;
    }
}

