/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class CheckProguardFiles
extends NonIncrementalTask {
    private List<File> proguardFiles;

    @Override
    protected void doTaskAction() {
        HashMap<File, ProguardFiles.ProguardFile> oldFiles = new HashMap<File, ProguardFiles.ProguardFile>();
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.OPTIMIZE.fileName, this.getProject().getLayout()).getAbsoluteFile(), ProguardFiles.ProguardFile.OPTIMIZE);
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.DONT_OPTIMIZE.fileName, this.getProject().getLayout()).getAbsoluteFile(), ProguardFiles.ProguardFile.DONT_OPTIMIZE);
        for (File file : this.proguardFiles) {
            if (!oldFiles.containsKey(file.getAbsoluteFile())) continue;
            String name2 = ((ProguardFiles.ProguardFile)((Object)oldFiles.get((Object)file.getAbsoluteFile()))).fileName;
            throw new InvalidUserDataException(name2 + " should not be used together with the new postprocessing DSL. The new DSL includes sensible settings by default, you can override this using `postprocessing { proguardFiles = []}`");
        }
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public List<File> getProguardFiles() {
        return this.proguardFiles;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CheckProguardFiles> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("check", "ProguardFiles");
        }

        @Override
        public Class<CheckProguardFiles> getType() {
            return CheckProguardFiles.class;
        }

        @Override
        public void configure(CheckProguardFiles task) {
            super.configure(task);
            task.proguardFiles = this.getVariantScope().getProguardFiles();
        }
    }
}

