/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public class ExtractProguardFiles
extends DefaultTask {
    private final ImmutableList<File> generatedFiles;
    private final ProjectLayout projectLayout;

    @Inject
    public ExtractProguardFiles(ProjectLayout projectLayout) {
        this.projectLayout = projectLayout;
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (String name2 : ProguardFiles.KNOWN_FILE_NAMES) {
            outputs.add((Object)ProguardFiles.getDefaultProguardFile(name2, projectLayout));
        }
        this.generatedFiles = outputs.build();
    }

    @OutputFiles
    public List<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    @TaskAction
    public void run() throws IOException {
        for (String name2 : ProguardFiles.KNOWN_FILE_NAMES) {
            File defaultProguardFile = ProguardFiles.getDefaultProguardFile(name2, this.projectLayout);
            if (defaultProguardFile.isFile()) continue;
            ProguardFiles.createProguardFile(name2, defaultProguardFile);
        }
    }
}

