/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.component.impl.UnitTestPropertiesImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.errors.IssueReporter;
import org.gradle.api.Project;

public abstract class BaseVariantFactory
implements VariantFactory {
    protected final GlobalScope globalScope;

    public BaseVariantFactory(GlobalScope globalScope) {
        this.globalScope = globalScope;
    }

    @Override
    public UnitTestImpl createUnitTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo) {
        return (UnitTestImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(UnitTestImpl.class, new Object[]{variantDslInfo, componentIdentity});
    }

    @Override
    public AndroidTestImpl createAndroidTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo) {
        return (AndroidTestImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(AndroidTestImpl.class, new Object[]{variantDslInfo, componentIdentity});
    }

    @Override
    public UnitTestPropertiesImpl createUnitTestProperties(ComponentIdentity componentIdentity, VariantScope variantScope) {
        return (UnitTestPropertiesImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(UnitTestPropertiesImpl.class, new Object[]{this.globalScope.getDslScope(), variantScope, variantScope.getArtifacts().getOperations(), componentIdentity});
    }

    @Override
    public AndroidTestPropertiesImpl createAndroidTestProperties(ComponentIdentity componentIdentity, VariantScope variantScope) {
        return (AndroidTestPropertiesImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(AndroidTestPropertiesImpl.class, new Object[]{this.globalScope.getDslScope(), variantScope, variantScope.getArtifacts().getOperations(), componentIdentity});
    }

    @Override
    public void preVariantWork(Project project2) {
        if (project2.getPluginManager().hasPlugin("com.neenbedankt.android-apt")) {
            this.globalScope.getDslScope().getIssueReporter().reportError(IssueReporter.Type.INCOMPATIBLE_PLUGIN, "android-apt plugin is incompatible with the Android Gradle plugin.  Please use 'annotationProcessor' configuration instead.", "android-apt");
        }
    }

    @Override
    public void validateModel(VariantInputModel model2) {
        this.validateBuildConfig(model2);
        this.validateResValues(model2);
    }

    void validateBuildConfig(VariantInputModel model2) {
        if (!this.globalScope.getBuildFeatures().getBuildConfig()) {
            IssueReporter issueReporter = this.globalScope.getDslScope().getIssueReporter();
            if (!model2.getDefaultConfig().getProductFlavor().getBuildConfigFields().isEmpty()) {
                issueReporter.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom BuildConfig fields, but the feature is disabled.");
            }
            for (BuildTypeData buildTypeData : model2.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getBuildConfigFields().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom BuildConfig fields, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
                if (productFlavorData.getProductFlavor().getBuildConfigFields().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom BuildConfig fields, but the feature is disabled.", productFlavorData.getProductFlavor().getName()));
            }
        }
    }

    void validateResValues(VariantInputModel model2) {
        if (!this.globalScope.getBuildFeatures().getResValues()) {
            IssueReporter issueReporter = this.globalScope.getDslScope().getIssueReporter();
            if (!model2.getDefaultConfig().getProductFlavor().getResValues().isEmpty()) {
                issueReporter.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom resource values, but the feature is disabled.");
            }
            for (BuildTypeData buildTypeData : model2.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getResValues().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom resource values, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
                if (productFlavorData.getProductFlavor().getResValues().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom resource values, but the feature is disabled.", productFlavorData.getProductFlavor().getName()));
            }
        }
    }
}

