/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.JavaCompileUtils;
import com.android.build.gradle.tasks.SerializableArtifact;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class JavaPreCompileTask
extends NonIncrementalTask {
    private RegularFileProperty processorListFile;
    private ArtifactCollection annotationProcessorConfiguration;
    private AnnotationProcessorOptions annotationProcessorOptions;

    @Inject
    public JavaPreCompileTask(ObjectFactory objectFactory) {
        this.processorListFile = objectFactory.fileProperty();
    }

    @VisibleForTesting
    void init(ArtifactCollection annotationProcessorConfiguration, AnnotationProcessorOptions annotationProcessorOptions) {
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.annotationProcessorOptions = annotationProcessorOptions;
    }

    @OutputFile
    public RegularFileProperty getProcessorListFile() {
        return this.processorListFile;
    }

    @Classpath
    public FileCollection getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration.getArtifactFiles();
    }

    @Override
    protected void doTaskAction() {
        try (WorkerExecutorFacade workerExecutor = this.getWorkerFacadeWithWorkers();){
            workerExecutor.submit(PreCompileRunnable.class, (Serializable)new PreCompileParams(((RegularFile)this.processorListFile.get()).getAsFile(), JavaPreCompileTask.toSerializable(this.annotationProcessorConfiguration), this.annotationProcessorOptions.getClassNames()));
        }
    }

    private static Collection<SerializableArtifact> toSerializable(ArtifactCollection artifactCollection) {
        return (Collection)artifactCollection.getArtifacts().stream().map(SerializableArtifact::new).collect(ImmutableList.toImmutableList());
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JavaPreCompileTask> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("javaPreCompile");
        }

        @Override
        public Class<JavaPreCompileTask> getType() {
            return JavaPreCompileTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends JavaPreCompileTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.ANNOTATION_PROCESSOR_LIST.INSTANCE, taskProvider, JavaPreCompileTask::getProcessorListFile, "annotationProcessors.json");
        }

        @Override
        public void configure(JavaPreCompileTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.init(scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROCESSED_JAR), scope.getVariantDslInfo().getJavaCompileOptions().getAnnotationProcessorOptions());
        }
    }

    public static class PreCompileRunnable
    implements Runnable {
        private final PreCompileParams params;

        @Inject
        public PreCompileRunnable(PreCompileParams params) {
            this.params = params;
        }

        @Override
        public void run() {
            Map<String, Boolean> annotationProcessors = JavaCompileUtils.detectAnnotationProcessors(this.params.apOptionClassNames, this.params.annotationProcessorConfiguration);
            JavaCompileUtils.writeAnnotationProcessorsToJsonFile(annotationProcessors, this.params.processorListFile);
        }
    }

    static class PreCompileParams
    implements Serializable {
        private final File processorListFile;
        private final Collection<SerializableArtifact> annotationProcessorConfiguration;
        private final List<String> apOptionClassNames;

        public PreCompileParams(File processorListFile, Collection<SerializableArtifact> annotationProcessorConfiguration, List<String> apOptionClassNames) {
            this.processorListFile = processorListFile;
            this.annotationProcessorConfiguration = annotationProcessorConfiguration;
            this.apOptionClassNames = apOptionClassNames;
        }
    }
}

