/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.VariantOutput;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.model.ObjectFactory;

public class VariantOutputFactory {
    private final Class<? extends BaseVariantOutput> targetClass;
    private final ObjectFactory objectFactory;
    private final BaseVariantImpl deprecatedVariantPublicApi;
    private final TaskContainer taskContainer;
    private final BaseExtension extension;
    private final DeprecationReporter deprecationReporter;

    public VariantOutputFactory(Class<? extends BaseVariantOutput> targetClass, ObjectFactory objectFactory, BaseExtension extension, BaseVariantImpl deprecatedVariantPublicApi, TaskContainer taskContainer, DeprecationReporter deprecationReporter) {
        this.targetClass = targetClass;
        this.objectFactory = objectFactory;
        this.deprecatedVariantPublicApi = deprecatedVariantPublicApi;
        this.taskContainer = taskContainer;
        this.extension = extension;
        this.deprecationReporter = deprecationReporter;
    }

    public VariantOutput create(VariantOutputImpl variantApi) {
        BaseVariantOutput variantOutput = (BaseVariantOutput)this.objectFactory.newInstance(this.targetClass, new Object[]{this.taskContainer, this.deprecationReporter, variantApi});
        this.extension.getBuildOutputs().add((Object)variantOutput);
        if (this.deprecatedVariantPublicApi != null) {
            this.deprecatedVariantPublicApi.addOutputs((List<BaseVariantOutput>)ImmutableList.of((Object)variantOutput));
        }
        return variantOutput;
    }
}

