/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.utils.ILogger;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"processResources", "", "aapt", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "aaptConfig", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "rJar", "Ljava/io/File;", "logger", "Lcom/android/utils/ILogger;", "gradle"})
public final class Aapt2ProcessResourcesRunnableKt {
    public static final void processResources(@NotNull Aapt2 aapt, @NotNull AaptPackageConfig aaptConfig, @Nullable File rJar, @NotNull ILogger logger) throws IOException, ProcessException {
        Intrinsics.checkParameterIsNotNull((Object)aapt, (String)"aapt");
        Intrinsics.checkParameterIsNotNull((Object)aaptConfig, (String)"aaptConfig");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        try {
            aapt.link(aaptConfig, logger);
        }
        catch (Aapt2Exception e) {
            throw (Throwable)e;
        }
        catch (Aapt2InternalException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new ProcessException("Failed to execute aapt", (Throwable)e);
        }
        File sourceOut = aaptConfig.getSourceOutputDir();
        if (sourceOut != null || rJar != null) {
            SymbolTable symbolTable;
            File mainRTxt;
            String mainPackageName = aaptConfig.getCustomPackageForR();
            if (mainPackageName == null) {
                mainPackageName = SymbolUtils.getPackageNameFromManifest((File)aaptConfig.getManifestFile());
            }
            if ((mainRTxt = new File(aaptConfig.getSymbolOutputDir(), "R.txt")).isFile()) {
                symbolTable = SymbolIo.readFromAapt((File)mainRTxt, (String)mainPackageName);
            } else {
                SymbolTable.Builder builder = SymbolTable.Companion.builder();
                String string = mainPackageName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                symbolTable = builder.tablePackage(string).build();
            }
            SymbolTable mainSymbols = symbolTable;
            Set depSymbolTables = (Set)SymbolUtils.loadDependenciesSymbolTables((Iterable)((Iterable)aaptConfig.getLibrarySymbolTableFiles()));
            boolean finalIds = aaptConfig.getUseFinalIds();
            if (rJar != null) {
                depSymbolTables = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)depSymbolTables), (Function1)((Function1)new Function1<SymbolTable, SymbolTable>(mainSymbols){
                    final /* synthetic */ SymbolTable $mainSymbols;

                    @NotNull
                    public final SymbolTable invoke(@NotNull SymbolTable t) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        SymbolTable symbolTable = this.$mainSymbols;
                        Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable, (String)"mainSymbols");
                        return t.withValuesFrom(symbolTable);
                    }
                    {
                        this.$mainSymbols = symbolTable;
                        super(1);
                    }
                })));
                Iterable iterable = Iterables.concat((Iterable)SetsKt.setOf((Object)mainSymbols), (Iterable)depSymbolTables);
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"Iterables.concat(setOf(m\u2026ymbols), depSymbolTables)");
                Path path = rJar.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"rJar.toPath()");
                BytecodeRClassWriterKt.exportToCompiledJava((Iterable)iterable, (Path)path, (boolean)finalIds);
            } else {
                Collection collection = depSymbolTables;
                File file = sourceOut;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                RGeneration.generateRForLibraries((SymbolTable)mainSymbols, (Collection)collection, (File)file, (boolean)finalIds);
            }
        }
    }
}

