/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.google.common.annotations.VisibleForTesting;
import org.gradle.api.JavaVersion;
import org.gradle.api.logging.Logging;

public class AbstractCompilesUtil {
    public static final String ANDROID_APT_PLUGIN_NAME = "com.neenbedankt.android-apt";

    @VisibleForTesting
    public static JavaVersion getDefaultJavaVersion(String compileSdkVersion) {
        Integer compileSdkLevel;
        String currentJdkVersion = System.getProperty("java.specification.version");
        AndroidVersion hash = AndroidTargetHash.getVersionFromHash((String)compileSdkVersion);
        Integer n = compileSdkLevel = hash == null ? null : Integer.valueOf(hash.getFeatureLevel());
        JavaVersion javaVersionToUse = compileSdkLevel == null ? JavaVersion.VERSION_1_6 : (0 < compileSdkLevel && compileSdkLevel <= 20 ? JavaVersion.VERSION_1_6 : (21 <= compileSdkLevel && compileSdkLevel < 24 ? JavaVersion.VERSION_1_7 : JavaVersion.VERSION_1_7));
        JavaVersion jdkVersion = JavaVersion.toVersion((Object)currentJdkVersion);
        if (jdkVersion.compareTo((Enum)javaVersionToUse) < 0) {
            Logging.getLogger(AbstractCompilesUtil.class).warn("Default language level for compileSdkVersion '{}' is {}, but the JDK used is {}, so the JDK language level will be used.", new Object[]{compileSdkVersion, javaVersionToUse, jdkVersion});
            javaVersionToUse = jdkVersion;
        }
        return javaVersionToUse;
    }
}

