/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.Version;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.IsolationMode;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public abstract class JacocoReportTask
extends NonIncrementalTask {
    private FileCollection jacocoClasspath;
    private FileCollection classFileCollection;
    private FileCollection sourceFolders;
    private File reportDir;
    private String reportName;
    private int tabWidth = 4;

    @Deprecated
    public void setCoverageFile(File coverageFile) {
        this.getLogger().info("JacocoReportTask.setCoverageDir is deprecated and has no effect.");
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract DirectoryProperty getCoverageDirectories();

    @OutputDirectory
    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    @Classpath
    public FileCollection getClassFileCollection() {
        return this.classFileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSourceFolders() {
        return this.sourceFolders;
    }

    @Input
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @Classpath
    public FileCollection getJacocoClasspath() {
        return this.jacocoClasspath;
    }

    public void setJacocoClasspath(FileCollection jacocoClasspath) {
        this.jacocoClasspath = jacocoClasspath;
    }

    @Input
    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @Override
    protected void doTaskAction() throws IOException {
        Set coverageFiles = ((Directory)this.getCoverageDirectories().get()).getAsFileTree().getFiles().stream().filter(File::isFile).collect(Collectors.toSet());
        if (coverageFiles.isEmpty()) {
            throw new IOException(String.format("No coverage data to process in directories [%1$s]", ((Directory)this.getCoverageDirectories().get()).getAsFile().getAbsolutePath()));
        }
        this.getWorkerExecutor().submit(JacocoReportWorkerAction.class, workerConfiguration -> {
            workerConfiguration.setIsolationMode(IsolationMode.CLASSLOADER);
            workerConfiguration.classpath((Iterable)this.jacocoClasspath.getFiles());
            workerConfiguration.setParams(new Object[]{coverageFiles, this.getReportDir(), this.getClassFileCollection().getFiles(), this.getSourceFolders().getFiles(), this.getTabWidth(), this.getReportName()});
        });
    }

    static class JacocoReportWorkerAction
    implements Runnable {
        private static Logger logger = Logging.getLogger(JacocoReportWorkerAction.class);
        private Collection<File> coverageFiles;
        private File reportDir;
        private Collection<File> classFolders;
        private Collection<File> sourceFolders;
        private int tabWidth;
        String reportName;

        @Inject
        public JacocoReportWorkerAction(Collection<File> coverageFiles, File reportDir, Collection<File> classFolders, Collection<File> sourceFolders, int tabWidth, String reportName) {
            this.coverageFiles = coverageFiles;
            this.reportDir = reportDir;
            this.classFolders = classFolders;
            this.sourceFolders = sourceFolders;
            this.tabWidth = tabWidth;
            this.reportName = reportName;
        }

        @Override
        public void run() {
            try {
                JacocoReportWorkerAction.generateReport(this.coverageFiles, this.reportDir, this.classFolders, this.sourceFolders, this.tabWidth, this.reportName);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to generate Jacoco report", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        static void generateReport(Collection<File> coverageFiles, File reportDir, Collection<File> classFolders, Collection<File> sourceFolders, int tabWidth, String reportName) throws IOException {
            ExecFileLoader loader = new ExecFileLoader();
            for (File coverageFile : coverageFiles) {
                loader.load(coverageFile);
            }
            SessionInfoStore sessionInfoStore = loader.getSessionInfoStore();
            ExecutionDataStore executionDataStore = loader.getExecutionDataStore();
            HTMLFormatter htmlFormatter = new HTMLFormatter();
            htmlFormatter.setOutputEncoding("UTF-8");
            htmlFormatter.setLocale(Locale.US);
            htmlFormatter.setFooterText("Generated by the Android Gradle plugin " + Version.ANDROID_GRADLE_PLUGIN_VERSION);
            FileMultiReportOutput output2 = new FileMultiReportOutput(reportDir);
            IReportVisitor htmlReport = htmlFormatter.createVisitor((IMultiReportOutput)output2);
            XMLFormatter xmlFormatter = new XMLFormatter();
            xmlFormatter.setOutputEncoding("UTF-8");
            OutputStream xmlReportOutput = output2.createFile("report.xml");
            try {
                IReportVisitor xmlReport = xmlFormatter.createVisitor(xmlReportOutput);
                MultiReportVisitor visitor = new MultiReportVisitor((List)ImmutableList.of((Object)htmlReport, (Object)xmlReport));
                visitor.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
                CoverageBuilder builder = new CoverageBuilder();
                Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
                JacocoReportWorkerAction.analyzeAll(analyzer, classFolders);
                MultiSourceFileLocator locator = new MultiSourceFileLocator(0);
                for (File folder : sourceFolders) {
                    locator.add((ISourceFileLocator)new DirectorySourceFileLocator(folder, "UTF-8", tabWidth));
                }
                IBundleCoverage bundle = builder.getBundle(reportName);
                visitor.visitBundle(bundle, (ISourceFileLocator)locator);
                visitor.visitEnd();
            }
            finally {
                try {
                    xmlReportOutput.close();
                }
                catch (IOException e) {
                    logger.error("Could not close xml report file", (Throwable)e);
                }
            }
        }

        private static void analyzeAll(Analyzer analyzer, Collection<File> classFolders) throws IOException {
            for (File folder : classFolders) {
                JacocoReportWorkerAction.analyze(analyzer, folder, classFolders);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void analyze(Analyzer analyzer, File file, Collection<File> originalClassFolders) throws IOException {
            block6: {
                block5: {
                    if (!file.isDirectory()) break block5;
                    File[] files = file.listFiles();
                    if (files == null) break block6;
                    for (File f : files) {
                        if (originalClassFolders.contains(f)) continue;
                        JacocoReportWorkerAction.analyze(analyzer, f, originalClassFolders);
                    }
                    break block6;
                }
                String name2 = file.getName();
                if (!name2.endsWith(".class") || name2.equals("R.class") || name2.startsWith("R$") || name2.equals("Manifest.class") || name2.startsWith("Manifest$") || name2.equals("BuildConfig.class")) {
                    return;
                }
                FileInputStream in = new FileInputStream(file);
                try {
                    analyzer.analyzeClass((InputStream)in, file.getAbsolutePath());
                }
                finally {
                    Closeables.closeQuietly((InputStream)in);
                }
            }
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JacocoReportTask> {
        private final Configuration jacocoAntConfiguration;

        public CreationAction(VariantScope scope, Configuration jacocoAntConfiguration) {
            super(scope);
            this.jacocoAntConfiguration = jacocoAntConfiguration;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("create", "CoverageReport");
        }

        @Override
        public Class<JacocoReportTask> getType() {
            return JacocoReportTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends JacocoReportTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setCoverageReportTask(taskProvider);
        }

        @Override
        public void configure(JacocoReportTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
            task.setReportName(scope.getName());
            Preconditions.checkNotNull((Object)scope.getTestedVariantData());
            VariantScope testedScope = scope.getTestedVariantData().getScope();
            task.jacocoClasspath = (FileCollection)this.jacocoAntConfiguration;
            scope.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.CODE_COVERAGE.INSTANCE, task.getCoverageDirectories());
            task.classFileCollection = testedScope.getArtifacts().getAllClasses();
            task.sourceFolders = (FileCollection)scope.getGlobalScope().getProject().files(new Object[]{() -> testedScope.getVariantData().getJavaSources()});
            task.setReportDir(testedScope.getCoverageReportDir());
        }
    }
}

