/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.BuildFeatures;
import com.android.build.gradle.api.ViewBindingOptions;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/dsl/ViewBindingOptionsImpl;", "Lcom/android/build/gradle/api/ViewBindingOptions;", "features", "Lcom/android/build/api/dsl/BuildFeatures;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/api/dsl/BuildFeatures;Lcom/android/build/gradle/options/ProjectOptions;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "value", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "gradle"})
public class ViewBindingOptionsImpl
implements ViewBindingOptions {
    private final BuildFeatures features;
    private final ProjectOptions projectOptions;
    private final DslScope dslScope;

    @Override
    public boolean isEnabled() {
        this.dslScope.getDeprecationReporter().reportDeprecatedUsage("android.buildFeatures.viewBinding", "android.viewBinding.enabled", DeprecationReporter.DeprecationTarget.VERSION_5_0);
        Boolean bool = this.features.getViewBinding();
        if (bool != null) {
            return bool;
        }
        return this.projectOptions.get(BooleanOption.BUILD_FEATURE_VIEWBINDING);
    }

    @Override
    public void setEnabled(boolean value) {
        this.dslScope.getDeprecationReporter().reportDeprecatedUsage("android.buildFeatures.viewBinding", "android.viewBinding.enabled", DeprecationReporter.DeprecationTarget.VERSION_5_0);
        this.features.setViewBinding(Boolean.valueOf(value));
    }

    @Inject
    public ViewBindingOptionsImpl(@NotNull BuildFeatures features, @NotNull ProjectOptions projectOptions, @NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)features, (String)"features");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.features = features;
        this.projectOptions = projectOptions;
        this.dslScope = dslScope;
    }
}

