/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.BuiltArtifacts;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.testing.TestData;
import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;

public abstract class AbstractTestDataImpl
implements TestData {
    private final VariantDslInfo testVariantConfig;
    private final VariantSources testVariantSources;
    private Map<String, String> extraInstrumentationTestRunnerArgs;
    private boolean animationsDisabled;
    protected final Provider<Directory> testApkDir;
    protected final FileCollection testedApksDir;

    public AbstractTestDataImpl(VariantDslInfo testVariantDslInfo, VariantSources testVariantSources, Provider<Directory> testApkDir, FileCollection testedApksDir) {
        this.testVariantConfig = (VariantDslInfo)Preconditions.checkNotNull((Object)testVariantDslInfo);
        this.testVariantSources = testVariantSources;
        this.extraInstrumentationTestRunnerArgs = Maps.newHashMap();
        this.testApkDir = testApkDir;
        this.testedApksDir = testedApksDir;
    }

    @Override
    public String getInstrumentationRunner() {
        return this.testVariantConfig.getInstrumentationRunner();
    }

    @Override
    public Map<String, String> getInstrumentationRunnerArguments() {
        return ImmutableMap.builder().putAll(this.testVariantConfig.getInstrumentationRunnerArguments()).putAll(this.extraInstrumentationTestRunnerArgs).build();
    }

    public void setExtraInstrumentationTestRunnerArgs(Map<String, String> extraInstrumentationTestRunnerArgs) {
        this.extraInstrumentationTestRunnerArgs = ImmutableMap.copyOf(extraInstrumentationTestRunnerArgs);
    }

    @Override
    public boolean getAnimationsDisabled() {
        return this.animationsDisabled;
    }

    public void setAnimationsDisabled(boolean animationsDisabled) {
        this.animationsDisabled = animationsDisabled;
    }

    @Override
    public boolean isTestCoverageEnabled() {
        return this.testVariantConfig.isTestCoverageEnabled();
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        return this.testVariantConfig.getMinSdkVersion();
    }

    @Override
    public String getFlavorName() {
        return this.testVariantConfig.getComponentIdentity().getFlavorName().toUpperCase(Locale.getDefault());
    }

    public Provider<Directory> getTestApkDir() {
        return this.testApkDir;
    }

    public FileCollection getTestedApksDir() {
        return this.testedApksDir;
    }

    public FileCollection getTestedApksFromBundle() {
        return null;
    }

    @Override
    public final List<File> getTestDirectories() {
        ImmutableList.Builder javaDirectories = ImmutableList.builder();
        for (SourceProvider sourceProvider : this.testVariantSources.getSortedSourceProviders()) {
            javaDirectories.addAll((Iterable)sourceProvider.getJavaDirectories());
        }
        return javaDirectories.build();
    }

    @Override
    public File getTestApk() {
        BuiltArtifacts testApkOutputs = new BuiltArtifactsLoaderImpl().load((Directory)this.testApkDir.get());
        if (testApkOutputs == null) {
            throw new RuntimeException("No test APK in provided directory, file a bug");
        }
        if (testApkOutputs.getElements().size() != 1) {
            throw new RuntimeException("Unexpected number of main APKs, expected 1, got  " + testApkOutputs.getElements().size() + ":" + Joiner.on((String)",").join((Iterable)testApkOutputs.getElements()));
        }
        return ((BuiltArtifact)testApkOutputs.getElements().iterator().next()).getOutputFile().toFile();
    }
}

