/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.BuiltArtifacts;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;

public class TestApplicationTestData
extends AbstractTestDataImpl {
    private final Supplier<String> testApplicationId;
    private final Map<String, String> testedProperties = new HashMap<String, String>();

    public TestApplicationTestData(VariantDslInfo variantDslInfo, VariantSources variantSources, Supplier<String> testApplicationId, Provider<Directory> testApkDir, FileCollection testedApksDir) {
        super(variantDslInfo, variantSources, testApkDir, testedApksDir);
        this.testApplicationId = testApplicationId;
    }

    @Override
    public void loadFromMetadataFile(File metadataFile) {
        BuildElements testedManifests = ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.MERGED_MANIFESTS.INSTANCE, metadataFile.getParentFile());
        Optional<BuildOutput> splitOutput = testedManifests.stream().findFirst();
        if (!splitOutput.isPresent()) {
            throw new RuntimeException("No merged manifest metadata at " + metadataFile.getAbsolutePath());
        }
        this.testedProperties.putAll(splitOutput.get().getProperties());
    }

    @Override
    public String getApplicationId() {
        return this.testApplicationId.get();
    }

    @Override
    public String getTestedApplicationId() {
        return this.testedProperties.get("packageId");
    }

    @Override
    public boolean isLibrary() {
        return false;
    }

    @Override
    public List<File> getTestedApks(DeviceConfigProvider deviceConfigProvider, ILogger logger) {
        if (this.testedApksDir == null) {
            return ImmutableList.of();
        }
        BuiltArtifacts builtArtifacts = new BuiltArtifactsLoaderImpl().load(this.testedApksDir);
        return builtArtifacts != null ? builtArtifacts.getElements().stream().map(BuiltArtifact::getOutputFile).map(Path::toFile).collect(Collectors.toList()) : ImmutableList.of();
    }
}

