/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.variant.DimensionCombination;
import com.android.build.gradle.internal.variant.DimensionCombinationImpl;
import com.android.build.gradle.internal.variant.DimensionCombinator;
import com.android.build.gradle.internal.variant.DimensionCombinatorKt;
import com.android.build.gradle.internal.variant.FlavorCombinationBuilder;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.core.VariantType;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\tJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/variant/DimensionCombinator;", "", "variantInputModel", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "errorReporter", "Lcom/android/builder/errors/IssueReporter;", "variantType", "Lcom/android/builder/core/VariantType;", "flavorDimensionList", "", "", "(Lcom/android/build/gradle/internal/variant/VariantInputModel;Lcom/android/builder/errors/IssueReporter;Lcom/android/builder/core/VariantType;Ljava/util/List;)V", "combineFlavorsAndBuildTypes", "Lcom/android/build/gradle/internal/variant/DimensionCombination;", "flavorCombos", "Lcom/android/build/gradle/internal/variant/FlavorCombinationBuilder;", "computeFlavorlessVariants", "computeVariants", "computeVariantsWithFlavors", "validateFlavorDimensions", "Companion", "gradle"})
public final class DimensionCombinator {
    private final VariantInputModel variantInputModel;
    private final IssueReporter errorReporter;
    private final VariantType variantType;
    private final List<String> flavorDimensionList;
    @NotNull
    public static final String FAKE_DIMENSION = "agp-missing-dimension-for-sync-only";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<DimensionCombination> computeVariants() {
        if (this.variantInputModel.getProductFlavors().isEmpty()) {
            return this.computeFlavorlessVariants();
        }
        return this.computeVariantsWithFlavors();
    }

    private final List<DimensionCombination> computeFlavorlessVariants() {
        List list;
        if (this.variantInputModel.getBuildTypes().isEmpty()) {
            ImmutableList immutableList = ImmutableList.of((Object)new DimensionCombinationImpl(null, null, 3, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(DimensionCombinationImpl())");
            list = (List)immutableList;
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String buildType : this.variantInputModel.getBuildTypes().keySet()) {
                builder.add((Object)new DimensionCombinationImpl(buildType, null, 2, null));
            }
            ImmutableList immutableList = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
            list = (List)immutableList;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DimensionCombination> computeVariantsWithFlavors() {
        ImmutableList.Builder builder;
        void $this$groupByTo$iv$iv;
        List<String> flavorDimensionList = this.validateFlavorDimensions();
        Sequence $this$groupBy$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.variantInputModel.getProductFlavors().values()), (Function1)computeVariantsWithFlavors.flavorMap.1.INSTANCE);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            String key$iv$iv;
            ProductFlavor it2 = (ProductFlavor)element$iv$iv;
            boolean $i$a$-groupBy-DimensionCombinator$computeVariantsWithFlavors$flavorMap$42 = false;
            ProductFlavor productFlavor = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"it");
            if (productFlavor.getDimension() == null) {
                Intrinsics.throwNpe();
            }
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            ProductFlavor $i$a$-groupBy-DimensionCombinator$computeVariantsWithFlavors$flavorMap$42 = (ProductFlavor)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = v2.getName();
            list.add(string);
        }
        Map flavorMap2 = destination$iv$iv;
        ImmutableList.Builder builder2 = builder = ImmutableList.builder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        DimensionCombinatorKt.createProductFlavorCombinations$default(flavorDimensionList, flavorMap2, builder2, this.errorReporter, null, 0, 48, null);
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return this.combineFlavorsAndBuildTypes((List)immutableList);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DimensionCombination> combineFlavorsAndBuildTypes(List<FlavorCombinationBuilder> flavorCombos) {
        if (this.variantInputModel.getBuildTypes().isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = flavorCombos;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FlavorCombinationBuilder flavorCombinationBuilder = (FlavorCombinationBuilder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DimensionCombinationImpl dimensionCombinationImpl = new DimensionCombinationImpl(null, (List)it.getFlavorPairs(), 1, null);
                collection.add(dimensionCombinationImpl);
            }
            return (List)destination$iv$iv;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String buildType : this.variantInputModel.getBuildTypes().keySet()) {
            Collection<DimensionCombinationImpl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable destination$iv$iv = flavorCombos;
            ImmutableList.Builder builder2 = builder;
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FlavorCombinationBuilder flavorCombinationBuilder = (FlavorCombinationBuilder)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                DimensionCombinationImpl dimensionCombinationImpl = new DimensionCombinationImpl(buildType, (List)it.getFlavorPairs());
                collection.add(dimensionCombinationImpl);
            }
            collection = (List)destination$iv$iv2;
            builder2.addAll((Iterable)collection);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    private final List<String> validateFlavorDimensions() {
        if (this.flavorDimensionList.isEmpty()) {
            IssueReporter.reportError$default((IssueReporter)this.errorReporter, (IssueReporter.Type)IssueReporter.Type.UNNAMED_FLAVOR_DIMENSION, (String)"All flavors must now belong to a named flavor dimension. Learn more at https://d.android.com/r/tools/flavorDimensions-missing-error-message.html", null, null, (int)12, null);
            boolean bl = false;
            Set dimensions = new LinkedHashSet();
            for (ProductFlavorData<ProductFlavor> flavor : this.variantInputModel.getProductFlavors().values()) {
                ProductFlavor productFlavor;
                Intrinsics.checkExpressionValueIsNotNull((Object)flavor.getProductFlavor(), (String)"flavor.productFlavor");
                String dim = productFlavor.getDimension();
                if (dim == null) {
                    productFlavor.setDimension(FAKE_DIMENSION);
                    continue;
                }
                dimensions.add(dim);
            }
            if (dimensions.isEmpty()) {
                dimensions.add(FAKE_DIMENSION);
            }
            return CollectionsKt.toList((Iterable)dimensions);
        }
        if (this.flavorDimensionList.size() == 1) {
            String dimensionName = this.flavorDimensionList.get(0);
            for (ProductFlavorData<ProductFlavor> flavorData : this.variantInputModel.getProductFlavors().values()) {
                ProductFlavor flavor;
                Intrinsics.checkExpressionValueIsNotNull((Object)flavorData.getProductFlavor(), (String)"flavorData.productFlavor");
                if (flavor.getDimension() != null) continue;
                flavor.setDimension(dimensionName);
            }
        }
        return this.flavorDimensionList;
    }

    public DimensionCombinator(@NotNull VariantInputModel variantInputModel, @NotNull IssueReporter errorReporter, @NotNull VariantType variantType, @NotNull List<String> flavorDimensionList) {
        Intrinsics.checkParameterIsNotNull((Object)variantInputModel, (String)"variantInputModel");
        Intrinsics.checkParameterIsNotNull((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkParameterIsNotNull((Object)variantType, (String)"variantType");
        Intrinsics.checkParameterIsNotNull(flavorDimensionList, (String)"flavorDimensionList");
        this.variantInputModel = variantInputModel;
        this.errorReporter = errorReporter;
        this.variantType = variantType;
        this.flavorDimensionList = flavorDimensionList;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/variant/DimensionCombinator$Companion;", "", "()V", "FAKE_DIMENSION", "", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

