/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.component.impl.UnitTestPropertiesImpl;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.api.variant.impl.TestVariantPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class TestVariantFactory
extends ApplicationVariantFactory {
    public TestVariantFactory(GlobalScope globalScope) {
        super(globalScope);
    }

    @Override
    public boolean hasTestScope() {
        return false;
    }

    @Override
    public VariantImpl createVariantObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo) {
        return (VariantImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(TestVariantImpl.class, new Object[]{variantDslInfo, componentIdentity});
    }

    @Override
    public UnitTestImpl createUnitTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo) {
        throw new RuntimeException("cannot instantiate unit-test in test plugin");
    }

    @Override
    public AndroidTestImpl createAndroidTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo) {
        throw new RuntimeException("cannot instantiate android-test in test plugin");
    }

    @Override
    public VariantPropertiesImpl createVariantPropertiesObject(ComponentIdentity componentIdentity, VariantScope variantScope) {
        return (VariantPropertiesImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(TestVariantPropertiesImpl.class, new Object[]{this.globalScope.getDslScope(), variantScope, variantScope.getArtifacts().getOperations(), componentIdentity});
    }

    @Override
    public UnitTestPropertiesImpl createUnitTestProperties(ComponentIdentity componentIdentity, VariantScope variantScope) {
        throw new RuntimeException("cannot instantiate unit-test properties in test plugin");
    }

    @Override
    public AndroidTestPropertiesImpl createAndroidTestProperties(ComponentIdentity componentIdentity, VariantScope variantScope) {
        throw new RuntimeException("cannot instantiate android-test properties in test plugin");
    }

    @Override
    public void preVariantWork(Project project2) {
        super.preVariantWork(project2);
        TestAndroidConfig testExtension = (TestAndroidConfig)((Object)this.globalScope.getExtension());
        String path = testExtension.getTargetProjectPath();
        if (path == null) {
            throw new GradleException("targetProjectPath cannot be null in test project " + project2.getName());
        }
        DependencyHandler handler = project2.getDependencies();
        ImmutableMap projectNotation = ImmutableMap.of((Object)"path", (Object)path);
        handler.add("compileOnly", (Object)handler.project((Map)projectNotation));
        Configuration testedApks = (Configuration)project2.getConfigurations().maybeCreate("testedApks");
        testedApks.setCanBeConsumed(false);
        testedApks.setCanBeResolved(false);
        handler.add("testedApks", (Object)handler.project((Map)projectNotation));
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
    }

    public static String getTestedApksConfigurationName(String variantName) {
        return StringHelper.appendCapitalized((String)variantName, (String)"testedApks");
    }

    @Override
    public VariantType getVariantType() {
        return VariantTypeImpl.TEST_APK;
    }
}

