/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.VariantOutput;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.UnitTestVariantImpl;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dsl.VariantOutputFactory;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.VariantTypeImpl;

public class ApiObjectFactory {
    private final BaseExtension extension;
    private final VariantFactory<?, ?> variantFactory;
    private final GlobalScope globalScope;
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();

    public ApiObjectFactory(BaseExtension extension, VariantFactory<?, ?> variantFactory, GlobalScope globalScope) {
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.globalScope = globalScope;
    }

    public BaseVariantImpl create(VariantPropertiesImpl variantProperties) {
        BaseVariantData variantData = variantProperties.getVariantData();
        BaseVariantImpl variantApi = this.variantFactory.createVariantApi(this.globalScope, variantProperties, variantData, this.readOnlyObjectProvider);
        if (variantApi == null) {
            return null;
        }
        if (this.variantFactory.getVariantType().getHasTestComponents()) {
            ComponentPropertiesImpl unitTestVariantProperties;
            BaseServices services2 = this.variantFactory.getServicesForOldVariantObjectsOnly();
            ComponentPropertiesImpl androidTestVariantProperties = variantProperties.getTestComponents().get(VariantTypeImpl.ANDROID_TEST);
            if (androidTestVariantProperties != null) {
                TestVariantImpl androidTestVariant = services2.newInstance(TestVariantImpl.class, androidTestVariantProperties.getVariantData(), androidTestVariantProperties, variantApi, services2, this.readOnlyObjectProvider, this.globalScope.getProject().container(VariantOutput.class));
                this.createVariantOutput(androidTestVariantProperties, androidTestVariant);
                ((TestedAndroidConfig)((Object)this.extension)).getTestVariants().add((Object)androidTestVariant);
                ((TestedVariant)((Object)variantApi)).setTestVariant(androidTestVariant);
            }
            if ((unitTestVariantProperties = variantProperties.getTestComponents().get(VariantTypeImpl.UNIT_TEST)) != null) {
                UnitTestVariantImpl unitTestVariant = services2.newInstance(UnitTestVariantImpl.class, unitTestVariantProperties.getVariantData(), unitTestVariantProperties, variantApi, services2, this.readOnlyObjectProvider, this.globalScope.getProject().container(VariantOutput.class));
                ((TestedAndroidConfig)((Object)this.extension)).getUnitTestVariants().add((Object)unitTestVariant);
                ((TestedVariant)((Object)variantApi)).setUnitTestVariant(unitTestVariant);
            }
        }
        this.createVariantOutput(variantProperties, variantApi);
        try {
            this.extension.addVariant(variantApi);
        }
        catch (Throwable t) {
            throw new ExternalApiUsageException(t);
        }
        return variantApi;
    }

    private void createVariantOutput(ComponentPropertiesImpl componentProperties, BaseVariantImpl variantApi) {
        BaseServices services2 = this.variantFactory.getServicesForOldVariantObjectsOnly();
        VariantOutputFactory variantOutputFactory = new VariantOutputFactory(componentProperties.getVariantType().isAar() ? LibraryVariantOutputImpl.class : ApkVariantOutputImpl.class, services2, this.extension, variantApi, componentProperties.getTaskContainer(), services2.getDeprecationReporter());
        componentProperties.getOutputs().forEach(variantOutputFactory::create);
    }
}

