/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.api.SourceKind;
import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantImpl
implements BaseVariant {
    public static final String TASK_ACCESS_DEPRECATION_URL = "https://d.android.com/r/tools/task-configuration-avoidance";
    public static final String USE_PROPERTIES_DEPRECATION_URL = "https://d.android.com/r/tools/use-properties";
    protected final ComponentPropertiesImpl componentProperties;
    protected final BaseServices services;
    protected final ReadOnlyObjectProvider readOnlyObjectProvider;
    protected final NamedDomainObjectContainer<BaseVariantOutput> outputs;

    BaseVariantImpl(ComponentPropertiesImpl componentProperties, BaseServices services2, ReadOnlyObjectProvider readOnlyObjectProvider, NamedDomainObjectContainer<BaseVariantOutput> outputs) {
        this.componentProperties = componentProperties;
        this.services = services2;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
        this.outputs = outputs;
    }

    protected abstract BaseVariantData getVariantData();

    public void addOutputs(List<BaseVariantOutput> outputs) {
        this.outputs.addAll(outputs);
    }

    @Override
    public String getName() {
        return this.componentProperties.getName();
    }

    @Override
    public String getDescription() {
        return this.getVariantData().getDescription();
    }

    @Override
    public String getDirName() {
        return this.componentProperties.getDirName();
    }

    @Override
    public String getBaseName() {
        return this.componentProperties.getBaseName();
    }

    @Override
    public String getFlavorName() {
        return this.componentProperties.getFlavorName();
    }

    @Override
    public DomainObjectCollection<BaseVariantOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    public BuildType getBuildType() {
        VariantDslInfoImpl variantDslInfo = (VariantDslInfoImpl)this.componentProperties.getVariantDslInfo();
        return this.readOnlyObjectProvider.getBuildType(variantDslInfo.getBuildTypeObj());
    }

    @Override
    public List<ProductFlavor> getProductFlavors() {
        return new ImmutableFlavorList(this.componentProperties.getVariantDslInfo().getProductFlavorList(), this.readOnlyObjectProvider);
    }

    @Override
    public ProductFlavor getMergedFlavor() {
        VariantDslInfoImpl variantDslInfo = (VariantDslInfoImpl)this.componentProperties.getVariantDslInfo();
        return variantDslInfo.getMergedFlavor();
    }

    @Override
    public JavaCompileOptions getJavaCompileOptions() {
        return this.componentProperties.getVariantDslInfo().getJavaCompileOptions();
    }

    @Override
    public List<SourceProvider> getSourceSets() {
        return this.componentProperties.getVariantSources().getSortedSourceProviders();
    }

    @Override
    public List<ConfigurableFileTree> getSourceFolders(SourceKind folderType) {
        switch (folderType) {
            case JAVA: {
                return this.componentProperties.getJavaSources();
            }
        }
        this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "Unknown SourceKind value: " + (Object)((Object)folderType));
        return ImmutableList.of();
    }

    @Override
    public Configuration getCompileConfiguration() {
        return this.getVariantData().getVariantDependencies().getCompileClasspath();
    }

    @Override
    public Configuration getRuntimeConfiguration() {
        return this.getVariantData().getVariantDependencies().getRuntimeClasspath();
    }

    @Override
    public Configuration getAnnotationProcessorConfiguration() {
        return this.getVariantData().getVariantDependencies().getAnnotationProcessorConfiguration();
    }

    @Override
    public String getApplicationId() {
        if (this.componentProperties.getVariantType().isDynamicFeature()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "variant.getApplicationId() is not supported by dynamic-feature plugins as it cannot handle delayed setting of the application ID. Please use getApplicationIdTextResource() instead.");
        }
        return this.componentProperties.getVariantDslInfo().getApplicationId();
    }

    @Override
    public TextResource getApplicationIdTextResource() {
        this.services.getDeprecationReporter().reportDeprecatedApi("VariantProperties.applicationId", "BaseVariant.getApplicationIdTextResource", "TBD", DeprecationReporter.DeprecationTarget.VERSION_5_0);
        return this.getVariantData().applicationIdTextResource;
    }

    @Override
    public Task getPreBuild() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getPreBuildProvider()", "variant.getPreBuild()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.componentProperties.getTaskContainer().getPreBuildTask().get();
    }

    @Override
    public TaskProvider<Task> getPreBuildProvider() {
        return this.componentProperties.getTaskContainer().getPreBuildTask();
    }

    @Override
    public Task getCheckManifest() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getCheckManifestProvider()", "variant.getCheckManifest()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.componentProperties.getTaskContainer().getCheckManifestTask().get();
    }

    @Override
    public TaskProvider<Task> getCheckManifestProvider() {
        return this.componentProperties.getTaskContainer().getCheckManifestTask();
    }

    @Override
    public AidlCompile getAidlCompile() {
        if (!this.componentProperties.getBuildFeatures().getAidl()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "aidl support is disabled via buildFeatures.");
            return null;
        }
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getAidlCompileProvider()", "variant.getAidlCompile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (AidlCompile)this.componentProperties.getTaskContainer().getAidlCompileTask().get();
    }

    @Override
    public TaskProvider<AidlCompile> getAidlCompileProvider() {
        if (!this.componentProperties.getBuildFeatures().getAidl()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "aidl support is disabled via buildFeatures.");
            return null;
        }
        return this.componentProperties.getTaskContainer().getAidlCompileTask();
    }

    @Override
    public RenderscriptCompile getRenderscriptCompile() {
        if (!this.componentProperties.getBuildFeatures().getRenderScript()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "renderscript support is disabled via buildFeatures.");
            return null;
        }
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getRenderscriptCompileProvider()", "variant.getRenderscriptCompile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (RenderscriptCompile)this.componentProperties.getTaskContainer().getRenderscriptCompileTask().get();
    }

    @Override
    public TaskProvider<RenderscriptCompile> getRenderscriptCompileProvider() {
        if (!this.componentProperties.getBuildFeatures().getRenderScript()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "renderscript support is disabled via buildFeatures.");
            return null;
        }
        return this.getVariantData().getTaskContainer().getRenderscriptCompileTask();
    }

    @Override
    public MergeResources getMergeResources() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getMergeResourcesProvider()", "variant.getMergeResources()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (MergeResources)this.componentProperties.getTaskContainer().getMergeResourcesTask().getOrNull();
    }

    @Override
    public TaskProvider<MergeResources> getMergeResourcesProvider() {
        return this.componentProperties.getTaskContainer().getMergeResourcesTask();
    }

    @Override
    public MergeSourceSetFolders getMergeAssets() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getMergeAssetsProvider()", "variant.getMergeAssets()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (MergeSourceSetFolders)this.componentProperties.getTaskContainer().getMergeAssetsTask().getOrNull();
    }

    @Override
    public TaskProvider<MergeSourceSetFolders> getMergeAssetsProvider() {
        return this.getVariantData().getTaskContainer().getMergeAssetsTask();
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getGenerateBuildConfigProvider()", "variant.getGenerateBuildConfig()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (GenerateBuildConfig)this.componentProperties.getTaskContainer().getGenerateBuildConfigTask().get();
    }

    @Override
    public TaskProvider<GenerateBuildConfig> getGenerateBuildConfigProvider() {
        return this.componentProperties.getTaskContainer().getGenerateBuildConfigTask();
    }

    @Override
    public JavaCompile getJavaCompile() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getJavaCompileProvider()", "variant.getJavaCompile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (JavaCompile)this.componentProperties.getTaskContainer().getJavacTask().get();
    }

    @Override
    public TaskProvider<JavaCompile> getJavaCompileProvider() {
        return this.getVariantData().getTaskContainer().getJavacTask();
    }

    @Override
    public Task getJavaCompiler() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getJavaCompileProvider()", "variant.getJavaCompiler()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.componentProperties.getTaskContainer().getJavacTask().get();
    }

    @Override
    public Collection<ExternalNativeBuildTask> getExternalNativeBuildTasks() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getExternalNativeBuildProviders()", "variant.getExternalNativeBuildTask()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return this.getExternalNativeBuildProviders().stream().map(Provider::get).collect(Collectors.toList());
    }

    @Override
    public Collection<TaskProvider<ExternalNativeBuildTask>> getExternalNativeBuildProviders() {
        TaskProvider<? extends ExternalNativeBuildTask> provider = this.componentProperties.getTaskContainer().getExternalNativeBuildTask();
        if (provider == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(provider);
    }

    @Override
    public Task getObfuscation() {
        return null;
    }

    @Override
    public File getMappingFile() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getMappingFileProvider()", "variant.getMappingFile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        BuildArtifactsHolder artifacts2 = this.componentProperties.getArtifacts();
        RegularFile mappingFile = (RegularFile)artifacts2.getFinalProduct(InternalArtifactType.APK_MAPPING.INSTANCE).getOrNull();
        return mappingFile != null ? mappingFile.getAsFile() : null;
    }

    @Override
    public Provider<FileCollection> getMappingFileProvider() {
        return this.componentProperties.getArtifacts().getFinalProductAsFileCollection(InternalArtifactType.APK_MAPPING.INSTANCE);
    }

    public Sync getProcessJavaResources() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getProcessJavaResourcesProvider()", "variant.getProcessJavaResources()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Sync)this.componentProperties.getTaskContainer().getProcessJavaResourcesTask().get();
    }

    @Override
    public TaskProvider<AbstractCopyTask> getProcessJavaResourcesProvider() {
        return this.getVariantData().getTaskContainer().getProcessJavaResourcesTask();
    }

    @Override
    public Task getAssemble() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getAssembleProvider()", "variant.getAssemble()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.componentProperties.getTaskContainer().getAssembleTask().get();
    }

    @Override
    public TaskProvider<Task> getAssembleProvider() {
        return this.componentProperties.getTaskContainer().getAssembleTask();
    }

    @Override
    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerExternalAptJavaOutput(ConfigurableFileTree folder) {
        this.getVariantData().registerExternalAptJavaOutput(folder);
    }

    @Override
    public void registerGeneratedResFolders(FileCollection folders) {
        this.getVariantData().registerGeneratedResFolders(folders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public Object registerPreJavacGeneratedBytecode(FileCollection fileCollection2) {
        return this.getVariantData().registerPreJavacGeneratedBytecode(fileCollection2);
    }

    @Override
    @Deprecated
    public Object registerGeneratedBytecode(FileCollection fileCollection2) {
        return this.registerPreJavacGeneratedBytecode(fileCollection2);
    }

    @Override
    public void registerPostJavacGeneratedBytecode(FileCollection fileCollection2) {
        this.getVariantData().registerPostJavacGeneratedBytecode(fileCollection2);
    }

    @Override
    public FileCollection getCompileClasspath(Object generatorKey) {
        return this.componentProperties.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES_JAR, generatorKey);
    }

    @Override
    public ArtifactCollection getCompileClasspathArtifacts(Object generatorKey) {
        return this.componentProperties.getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES_JAR, generatorKey);
    }

    @Override
    public void buildConfigField(String type, String name2, String value) {
        this.componentProperties.getVariantDslInfo().addBuildConfigField(type, name2, value);
    }

    @Override
    public void resValue(String type, String name2, String value) {
        this.componentProperties.getVariantDslInfo().addResValue(type, name2, value);
    }

    @Override
    public void missingDimensionStrategy(String dimension, String requestedValue) {
        this.componentProperties.handleMissingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.of((Object)requestedValue));
    }

    @Override
    public void missingDimensionStrategy(String dimension, String ... requestedValues) {
        this.componentProperties.handleMissingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.copyOf((Object[])requestedValues));
    }

    @Override
    public void missingDimensionStrategy(String dimension, List<String> requestedValues) {
        this.componentProperties.handleMissingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.copyOf(requestedValues));
    }

    @Override
    public void setOutputsAreSigned(boolean isSigned) {
        this.getVariantData().outputsAreSigned = isSigned;
    }

    @Override
    public boolean getOutputsAreSigned() {
        return this.getVariantData().outputsAreSigned;
    }

    @Override
    public FileCollection getAllRawAndroidResources() {
        return this.getVariantData().getAllRawAndroidResources();
    }

    @Override
    public void register(Task task) {
        TaskProvider<? extends Zip> bundleLibraryTask;
        MutableTaskContainer taskContainer = this.componentProperties.getTaskContainer();
        TaskFactoryUtils.dependsOn(taskContainer.getAssembleTask(), task);
        TaskProvider<? extends Task> bundleTask = taskContainer.getBundleTask();
        if (bundleTask != null) {
            TaskFactoryUtils.dependsOn(bundleTask, task);
        }
        if ((bundleLibraryTask = taskContainer.getBundleLibraryTask()) != null) {
            TaskFactoryUtils.dependsOn(bundleLibraryTask, task);
        }
    }
}

