/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.gradle.internal.services.DslServices;
import com.android.builder.core.AbstractProductFlavor;
import com.android.builder.core.DefaultVectorDrawablesOptions;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.VectorDrawablesOptions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/core/MergedFlavor;", "Lcom/android/builder/core/AbstractProductFlavor;", "name", "", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "(Ljava/lang/String;Lcom/android/build/gradle/internal/services/DslServices;)V", "_vectorDrawables", "Lcom/android/builder/core/DefaultVectorDrawablesOptions;", "vectorDrawables", "getVectorDrawables", "()Lcom/android/builder/core/DefaultVectorDrawablesOptions;", "value", "", "versionCode", "getVersionCode", "()Ljava/lang/Integer;", "setVersionCode", "(Ljava/lang/Integer;)V", "versionName", "getVersionName", "()Ljava/lang/String;", "setVersionName", "(Ljava/lang/String;)V", "_initWith", "", "that", "Lcom/android/builder/model/BaseConfig;", "reportErrorWithWorkaround", "fieldName", "outputFieldName", "fieldValue", "", "Companion", "gradle"})
public final class MergedFlavor
extends AbstractProductFlavor {
    private DefaultVectorDrawablesOptions _vectorDrawables;
    private final DslServices dslServices;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public DefaultVectorDrawablesOptions getVectorDrawables() {
        return this._vectorDrawables;
    }

    @Override
    public void _initWith(@NotNull BaseConfig that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        super._initWith(that);
        if (that instanceof ProductFlavor) {
            DefaultVectorDrawablesOptions defaultVectorDrawablesOptions = DefaultVectorDrawablesOptions.copyOf((VectorDrawablesOptions)((ProductFlavor)that).getVectorDrawables());
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultVectorDrawablesOptions, (String)"DefaultVectorDrawablesOp\u2026yOf(that.vectorDrawables)");
            this._vectorDrawables = defaultVectorDrawablesOptions;
        }
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        return super.getVersionCode();
    }

    @Override
    public void setVersionCode(@Nullable Integer value) {
        this.reportErrorWithWorkaround("versionCode", "versionCodeOverride", value);
    }

    @Override
    @Nullable
    public String getVersionName() {
        return super.getVersionName();
    }

    @Override
    public void setVersionName(@Nullable String value) {
        this.reportErrorWithWorkaround("versionName", "versionNameOverride", value);
    }

    private final void reportErrorWithWorkaround(String fieldName, String outputFieldName, Object fieldValue) {
        String formattedFieldValue = fieldValue instanceof String ? "\"" + fieldValue + "\"" : String.valueOf(fieldValue);
        String message = StringsKt.trimMargin$default((String)(fieldName + " cannot be set on a mergedFlavor directly.\n                |" + outputFieldName + " can instead be set for variant outputs using the following syntax:\n                |android {\n                |    applicationVariants.all { variant ->\n                |        variant.outputs.each { output ->\n                |            output." + outputFieldName + " = " + formattedFieldValue + "\n                |        }\n                |    }\n                |}"), null, (int)1, null);
        IssueReporter.reportError$default((IssueReporter)this.dslServices.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message, null, null, (int)12, null);
    }

    public MergedFlavor(@NotNull String name2, @NotNull DslServices dslServices) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
        super(name2);
        this.dslServices = dslServices;
        this._vectorDrawables = new DefaultVectorDrawablesOptions();
    }

    @JvmStatic
    @NotNull
    public static final MergedFlavor clone(@NotNull ProductFlavor productFlavor, @NotNull DslServices dslServices) {
        return Companion.clone(productFlavor, dslServices);
    }

    @JvmStatic
    @NotNull
    public static final MergedFlavor mergeFlavors(@NotNull ProductFlavor lowestPriority, @NotNull List<? extends ProductFlavor> flavors, @NotNull DslServices dslServices) {
        return Companion.mergeFlavors(lowestPriority, flavors, dslServices);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/core/MergedFlavor$Companion;", "", "()V", "clone", "Lcom/android/build/gradle/internal/core/MergedFlavor;", "productFlavor", "Lcom/android/builder/model/ProductFlavor;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "mergeFlavors", "lowestPriority", "flavors", "", "gradle"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MergedFlavor clone(@NotNull ProductFlavor productFlavor, @NotNull DslServices dslServices) {
            Intrinsics.checkParameterIsNotNull((Object)productFlavor, (String)"productFlavor");
            Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
            MergedFlavor mergedFlavor = new MergedFlavor(productFlavor.getName(), dslServices);
            mergedFlavor._initWith((BaseConfig)productFlavor);
            return mergedFlavor;
        }

        @JvmStatic
        @NotNull
        public final MergedFlavor mergeFlavors(@NotNull ProductFlavor lowestPriority, @NotNull List<? extends ProductFlavor> flavors, @NotNull DslServices dslServices) {
            Intrinsics.checkParameterIsNotNull((Object)lowestPriority, (String)"lowestPriority");
            Intrinsics.checkParameterIsNotNull(flavors, (String)"flavors");
            Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
            MergedFlavor mergedFlavor = this.clone(lowestPriority, dslServices);
            Iterator iterator = Lists.reverse(flavors).iterator();
            while (iterator.hasNext()) {
                ProductFlavor flavor;
                ProductFlavor productFlavor = flavor = (ProductFlavor)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"flavor");
                mergedFlavor.mergeWithHigherPriorityFlavor(productFlavor);
            }
            String applicationIdSuffix = lowestPriority.getApplicationIdSuffix();
            String versionNameSuffix = lowestPriority.getVersionNameSuffix();
            for (ProductFlavor productFlavor : flavors) {
                applicationIdSuffix = AbstractProductFlavor.Companion.mergeApplicationIdSuffix(productFlavor.getApplicationIdSuffix(), applicationIdSuffix);
                versionNameSuffix = AbstractProductFlavor.Companion.mergeVersionNameSuffix(productFlavor.getVersionNameSuffix(), versionNameSuffix);
            }
            mergedFlavor.setApplicationIdSuffix(applicationIdSuffix);
            mergedFlavor.setVersionNameSuffix(versionNameSuffix);
            return mergedFlavor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

