/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.variant.impl.ApplicationVariantImpl;
import com.android.build.api.variant.impl.ApplicationVariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.BaseCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.ApplicationTaskManager;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.BundleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.BundleToStandaloneApkTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.SdkDependencyDataGeneratorTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureApplicationIdsTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001Ba\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u001c\u0010\u0016\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0006H\u0002J\u001c\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J \u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J6\u0010#\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00062\u0018\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00060%H\u0014J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/tasks/ApplicationTaskManager;", "Lcom/android/build/gradle/internal/AbstractAppTaskManager;", "Lcom/android/build/api/variant/impl/ApplicationVariantImpl;", "Lcom/android/build/api/variant/impl/ApplicationVariantPropertiesImpl;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/api/component/impl/TestComponentImpl;", "Lcom/android/build/api/component/impl/TestComponentPropertiesImpl;", "hasFlavors", "", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "extension", "Lcom/android/build/gradle/BaseExtension;", "recorder", "Lcom/android/builder/profile/Recorder;", "(Ljava/util/List;Ljava/util/List;ZLcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/BaseExtension;Lcom/android/builder/profile/Recorder;)V", "createAssetPackTasks", "", "variantProperties", "createDynamicBundleTask", "variant", "createGenerateMicroApkDataTask", "config", "Lorg/gradle/api/file/FileCollection;", "createInstallTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "createSoftwareComponent", "suffix", "", "publication", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$PublishedConfigType;", "doCreateTasksForVariant", "allVariants", "", "handleMicroApp", "gradle"})
public final class ApplicationTaskManager
extends AbstractAppTaskManager<ApplicationVariantImpl, ApplicationVariantPropertiesImpl> {
    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<ApplicationVariantImpl, ApplicationVariantPropertiesImpl> variant2, @NotNull List<ComponentInfo<ApplicationVariantImpl, ApplicationVariantPropertiesImpl>> allVariants) {
        Intrinsics.checkParameterIsNotNull(variant2, (String)"variant");
        Intrinsics.checkParameterIsNotNull(allVariants, (String)"allVariants");
        this.createCommonTasks(variant2, allVariants);
        ApplicationVariantPropertiesImpl variantProperties = variant2.getProperties();
        this.taskFactory.register(new FeatureSetMetadataWriterTask.CreationAction(variantProperties));
        this.createValidateSigningTask(variantProperties);
        this.taskFactory.register(new SigningConfigWriterTask.CreationAction(variantProperties));
        BaseExtension baseExtension = this.extension;
        if (baseExtension == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.BaseAppModuleExtension");
        }
        Collection collection = ((BaseAppModuleExtension)baseExtension).getAssetPacks();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.createAssetPackTasks(variantProperties);
        }
        if (variantProperties.getBuildFeatures().getDataBinding()) {
            this.taskFactory.register(new DataBindingExportFeatureApplicationIdsTask.CreationAction(variantProperties));
        }
        this.createDynamicBundleTask(variant2);
        this.handleMicroApp(variantProperties);
        if (!variantProperties.getGlobalScope().hasDynamicFeatures()) {
            this.createSoftwareComponent(variantProperties, "_apk", AndroidArtifacts.PublishedConfigType.APK_PUBLICATION);
        }
        this.createSoftwareComponent(variantProperties, "_aab", AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION);
    }

    private final void handleMicroApp(ApplicationVariantPropertiesImpl variantProperties) {
        VariantDslInfo variantDslInfo = variantProperties.getVariantDslInfo();
        VariantType variantType = variantProperties.getVariantType();
        if (variantType.isBaseModule()) {
            Boolean unbundledWearApp = variantDslInfo.isWearAppUnbundled();
            if (Intrinsics.areEqual((Object)unbundledWearApp, (Object)true) ^ true && variantDslInfo.isEmbedMicroApp()) {
                Configuration configuration2 = variantProperties.getVariantDependencies().getWearAppConfiguration();
                if (configuration2 == null) {
                    String string = "Wear app with no wearApp configuration";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"variantProperties.varian\u2026o wearApp configuration\")");
                Configuration wearApp = configuration2;
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact2 = handleMicroApp.setApkArtifact.1.INSTANCE;
                    ArtifactView artifactView = wearApp.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(setApkArtifact2){
                        final /* synthetic */ Action $setApkArtifact;

                        public final void execute(@NotNull ArtifactView.ViewConfiguration config2) {
                            Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
                            config2.attributes(this.$setApkArtifact);
                        }
                        {
                            this.$setApkArtifact = action;
                        }
                    });
                    Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"wearApp.incoming\n       \u2026                        }");
                    FileCollection files2 = artifactView.getFiles();
                    this.createGenerateMicroApkDataTask(variantProperties, files2);
                }
            } else if (Intrinsics.areEqual((Object)unbundledWearApp, (Object)true)) {
                ApplicationTaskManager.createGenerateMicroApkDataTask$default(this, variantProperties, null, 2, null);
            }
        }
    }

    private final void createGenerateMicroApkDataTask(ApplicationVariantPropertiesImpl variantProperties, FileCollection config2) {
        TaskProvider generateMicroApkTask = this.taskFactory.register(new GenerateApkDataTask.CreationAction(variantProperties, config2));
        TaskFactoryUtils.dependsOn(variantProperties.getTaskContainer().getResourceGenTask(), new TaskProvider[]{generateMicroApkTask});
    }

    static /* synthetic */ void createGenerateMicroApkDataTask$default(ApplicationTaskManager applicationTaskManager, ApplicationVariantPropertiesImpl applicationVariantPropertiesImpl, FileCollection fileCollection2, int n, Object object) {
        if ((n & 2) != 0) {
            fileCollection2 = null;
        }
        applicationTaskManager.createGenerateMicroApkDataTask(applicationVariantPropertiesImpl, fileCollection2);
    }

    private final void createAssetPackTasks(ApplicationVariantPropertiesImpl variantProperties) {
        Project project2 = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        DependencyHandler depHandler = project2.getDependencies();
        List notFound = new ArrayList();
        Project project3 = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Configuration assetPackFilesConfiguration = (Configuration)project3.getConfigurations().maybeCreate("assetPackFiles");
        Project project4 = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        Configuration assetPackManifestConfiguration = (Configuration)project4.getConfigurations().maybeCreate("assetPackManifest");
        BaseExtension baseExtension = this.extension;
        if (baseExtension == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.BaseAppModuleExtension");
        }
        Set<String> assetPacks = ((BaseAppModuleExtension)baseExtension).getAssetPacks();
        for (String assetPack : assetPacks) {
            if (this.project.findProject(assetPack) != null) {
                ImmutableMap immutableMap = ImmutableMap.of((Object)"path", (Object)assetPack, (Object)"configuration", (Object)"packElements");
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.of<String, \u2026ts\"\n                    )");
                Map filesDependency = (Map)immutableMap;
                depHandler.add("assetPackFiles", (Object)depHandler.project(filesDependency));
                ImmutableMap immutableMap2 = ImmutableMap.of((Object)"path", (Object)assetPack, (Object)"configuration", (Object)"manifestElements");
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap2, (String)"ImmutableMap.of<String, \u2026ts\"\n                    )");
                Map manifestDependency = (Map)immutableMap2;
                depHandler.add("assetPackManifest", (Object)depHandler.project(manifestDependency));
                variantProperties.getNeedAssetPackTasks().set((Object)true);
                continue;
            }
            notFound.add(assetPack);
        }
        Object object = variantProperties.getNeedAssetPackTasks().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"variantProperties.needAssetPackTasks.get()");
        if (((Boolean)object).booleanValue()) {
            Configuration configuration2 = assetPackManifestConfiguration;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"assetPackManifestConfiguration");
            ResolvableDependencies resolvableDependencies = configuration2.getIncoming();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"assetPackManifestConfiguration.incoming");
            FileCollection assetPackManifest = resolvableDependencies.getFiles();
            Configuration configuration3 = assetPackFilesConfiguration;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"assetPackFilesConfiguration");
            ResolvableDependencies resolvableDependencies2 = configuration3.getIncoming();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies2, (String)"assetPackFilesConfiguration.incoming");
            FileCollection assetFiles = resolvableDependencies2.getFiles();
            ApkCreationConfig apkCreationConfig = variantProperties;
            FileCollection fileCollection2 = assetPackManifest;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"assetPackManifest");
            Set<String> set = assetPacks.stream().map(createAssetPackTasks.1.INSTANCE).collect(Collectors.toSet());
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"assetPacks\n             \u2026llect(Collectors.toSet())");
            this.taskFactory.register(new ProcessAssetPackManifestTask.CreationAction(apkCreationConfig, fileCollection2, set));
            this.taskFactory.register(new LinkManifestForAssetPackTask.CreationAction(variantProperties));
            ComponentPropertiesImpl componentPropertiesImpl = variantProperties;
            FileCollection fileCollection3 = assetFiles;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection3, (String)"assetFiles");
            this.taskFactory.register(new AssetPackPreBundleTask.CreationAction(componentPropertiesImpl, fileCollection3));
        }
        if (!notFound.isEmpty()) {
            this.getLogger().error("Unable to find matching projects for Asset Packs: " + notFound);
        }
    }

    private final void createDynamicBundleTask(ComponentInfo<ApplicationVariantImpl, ApplicationVariantPropertiesImpl> variant2) {
        ApplicationVariantPropertiesImpl variantProperties = variant2.getProperties();
        if (variantProperties.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(variantProperties, ApplicationTaskManager.access$packagesCustomClassDependencies$s96193096(variantProperties)));
        boolean debuggable = variant2.getVariant().getDebuggable();
        boolean includeSdkInfoInApk = variant2.getVariant().getDependenciesInfo().getIncludeInApk();
        boolean includeSdkInfoInBundle = variant2.getVariant().getDependenciesInfo().getIncludeInBundle();
        if (!debuggable) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(variantProperties));
        }
        if (variantProperties.getVariantType().isBaseModule()) {
            this.taskFactory.register(new ParseIntegrityConfigTask.CreationAction(variantProperties));
            this.taskFactory.register(new PackageBundleTask.CreationAction(variantProperties));
            this.taskFactory.register(new FinalizeBundleTask.CreationAction(variantProperties));
            if (!debuggable) {
                if (includeSdkInfoInBundle) {
                    this.taskFactory.register(new BundleReportDependenciesTask.CreationAction(variantProperties));
                }
                if (includeSdkInfoInApk && variantProperties.getServices().getProjectOptions().get(BooleanOption.INCLUDE_DEPENDENCY_INFO_IN_APKS)) {
                    this.taskFactory.register(new SdkDependencyDataGeneratorTask.CreationAction(variantProperties));
                }
            }
            this.taskFactory.register(new BundleToApkTask.CreationAction(variantProperties));
            this.taskFactory.register(new BundleToStandaloneApkTask.CreationAction(variantProperties));
            this.taskFactory.register(new ExtractApksTask.CreationAction(variantProperties));
        }
    }

    private final void createSoftwareComponent(ApplicationVariantPropertiesImpl variantProperties, String suffix, AndroidArtifacts.PublishedConfigType publication) {
        GlobalScope globalScope = this.globalScope;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"globalScope");
        AdhocComponentWithVariants component2 = globalScope.getComponentFactory().adhoc(variantProperties.getName() + suffix);
        Configuration configuration2 = variantProperties.getVariantDependencies().getElements(publication);
        if (configuration2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"variantProperties.varian\u2026etElements(publication)!!");
        Configuration config2 = configuration2;
        component2.addVariantsFromConfiguration(config2, (Action)createSoftwareComponent.1.INSTANCE);
        Project project2 = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getComponents().add((Object)component2);
    }

    @Override
    protected void createInstallTask(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        if (this.extension instanceof BaseAppModuleExtension && ((BaseAppModuleExtension)this.extension).getDynamicFeatures().isEmpty()) {
            super.createInstallTask(creationConfig);
        } else {
            this.taskFactory.register(new InstallVariantViaBundleTask.CreationAction(creationConfig));
        }
    }

    public ApplicationTaskManager(@NotNull List<ComponentInfo<ApplicationVariantImpl, ApplicationVariantPropertiesImpl>> variants, @NotNull List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> testComponents, boolean hasFlavors, @NotNull GlobalScope globalScope, @NotNull BaseExtension extension, @NotNull Recorder recorder) {
        Intrinsics.checkParameterIsNotNull(variants, (String)"variants");
        Intrinsics.checkParameterIsNotNull(testComponents, (String)"testComponents");
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)recorder, (String)"recorder");
        super(variants, testComponents, hasFlavors, globalScope, extension, recorder);
    }

    public static final /* synthetic */ boolean access$packagesCustomClassDependencies$s96193096(BaseCreationConfig creationConfig) {
        return TaskManager.packagesCustomClassDependencies(creationConfig);
    }
}

