/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class DataBindingExportBuildInfoTask
extends NonIncrementalTask {
    private final Property<LayoutXmlProcessor> xmlProcessor;
    private boolean useAndroidX;
    private File emptyClassOutDir;

    @Inject
    public DataBindingExportBuildInfoTask(ObjectFactory objectFactory) {
        this.xmlProcessor = objectFactory.property(LayoutXmlProcessor.class);
    }

    @Input
    public boolean isUseAndroidX() {
        return this.useAndroidX;
    }

    @Input
    public String getGeneratedClassFileName() {
        return ((LayoutXmlProcessor)this.xmlProcessor.get()).getInfoClassFullName();
    }

    @OutputDirectory
    public File getEmptyClassOutDir() {
        return this.emptyClassOutDir;
    }

    @Override
    protected void doTaskAction() {
        ((LayoutXmlProcessor)this.xmlProcessor.get()).writeEmptyInfoClass(this.useAndroidX);
        Scope.assertNoError();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<DataBindingExportBuildInfoTask, ComponentPropertiesImpl> {
        public CreationAction(ComponentPropertiesImpl componentProperties) {
            super(componentProperties);
        }

        @Override
        public String getName() {
            return this.computeTaskName("dataBindingExportBuildInfo");
        }

        @Override
        public Class<DataBindingExportBuildInfoTask> getType() {
            return DataBindingExportBuildInfoTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends DataBindingExportBuildInfoTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((ComponentPropertiesImpl)this.creationConfig).getTaskContainer().setDataBindingExportBuildInfoTask(taskProvider);
        }

        @Override
        public void configure(DataBindingExportBuildInfoTask task) {
            super.configure(task);
            task.xmlProcessor.set(((ComponentPropertiesImpl)this.creationConfig).getGlobalScope().getProject().provider(((ComponentPropertiesImpl)this.creationConfig)::getLayoutXmlProcessor));
            task.xmlProcessor.disallowChanges();
            task.useAndroidX = ((ComponentPropertiesImpl)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X);
            task.emptyClassOutDir = ((ComponentPropertiesImpl)this.creationConfig).getPaths().getClassOutputForDataBinding();
            task.dependsOn(new Object[]{((ComponentPropertiesImpl)this.creationConfig).getTaskContainer().getSourceGenTask()});
        }
    }
}

