/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.mlkit.codegen.TfliteModelGenerator;
import com.android.tools.mlkit.ModelParsingException;
import java.io.File;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class GenerateMlModelClass
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public abstract DirectoryProperty getModelFileDir();

    @OutputDirectory
    public abstract DirectoryProperty getSourceOutDir();

    @Input
    public abstract Property<String> getPackageName();

    @Override
    protected void doTaskAction() {
        FileTree modelFileTree = this.getModelFileDir().getAsFileTree();
        modelFileTree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                File modelFile = fileVisitDetails.getFile();
                if (modelFile.getName().endsWith(".tflite")) {
                    try {
                        TfliteModelGenerator modelGenerator = new TfliteModelGenerator(modelFile, (String)GenerateMlModelClass.this.getPackageName().get() + ".ml", fileVisitDetails.getRelativePath().getPathString());
                        modelGenerator.generateBuildClass(GenerateMlModelClass.this.getSourceOutDir());
                    }
                    catch (ModelParsingException e) {
                        Logging.getLogger(this.getClass()).warn(e.getMessage());
                    }
                }
            }
        });
    }

    public static class CreationAction
    extends VariantTaskCreationAction<GenerateMlModelClass, ComponentPropertiesImpl> {
        public CreationAction(ComponentPropertiesImpl componentProperties) {
            super(componentProperties);
        }

        @Override
        public void handleProvider(TaskProvider<? extends GenerateMlModelClass> taskProvider) {
            super.handleProvider(taskProvider);
            ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().producesDir(InternalArtifactType.MLKIT_SOURCE_OUT.INSTANCE, taskProvider, GenerateMlModelClass::getSourceOutDir, "out");
        }

        @Override
        public void configure(GenerateMlModelClass task) {
            super.configure(task);
            ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MERGED_ASSETS.INSTANCE, task.getModelFileDir());
            task.getPackageName().set((Object)((ComponentPropertiesImpl)this.creationConfig).getVariantDslInfo().getOriginalApplicationId());
        }

        @Override
        public String getName() {
            return this.computeTaskName("generate", "MlModelClass");
        }

        @Override
        public Class<GenerateMlModelClass> getType() {
            return GenerateMlModelClass.class;
        }
    }
}

