/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BuiltArtifactsSplitOutputMatcher;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.process.ProcessException;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.xml.sax.SAXException;

public class TestDataImpl
extends AbstractTestDataImpl {
    private final AndroidTestPropertiesImpl testVariantData;
    private final VariantDslInfo testVariantDslInfo;

    public TestDataImpl(AndroidTestPropertiesImpl testVariantData, Provider<Directory> testApkDir, FileCollection testedApksDir) {
        super(testVariantData.getVariantDslInfo(), testVariantData.getVariantSources(), testApkDir, testedApksDir);
        this.testVariantData = testVariantData;
        this.testVariantDslInfo = testVariantData.getVariantDslInfo();
        if (testVariantData.getOutputs().getSplitsByType(VariantOutputConfiguration.OutputType.ONE_OF_MANY).size() > 1) {
            throw new RuntimeException("Multi-output in test variant not yet supported");
        }
    }

    @Override
    public void load(File metadataFile) throws ParserConfigurationException, SAXException, IOException {
    }

    @Override
    public String getApplicationId() {
        return this.testVariantData.getVariantDslInfo().getApplicationId();
    }

    @Override
    public String getTestedApplicationId() {
        return this.testVariantDslInfo.getTestedApplicationId();
    }

    @Override
    public boolean isLibrary() {
        VariantPropertiesImpl testedVariant = this.testVariantData.getTestedVariant();
        return testedVariant.getVariantType().isAar();
    }

    public ImmutableList<File> getTestedApks(DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        VariantPropertiesImpl testedVariant = this.testVariantData.getTestedVariant();
        ImmutableList.Builder apks = ImmutableList.builder();
        BuiltArtifactsImpl builtArtifacts = new BuiltArtifactsLoaderImpl().load((Directory)testedVariant.getArtifacts().getFinalProduct(InternalArtifactType.APK.INSTANCE).get());
        if (builtArtifacts == null) {
            return ImmutableList.of();
        }
        apks.addAll(BuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput(deviceConfigProvider, builtArtifacts, testedVariant.getVariantDslInfo().getSupportedAbis()));
        return apks.build();
    }
}

