/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.dsl.BuildFeatures;
import com.android.build.api.dsl.LibraryBuildFeatures;
import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.api.variant.impl.LibraryVariantPropertiesImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.BuildFeatureValuesImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.VariantApiServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;

public class LibraryVariantFactory
extends BaseVariantFactory<LibraryVariantImpl, LibraryVariantPropertiesImpl> {
    public LibraryVariantFactory(ProjectServices projectServices, GlobalScope globalScope) {
        super(projectServices, globalScope);
    }

    @Override
    public LibraryVariantImpl createVariantObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        return (LibraryVariantImpl)this.projectServices.getObjectFactory().newInstance(LibraryVariantImpl.class, new Object[]{variantDslInfo, componentIdentity, variantApiServices});
    }

    @Override
    public LibraryVariantPropertiesImpl createVariantPropertiesObject(LibraryVariantImpl variant2, ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantScope variantScope, BaseVariantData variantData, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        LibraryVariantPropertiesImpl variantProperties = (LibraryVariantPropertiesImpl)this.projectServices.getObjectFactory().newInstance(LibraryVariantPropertiesImpl.class, new Object[]{componentIdentity, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, transformManager, variantPropertiesApiServices, taskCreationServices, this.globalScope});
        String name2 = this.globalScope.getProjectBaseName() + "-" + variantProperties.getBaseName() + "." + "aar";
        variantProperties.addVariantOutput(variantData.getOutputFactory().addMainOutput(name2));
        return variantProperties;
    }

    @Override
    public BuildFeatureValues createBuildFeatureValues(BuildFeatures buildFeatures, ProjectOptions projectOptions) {
        if (buildFeatures instanceof LibraryBuildFeatures) {
            Boolean dataBinding2;
            LibraryBuildFeatures features = (LibraryBuildFeatures)buildFeatures;
            Boolean androidResources = features.getAndroidResources();
            if (androidResources == null) {
                androidResources = projectOptions.get(BooleanOption.BUILD_FEATURE_ANDROID_RESOURCES);
            }
            if ((dataBinding2 = features.getDataBinding()) == null) {
                dataBinding2 = projectOptions.get(BooleanOption.BUILD_FEATURE_DATABINDING);
            }
            return new BuildFeatureValuesImpl(buildFeatures, androidResources, dataBinding2 != false && androidResources != false, projectOptions);
        }
        throw new RuntimeException("buildFeatures not of type DynamicFeatureBuildFeatures");
    }

    @Override
    public BuildFeatureValues createTestBuildFeatureValues(BuildFeatures buildFeatures, DataBindingOptions dataBindingOptions, ProjectOptions projectOptions) {
        return this.createBuildFeatureValues(buildFeatures, projectOptions);
    }

    @Override
    public BaseVariantData createVariantData(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantPropertiesApiServices services2, GlobalScope globalScope, MutableTaskContainer taskContainer) {
        return new LibraryVariantData(componentIdentity, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, services2, globalScope, taskContainer);
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return com.android.build.gradle.internal.api.LibraryVariantImpl.class;
    }

    @Override
    public VariantType getVariantType() {
        return VariantTypeImpl.LIBRARY;
    }

    @Override
    public void validateModel(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model2) {
        String applicationIdSuffix;
        super.validateModel(model2);
        SyncIssueReporter issueReporter = this.projectServices.getIssueReporter();
        DefaultConfig defaultConfig = model2.getDefaultConfigData().getDefaultConfig();
        if (defaultConfig.getApplicationId() != null) {
            String applicationId2 = defaultConfig.getApplicationId();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationId. applicationId is set to '" + applicationId2 + "' in default config.", applicationId2);
        }
        if (defaultConfig.getApplicationIdSuffix() != null) {
            String applicationIdSuffix2 = defaultConfig.getApplicationIdSuffix();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix2 + "' in default config.", applicationIdSuffix2);
        }
        for (BuildTypeData<BuildType> buildTypeData : model2.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = buildTypeData.getBuildType().getApplicationIdSuffix();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in build type '" + buildTypeData.getBuildType().getName() + "'.", applicationIdSuffix);
        }
        for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
            if (((ProductFlavor)productFlavorData.getProductFlavor()).getApplicationId() != null) {
                String applicationId3 = ((ProductFlavor)productFlavorData.getProductFlavor()).getApplicationId();
                issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationId. applicationId is set to '" + applicationId3 + "' in flavor '" + ((ProductFlavor)productFlavorData.getProductFlavor()).getName() + "'.", applicationId3);
            }
            if (((ProductFlavor)productFlavorData.getProductFlavor()).getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = ((ProductFlavor)productFlavorData.getProductFlavor()).getApplicationIdSuffix();
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in flavor '" + ((ProductFlavor)productFlavorData.getProductFlavor()).getName() + "'.", applicationIdSuffix);
        }
    }

    @Override
    public void createDefaultComponents(DslContainerProvider<DefaultConfig, BuildType, ProductFlavor, SigningConfig> dslContainers) {
        dslContainers.getSigningConfigContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("release");
    }
}

