/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.builder.internal.compiler.ShaderProcessor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.process.ExecOperations;

@CacheableTask
public abstract class ShaderCompile
extends NonIncrementalTask {
    private static final PatternSet PATTERN_SET = new PatternSet().include(new String[]{"**/*.vert"}).include(new String[]{"**/*.tesc"}).include(new String[]{"**/*.tese"}).include(new String[]{"**/*.geom"}).include(new String[]{"**/*.frag"}).include(new String[]{"**/*.comp"});
    private Provider<Revision> buildToolInfoRevisionProvider;
    private Provider<File> ndkLocation;
    private List<String> defaultArgs = ImmutableList.of();
    private Map<String, List<String>> scopedArgs = ImmutableMap.of();
    private final ExecOperations execOperations;

    @Input
    public String getBuildToolsVersion() {
        return ((Revision)this.buildToolInfoRevisionProvider.get()).toString();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getSourceDir();

    @Inject
    public ShaderCompile(ExecOperations execOperations) {
        this.execOperations = execOperations;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileTree getSourceFiles() {
        File sourceDirFile = ((Directory)this.getSourceDir().get()).getAsFile();
        FileTree src = null;
        if (sourceDirFile.isDirectory()) {
            src = this.getProject().files(new Object[]{sourceDirFile}).getAsFileTree().matching((PatternFilterable)PATTERN_SET);
        }
        return src == null ? this.getProject().files(new Object[0]).getAsFileTree() : src;
    }

    @Override
    protected void doTaskAction() throws IOException {
        File destinationDir = ((Directory)this.getOutputDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)destinationDir);
        try (WorkerExecutorFacade workers = this.getWorkerFacadeWithThreads(false);){
            this.compileAllShaderFiles(((Directory)this.getSourceDir().get()).getAsFile(), destinationDir, this.defaultArgs, this.scopedArgs, () -> (File)this.ndkLocation.get(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(this.getLogger())), workers);
        }
    }

    private void compileAllShaderFiles(File sourceFolder, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, Supplier<File> ndkLocation, ProcessOutputHandler processOutputHandler, WorkerExecutorFacade workers) throws IOException {
        Preconditions.checkNotNull((Object)sourceFolder, (Object)"sourceFolder cannot be null.");
        Preconditions.checkNotNull((Object)outputDir, (Object)"outputDir cannot be null.");
        Supplier<ShaderProcessor> processor2 = () -> new ShaderProcessor(ndkLocation, sourceFolder, outputDir, defaultArgs, scopedArgs, (ProcessExecutor)new GradleProcessExecutor(arg_0 -> ((ExecOperations)this.execOperations).exec(arg_0)), processOutputHandler, workers);
        DirectoryWalker.builder().root(sourceFolder.toPath()).extensions(new String[]{"vert", "tesc", "tese", "geom", "frag", "comp"}).action(processor2).build().walk();
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Input
    public List<String> getDefaultArgs() {
        return this.defaultArgs;
    }

    public void setDefaultArgs(List<String> defaultArgs) {
        this.defaultArgs = ImmutableList.copyOf(defaultArgs);
    }

    @Input
    public Map<String, List<String>> getScopedArgs() {
        return this.scopedArgs;
    }

    public void setScopedArgs(Map<String, List<String>> scopedArgs) {
        this.scopedArgs = ImmutableMap.copyOf(scopedArgs);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ShaderCompile, ComponentPropertiesImpl> {
        public CreationAction(ComponentPropertiesImpl componentProperties) {
            super(componentProperties);
        }

        @Override
        public String getName() {
            return this.computeTaskName("compile", "Shaders");
        }

        @Override
        public Class<ShaderCompile> getType() {
            return ShaderCompile.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends ShaderCompile> taskProvider) {
            super.handleProvider(taskProvider);
            ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().producesDir(InternalArtifactType.SHADER_ASSETS.INSTANCE, taskProvider, ShaderCompile::getOutputDir, "out");
        }

        @Override
        public void configure(ShaderCompile task) {
            super.configure(task);
            VariantDslInfo variantDslInfo = ((ComponentPropertiesImpl)this.creationConfig).getVariantDslInfo();
            task.ndkLocation = ((ComponentPropertiesImpl)this.creationConfig).getGlobalScope().getSdkComponents().getNdkFolderProvider();
            ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MERGED_SHADERS.INSTANCE, task.getSourceDir());
            task.setDefaultArgs(variantDslInfo.getDefaultGlslcArgs());
            task.setScopedArgs(variantDslInfo.getScopedGlslcArgs());
            task.buildToolInfoRevisionProvider = ((ComponentPropertiesImpl)this.creationConfig).getGlobalScope().getSdkComponents().getBuildToolsRevisionProvider();
        }
    }
}

