/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.MetadataExtractor;
import com.android.tools.mlkit.ModelParsingException;
import com.android.tools.mlkit.ModelVerifier;
import com.android.tools.mlkit.TensorInfo;
import java.util.ArrayList;
import java.util.List;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;

public class ModelInfo {
    private List<TensorInfo> inputs = new ArrayList<TensorInfo>();
    private List<TensorInfo> outputs = new ArrayList<TensorInfo>();
    private String modelName;
    private String modelDescription;
    private String modelVersion;
    private String modelAuthor;
    private String modelLicense;

    private ModelInfo() {
    }

    public List<TensorInfo> getInputs() {
        return this.inputs;
    }

    public List<TensorInfo> getOutputs() {
        return this.outputs;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getModelAuthor() {
        return this.modelAuthor;
    }

    public String getModelLicense() {
        return this.modelLicense;
    }

    public static ModelInfo buildFrom(MetadataExtractor extractor) throws ModelParsingException {
        ModelVerifier.verifyModel(extractor);
        ModelInfo modelInfo = new ModelInfo();
        int inputLength = extractor.getInputTensorCount(0);
        for (int i2 = 0; i2 < inputLength; ++i2) {
            modelInfo.inputs.add(TensorInfo.parseFrom(extractor, TensorInfo.Source.INPUT, i2));
        }
        int outputLength = extractor.getOutputTensorCount(0);
        for (int i3 = 0; i3 < outputLength; ++i3) {
            modelInfo.outputs.add(TensorInfo.parseFrom(extractor, TensorInfo.Source.OUTPUT, i3));
        }
        ModelMetadata modelMetadata = extractor.getModelMetaData();
        modelInfo.modelName = modelMetadata.name();
        modelInfo.modelDescription = modelMetadata.description();
        modelInfo.modelVersion = modelMetadata.version();
        modelInfo.modelAuthor = modelMetadata.author();
        modelInfo.modelLicense = modelMetadata.license();
        return modelInfo;
    }
}

