/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.shrinker;

import com.android.aapt.Resources;
import com.android.build.gradle.internal.res.shrinker.PossibleResourcesMarker;
import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ObfuscatedClasses;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceType;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.w3c.dom.Node;

public class ResourceShrinkerModel {
    private final ShrinkerDebugReporter debugReporter;
    private final ResourceShrinkerUsageModel usageModel = new ResourceShrinkerUsageModel();
    private ObfuscatedClasses obfuscatedClasses = ObfuscatedClasses.NO_OBFUSCATION;
    private final Set<String> strings = Sets.newHashSetWithExpectedSize((int)300);
    private final Map<String, Resources.ResourceTable> resourceTableCache = Maps.newHashMap();
    private boolean foundGetIdentifier = false;
    private boolean foundWebContent = false;

    public ResourceShrinkerModel(ShrinkerDebugReporter debugReporter) {
        this.debugReporter = debugReporter;
    }

    public ShrinkerDebugReporter getDebugReporter() {
        return this.debugReporter;
    }

    public ResourceShrinkerUsageModel getUsageModel() {
        return this.usageModel;
    }

    public ObfuscatedClasses getObfuscatedClasses() {
        return this.obfuscatedClasses;
    }

    public void setObfuscatedClasses(ObfuscatedClasses obfuscatedClasses) {
        this.obfuscatedClasses = obfuscatedClasses;
    }

    public ResourceUsageModel.Resource addResource(ResourceType type, String packageName2, String name2, String value) {
        return this.usageModel.addResource(type, name2, value);
    }

    public ResourceUsageModel.Resource addResource(ResourceType type, String packageName2, String name2, int value) {
        return this.usageModel.addResource(type, name2, value);
    }

    public ResourceUsageModel.Resource getResourceByValue(int resourceId) {
        return this.usageModel.getResource(resourceId);
    }

    public void addStringConstant(String string) {
        this.strings.add(string);
    }

    public boolean isFoundGetIdentifier() {
        return this.foundGetIdentifier;
    }

    public void setFoundGetIdentifier(boolean foundGetIdentifier) {
        this.foundGetIdentifier = foundGetIdentifier;
    }

    public boolean isFoundWebContent() {
        return this.foundWebContent;
    }

    public void setFoundWebContent(boolean foundWebContent) {
        this.foundWebContent = foundWebContent;
    }

    public Set<String> getStrings() {
        return this.strings;
    }

    public List<ResourceUsageModel.Resource> findUnused() {
        return this.usageModel.findUnused();
    }

    public void keepPossiblyReferencedResources() {
        if (this.strings.isEmpty() || !this.usageModel.isSafeMode() || !this.foundGetIdentifier && !this.foundWebContent) {
            return;
        }
        this.debugReporter.debug((Function0<String>)((Function0)() -> "android.content.res.Resources#getIdentifier present: " + this.foundGetIdentifier + "\nWeb content present: " + this.foundWebContent + "\nReferenced Strings:\n" + this.strings.stream().map(s -> s.trim().replace("\n", "\\n")).filter(s -> !s.isEmpty()).map(s -> s.length() > 40 ? s.substring(0, 37) + "..." : s).collect(Collectors.joining("\n"))));
        new PossibleResourcesMarker(this.debugReporter, this.usageModel, this.strings, this.foundWebContent).markPossibleResourcesReachable();
    }

    public Resources.ResourceTable readResourceTable(Path resourceTablePath) {
        return this.resourceTableCache.computeIfAbsent(resourceTablePath.toString(), path -> {
            try {
                return Resources.ResourceTable.parseFrom((byte[])Files.readAllBytes(resourceTablePath));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public class ResourceShrinkerUsageModel
    extends ResourceUsageModel {
        public File file;

        protected boolean ignoreToolsAttributes() {
            return true;
        }

        protected List<ResourceUsageModel.Resource> findRoots(List<ResourceUsageModel.Resource> resources) {
            List roots = super.findRoots(resources);
            ResourceShrinkerModel.this.debugReporter.debug((Function0<String>)((Function0)() -> "\nThe root reachable resources are:\n" + Joiner.on((String)",\n   ").join((Iterable)roots)));
            return roots;
        }

        protected ResourceUsageModel.Resource declareResource(ResourceType type, String name2, Node node) {
            ResourceUsageModel.Resource resource = super.declareResource(type, name2, node);
            resource.addLocation(this.file);
            return resource;
        }

        protected void referencedString(String string) {
            if (string.isEmpty() || string.length() > 80) {
                return;
            }
            ResourceShrinkerModel.this.addStringConstant(string);
            ResourceShrinkerModel.this.setFoundWebContent(true);
        }
    }
}

